/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.security.Injectable;
import org.apache.cxf.systest.jaxrs.security.SecureBook;
import org.apache.cxf.systest.jaxrs.security.SecureBookInterface;

@Path(value="/bookstorestorage/")
public class SecureBookStore
implements SecureBookInterface,
Injectable {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private SecureBookInterface subresource;
    private SecurityContext securityContext;

    public SecureBookStore() {
        Book book = new Book();
        book.setId(123L);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }

    @Context
    public void setSecurityContext(SecurityContext sc) {
        this.securityContext = sc;
    }

    @Resource
    public void setBookStore(SecureBookInterface sb) {
        this.subresource = sb;
    }

    public Book getThatBook(Long id) {
        return this.books.get(id);
    }

    public Book getThatBook(Long id, String s) {
        if (s == null) {
            throw new RuntimeException();
        }
        return this.books.get(id);
    }

    public Book getThatBook() throws BookNotFoundFault {
        if (this.securityContext.isUserInRole("ROLE_ADMIN") && !this.securityContext.isUserInRole("ROLE_BAZ")) {
            return this.books.get(123L);
        }
        throw new WebApplicationException(403);
    }

    public SecureBookInterface getBookSubResource() throws BookNotFoundFault {
        return this.subresource;
    }

    public Book getDefaultBook() throws BookNotFoundFault {
        return this.books.get(123L);
    }

    @Path(value="/securebook")
    public SecureBook getSecureBook() throws BookNotFoundFault {
        return new SecureBook("CXF in Action", 123L);
    }
}

