/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.UserOperation;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStoreNoAnnotations;
import org.apache.cxf.systest.jaxrs.BookStoreNoAnnotationsImpl;
import org.apache.cxf.systest.jaxrs.BookStoreNoAnnotationsInterface;
import org.apache.cxf.systest.jaxrs.Chapter;
import org.apache.cxf.systest.jaxrs.ChapterNoAnnotations;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSClientServerUserResourceTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerUserResourceTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerUserResourceTest.launchServer(Server.class));
    }

    @Test
    public void testGetBook123() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstoreNoAnnotations/books/123", "application/xml", 200);
    }

    @Test
    public void testGetBookInterface123() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore2/books/123", "application/xml", 200);
    }

    @Test
    public void testGetChapter() throws Exception {
        this.getAndCompareChapter("http://localhost:9080/bookstoreNoAnnotations/books/123/chapter", "application/xml", 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompare(String address, String acceptType, int expectedStatus) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerUserResourceTest.assertEquals((long)expectedStatus, (long)result);
            Book book = this.readBook(get.getResponseBodyAsStream());
            JAXRSClientServerUserResourceTest.assertEquals((long)123L, (long)book.getId());
            JAXRSClientServerUserResourceTest.assertEquals((Object)"CXF in Action", (Object)book.getName());
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompareChapter(String address, String acceptType, int expectedStatus) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerUserResourceTest.assertEquals((long)expectedStatus, (long)result);
            Chapter c = this.readChapter(get.getResponseBodyAsStream());
            JAXRSClientServerUserResourceTest.assertEquals((long)1L, (long)c.getId());
            JAXRSClientServerUserResourceTest.assertEquals((Object)"chapter 1", (Object)c.getTitle());
        }
        finally {
            get.releaseConnection();
        }
    }

    private Book readBook(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Book)u.unmarshal(is);
    }

    private Chapter readChapter(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Chapter.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Chapter)u.unmarshal(is);
    }

    @Ignore
    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
            sf.setAddress("http://localhost:9080/");
            UserResource ur = new UserResource();
            ur.setName(BookStoreNoAnnotations.class.getName());
            ur.setPath("/bookstoreNoAnnotations");
            UserOperation op = new UserOperation();
            op.setPath("/books/{id}");
            op.setName("getBook");
            op.setVerb("GET");
            op.setParameters(Collections.singletonList(new Parameter(ParameterType.PATH, "id")));
            UserOperation op2 = new UserOperation();
            op2.setPath("/books/{id}/chapter");
            op2.setName("getBookChapter");
            op2.setParameters(Collections.singletonList(new Parameter(ParameterType.PATH, "id")));
            ArrayList<UserOperation> ops = new ArrayList<UserOperation>();
            ops.add(op);
            ops.add(op2);
            ur.setOperations(ops);
            UserResource ur2 = new UserResource();
            ur2.setName(ChapterNoAnnotations.class.getName());
            UserOperation op3 = new UserOperation();
            op3.setPath("/");
            op3.setName("getItself");
            op3.setVerb("GET");
            ur2.setOperations(Collections.singletonList(op3));
            sf.setModelBeans(new UserResource[]{ur, ur2});
            String modelRef = "classpath:/org/apache/cxf/systest/jaxrs/resources/resources2.xml";
            sf.setModelRefWithServiceClass(modelRef, new Class[]{BookStoreNoAnnotationsInterface.class});
            sf.setServiceBeans(new Object[]{new BookStoreNoAnnotationsImpl()});
            sf.create();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

