/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.Collections;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.AegisElementProvider;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookDataBindingServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSDataBindingTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSDataBindingTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSDataBindingTest.launchServer(BookDataBindingServer.class));
    }

    @Test
    public void testGetBookJAXB() throws Exception {
        WebClient client = WebClient.create((String)"http://localhost:9080/databinding/jaxb/bookstore/books/123");
        Book book = (Book)client.accept(new String[]{"application/xml"}).get(Book.class);
        JAXRSDataBindingTest.assertEquals((long)123L, (long)book.getId());
        JAXRSDataBindingTest.assertEquals((Object)"CXF in Action", (Object)book.getName());
    }

    @Test
    public void testGetBookAegis() throws Exception {
        WebClient client = WebClient.create((String)"http://localhost:9080/databinding/aegis/bookstore/books/123", Collections.singletonList(new AegisElementProvider()));
        Book book = (Book)client.accept(new String[]{"application/xml"}).get(Book.class);
        JAXRSDataBindingTest.assertEquals((long)123L, (long)book.getId());
        JAXRSDataBindingTest.assertEquals((Object)"CXF in Action", (Object)book.getName());
    }
}

