/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.JMSServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.transport.jms.JMSUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSJmsTest
extends AbstractBusClientServerTestBase {
    protected static boolean serversStarted;

    @BeforeClass
    public static void startServers() throws Exception {
        if (serversStarted) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("activemq.store.dir") != null) {
            props.put("activemq.store.dir", System.getProperty("activemq.store.dir"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        JAXRSJmsTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSJmsTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        JAXRSJmsTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSJmsTest.launchServer(JMSServer.class, (boolean)false));
        serversStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddGetBook() throws Exception {
        Context ctx = this.getContext();
        ConnectionFactory factory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Destination destination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.text");
        Destination replyToDestination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.response");
        Connection connection = null;
        try {
            connection = factory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            this.postBook(session, destination, replyToDestination);
            MessageConsumer consumer = session.createConsumer(replyToDestination);
            javax.jms.Message jmsMessage = consumer.receive(3000L);
            MessageImpl cxfMessage = new MessageImpl();
            byte[] bytes = JMSUtils.retrievePayload((javax.jms.Message)jmsMessage, null);
            cxfMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream(bytes));
            Book b = this.readBook((InputStream)cxfMessage.getContent(InputStream.class));
            JAXRSJmsTest.assertEquals((long)124L, (long)b.getId());
            JAXRSJmsTest.assertEquals((Object)"JMS", (Object)b.getName());
            session.close();
        }
        finally {
            if (connection != null) {
                try {
                    connection.stop();
                    connection.close();
                }
                catch (JMSException ex) {}
            }
        }
    }

    private Context getContext() throws Exception {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", "tcp://localhost:61500");
        return new InitialContext(props);
    }

    private void postBook(Session session, Destination destination, Destination replyTo) throws Exception {
        MessageProducer producer = session.createProducer(destination);
        javax.jms.Message message = JMSUtils.createAndSetPayload((Object)this.writeBook(new Book("JMS", 3L)), (Session)session, (String)"text");
        message.setJMSReplyTo(replyTo);
        message.setStringProperty("Content-Type", "application/xml");
        message.setStringProperty("Accept", "text/xml");
        message.setStringProperty(Message.REQUEST_URI, "/bookstore/books");
        message.setStringProperty(Message.HTTP_REQUEST_METHOD, "POST");
        producer.send(message);
        producer.close();
    }

    private Book readBook(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Book)u.unmarshal(is);
    }

    private String writeBook(Book b) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Marshaller m = c.createMarshaller();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        m.marshal((Object)b, (OutputStream)bos);
        return bos.toString();
    }
}

