/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.systest.jaxrs.BookServerRequestDispatch;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSRequestDispatcherTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSRequestDispatcherTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSRequestDispatcherTest.launchServer(BookServerRequestDispatch.class));
    }

    @Test
    public void testGetBookHTML() throws Exception {
        String endpointAddress = "http://localhost:9080/the/bookstore1/books/html/123";
        WebClient client = WebClient.create((String)endpointAddress);
        client.accept(new String[]{"text/html"});
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(100000000L);
        XMLSource source = (XMLSource)client.accept(new String[]{"text/html"}).get(XMLSource.class);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xhtml", "http://www.w3.org/1999/xhtml");
        namespaces.put("books", "http://www.w3.org/books");
        String value = source.getValue("xhtml:html/xhtml:body/xhtml:ul/books:bookTag", namespaces);
        JAXRSRequestDispatcherTest.assertEquals((Object)"CXF Rocks", (Object)value);
        String ct = client.getResponse().getMetadata().getFirst((Object)"Content-Type").toString();
        JAXRSRequestDispatcherTest.assertEquals((Object)"text/html", (Object)ct);
    }

    @Test
    @Ignore(value="JSP pages need to be precompiled by Maven build")
    public void testGetBookJSPRequestScope() throws Exception {
        String endpointAddress = "http://localhost:9080/the/bookstore2/books/html/123";
        WebClient client = WebClient.create((String)endpointAddress);
        client.accept(new String[]{"text/html"});
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(100000000L);
        String data = (String)client.accept(new String[]{"text/html"}).get(String.class);
        JAXRSRequestDispatcherTest.assertTrue((boolean)data.contains("<h1>Request Book 123</h1>"));
        JAXRSRequestDispatcherTest.assertTrue((boolean)data.contains("<books:bookName>CXF in Action</books:bookName>"));
    }

    @Test
    @Ignore(value="JSP pages need to be precompiled by Maven build")
    public void testGetBookJSPSessionScope() throws Exception {
        String endpointAddress = "http://localhost:9080/the/bookstore3/books/html/456";
        WebClient client = WebClient.create((String)endpointAddress);
        client.accept(new String[]{"text/html"});
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(100000000L);
        String data = (String)client.accept(new String[]{"text/html"}).get(String.class);
        JAXRSRequestDispatcherTest.assertTrue((boolean)data.contains("<h1>Session Book 456</h1>"));
        JAXRSRequestDispatcherTest.assertTrue((boolean)data.contains("<books:bookName>CXF in Action</books:bookName>"));
    }

    @Test
    public void testGetBookHTMLFromDefaultServlet() throws Exception {
        String endpointAddress = "http://localhost:9080/the/bookstore4/books/html/123";
        WebClient client = WebClient.create((String)endpointAddress);
        client.accept(new String[]{"text/html"});
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(100000000L);
        XMLSource source = (XMLSource)client.accept(new String[]{"text/html"}).get(XMLSource.class);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xhtml", "http://www.w3.org/1999/xhtml");
        namespaces.put("books", "http://www.w3.org/books");
        String value = source.getValue("xhtml:html/xhtml:body/xhtml:ul/books:bookTag", namespaces);
        JAXRSRequestDispatcherTest.assertEquals((Object)"CXF Rocks", (Object)value);
    }
}

