/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.security.AbstractSpringSecurityTest;
import org.apache.cxf.systest.jaxrs.security.BookServerSecuritySpringInterface;
import org.apache.cxf.systest.jaxrs.security.SecureBookInterface;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSSpringSecurityInterfaceTest
extends AbstractSpringSecurityTest {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSSpringSecurityInterfaceTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSSpringSecurityInterfaceTest.launchServer(BookServerSecuritySpringInterface.class));
    }

    @Test
    public void testFailedAuthentication() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "ba", 401);
    }

    @Test
    public void testGetBookUserAdmin() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testGetBookUser() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstorestorage/thosebooks/123/123";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
        this.getBook(endpointAddress, "baddy", "baddyspassword", 403);
    }

    @Test
    public void testGetBookAdmin() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstorestorage/thosebooks";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 403);
    }

    @Test
    public void testGetBookSubresource() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstorestorage/subresource";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 403);
    }

    @Test
    public void testWebClientAdmin() throws Exception {
        String address = "http://localhost:9080/bookstorestorage/thosebooks";
        this.doGetBookWebClient(address, "foo", "bar", 200);
    }

    @Test
    public void testProxyClientAdmin() throws Exception {
        String address = "http://localhost:9080/bookstorestorage";
        this.doGetBookProxyClient(address, "foo", "bar", 200);
    }

    @Test
    public void testWebClientUserUnauthorized() throws Exception {
        String address = "http://localhost:9080/bookstorestorage/thosebooks";
        this.doGetBookWebClient(address, "bob", "bobspassword", 403);
    }

    @Test
    public void testWebClientUserAuthorized() throws Exception {
        String address = "http://localhost:9080/bookstorestorage/thosebooks/123/123";
        this.doGetBookWebClient(address, "bob", "bobspassword", 200);
    }

    private void doGetBookWebClient(String address, String username, String password, int expectedStatus) {
        WebClient wc = WebClient.create((String)address, (String)username, (String)password, null);
        Response r = wc.get();
        JAXRSSpringSecurityInterfaceTest.assertEquals((long)expectedStatus, (long)r.getStatus());
        WebClient wc2 = WebClient.fromClient((Client)wc);
        r = wc2.get();
        JAXRSSpringSecurityInterfaceTest.assertEquals((long)expectedStatus, (long)r.getStatus());
    }

    private void doGetBookProxyClient(String address, String username, String password, int expectedStatus) throws BookNotFoundFault {
        SecureBookInterface books = (SecureBookInterface)JAXRSClientFactory.create((String)address, SecureBookInterface.class, (String)username, (String)password, null);
        Book b = books.getThatBook();
        JAXRSSpringSecurityInterfaceTest.assertEquals((long)123L, (long)b.getId());
        Response r = WebClient.client((Object)books).getResponse();
        JAXRSSpringSecurityInterfaceTest.assertEquals((long)expectedStatus, (long)r.getStatus());
    }

    @Test
    public void testGetBookSubresourceAdmin() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstorestorage/securebook/self";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 403);
    }
}

