/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.Books;
import org.apache.cxf.systest.jaxrs.RETRIEVE;

@Path(value="/")
@Produces(value={"application/json"})
public class BookStoreSpring {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private Long mainId = 123L;
    @Context
    private UriInfo ui;
    private boolean postConstructCalled;

    public BookStoreSpring() {
        this.init();
        System.out.println("----books: " + this.books.size());
    }

    @PostConstruct
    public void postConstruct() {
        this.postConstructCalled = true;
    }

    @PreDestroy
    public void preDestroy() {
        System.out.println("PreDestroy called");
    }

    @GET
    @Path(value="/books/list/{id}")
    public Books getBookAsJsonList(@PathParam(value="id") Long id) {
        return new Books(this.books.get(id));
    }

    @GET
    @Path(value="/books/{id}")
    @Produces(value={"application/jettison", "application/json"})
    public Book getBookById(@PathParam(value="id") Long id) {
        return this.books.get(id);
    }

    @GET
    @Path(value="/bookstore/books/{id}")
    @Produces(value={"application/xml"})
    public Book getBookXml(@PathParam(value="id") Long id) {
        return this.books.get(id);
    }

    @GET
    @Path(value="/bookinfo")
    public Book getBookByUriInfo() throws Exception {
        MultivaluedMap params = this.ui.getQueryParameters();
        String id = (String)params.getFirst((Object)"param1") + (String)params.getFirst((Object)"param2");
        return this.books.get(Long.valueOf(id));
    }

    @GET
    @Path(value="/booksquery")
    public Book getBookByQuery(@QueryParam(value="id") String id) {
        if (!this.postConstructCalled) {
            throw new RuntimeException();
        }
        String[] values = id.split("\\+");
        StringBuilder b = new StringBuilder();
        b.append(values[0]).append(values[1]);
        return this.books.get(Long.valueOf(b.toString()));
    }

    @GET
    @Path(value="id={id}")
    public Book getBookByEncodedId(@PathParam(value="id") String id) {
        String[] values = id.split("\\+");
        StringBuilder b = new StringBuilder();
        b.append(values[0]).append(values[1]);
        return this.books.get(Long.valueOf(b.toString()));
    }

    @GET
    public Book getDefaultBook() {
        return this.books.get(this.mainId);
    }

    @POST
    @Path(value="books/convert")
    @Consumes(value={"application/xml", "application/json", "application/jettison"})
    @Produces(value={"application/xml"})
    public Book convertBook(Book2 book) {
        Book b = new Book();
        b.setId(book.getId());
        b.setName(book.getName());
        return b;
    }

    @PUT
    @Path(value="books/convert2/{id}")
    @Consumes(value={"application/xml", "application/json", "application/jettison"})
    @Produces(value={"application/xml"})
    public Book convertBook2(Book2 book) {
        return this.convertBook(book);
    }

    @GET
    @Path(value="books/aegis")
    @Produces(value={"application/html;q=1.0", "application/xml;q=0.5", "application/json;q=0.5"})
    public Book getBookAegis() {
        Book b = new Book();
        b.setId(124L);
        b.setName("CXF in Action - 2");
        return b;
    }

    @RETRIEVE
    @Path(value="books/aegis/retrieve")
    @Produces(value={"application/html;q=0.5", "application/xml;q=1.0", "application/json;q=0.5"})
    public Book getBookAegisRetrieve() {
        return this.getBookAegis();
    }

    @GET
    @Path(value="books/xslt/{id}")
    @Produces(value={"text/html", "application/xhtml+xml", "application/xml"})
    public Book getBookXSLT(@PathParam(value="id") long id, @QueryParam(value="name") String name, @MatrixParam(value="name2") String name2) {
        Book b = new Book();
        b.setId(999L);
        b.setName("CXF in ");
        return b;
    }

    final void init() {
        Book book = new Book();
        book.setId(this.mainId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }
}

