/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.cxf.common.util.Compiler;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.codegen.CodeGeneratorProvider;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.systest.jaxrs.BookServerResourceCreatedSpringProviders;
import org.apache.cxf.systest.jaxrs.PetStore;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSClientServerResourceCreatedSpringProviderTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerResourceCreatedSpringProviderTest.launchServer(BookServerResourceCreatedSpringProviders.class));
    }

    @Test
    public void testMultipleRootsWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:9080/webapp/", "http://localhost:9080/webapp/", 2);
        String path1 = resourceEls.get(0).getAttribute("path");
        int bookStoreInd = path1.contains("/bookstore") ? 0 : 1;
        int petStoreInd = bookStoreInd == 0 ? 1 : 0;
        this.checkBookStoreInfo(resourceEls.get(bookStoreInd));
        this.checkPetStoreInfo(resourceEls.get(petStoreInd));
    }

    @Test
    public void testBookStoreWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:9080/webapp/", "http://localhost:9080/webapp/bookstore", 1);
        this.checkBookStoreInfo(resourceEls.get(0));
    }

    @Test
    public void testPetStoreWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:9080/webapp/", "http://localhost:9080/webapp/petstore", 1);
        this.checkPetStoreInfo(resourceEls.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPetStoreSource() throws Exception {
        try {
            File unzippedSrc;
            WebClient wc = WebClient.create((String)"http://localhost:9080/webapp/petstore");
            HTTPConduit conduit = WebClient.getConfig((Object)wc).getHttpConduit();
            conduit.getClient().setReceiveTimeout(1000000L);
            conduit.getClient().setConnectionTimeout(1000000L);
            XMLSource source = (XMLSource)wc.query("_code", new Object[]{""}).query("_os", new Object[]{this.getOs()}).get(XMLSource.class);
            String link = source.getValue("ns:html/ns:body/ns:ul/ns:a/@href", Collections.singletonMap("ns", "http://www.w3.org/1999/xhtml"));
            WebClient wc2 = WebClient.create((String)link);
            HTTPConduit conduit2 = WebClient.getConfig((Object)wc2).getHttpConduit();
            conduit2.getClient().setReceiveTimeout(1000000L);
            conduit2.getClient().setConnectionTimeout(1000000L);
            InputStream is = (InputStream)wc2.accept(new String[]{"application/zip"}).get(InputStream.class);
            String tmpdir = System.getProperty("java.io.tmpdir");
            File classes = new File(tmpdir, "cxf-jaxrs-test-compiled-src");
            if (!classes.mkdir()) {
                JAXRSClientServerResourceCreatedSpringProviderTest.fail();
            }
            if (!(unzippedSrc = new File(tmpdir, "cxf-jaxrs-test-unzipped-src")).mkdir()) {
                JAXRSClientServerResourceCreatedSpringProviderTest.fail();
            }
            try {
                this.compileSrc(classes, unzippedSrc, is);
                this.verifyClasses(classes);
            }
            finally {
                FileUtils.removeDir((File)classes);
                FileUtils.removeDir((File)unzippedSrc);
            }
        }
        finally {
            ClassResourceInfo cri = ResourceUtils.createClassResourceInfo(PetStore.class, PetStore.class, (boolean)true, (boolean)true);
            new CodeGeneratorProvider().removeCode(cri);
        }
    }

    private void verifyClasses(File classesDir) {
        List clsFiles = FileUtils.getFilesRecurse((File)classesDir, (String)".+\\.class$");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)1L, (long)clsFiles.size());
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)this.checkContains(clsFiles, "org.apache.cxf.systest.jaxrs.PetStore.class"));
    }

    private boolean checkContains(List<File> clsFiles, String name) {
        for (File f : clsFiles) {
            if (!f.getAbsolutePath().replace(this.getPathSep(), ".").endsWith(name)) continue;
            return true;
        }
        return false;
    }

    private String getPathSep() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("win")) {
            return "\\";
        }
        return "/";
    }

    private void checkBookStoreInfo(Element resource) {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"/bookstore", (Object)resource.getAttribute("path"));
    }

    private void checkPetStoreInfo(Element resource) {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"/petstore/", (Object)resource.getAttribute("path"));
    }

    private List<Element> getWadlResourcesInfo(String baseURI, String requestURI, int size) throws Exception {
        WebClient client = WebClient.create((String)(requestURI + "?_wadl&_type=xml"));
        Document doc = DOMUtils.readXml((Reader)new InputStreamReader((InputStream)client.get(InputStream.class), "UTF-8"));
        Element root = doc.getDocumentElement();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"http://research.sun.com/wadl/2006/10", (Object)root.getNamespaceURI());
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"application", (Object)root.getLocalName());
        List resourcesEls = DOMUtils.getChildrenWithName((Element)root, (String)"http://research.sun.com/wadl/2006/10", (String)"resources");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)1L, (long)resourcesEls.size());
        Element resourcesEl = (Element)resourcesEls.get(0);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)baseURI, (Object)resourcesEl.getAttribute("base"));
        List resourceEls = DOMUtils.getChildrenWithName((Element)resourcesEl, (String)"http://research.sun.com/wadl/2006/10", (String)"resource");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)size, (long)resourceEls.size());
        return resourceEls;
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        connect.addRequestProperty("Content-Language", "badgerFishLanguage");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123badgerfish.txt");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"BadgerFish output not correct", (Object)this.getStringFromInputStream(expected).trim(), (Object)this.getStringFromInputStream(in).trim());
    }

    @Test
    public void testGetBookNotFound() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/bookstore/books/12345";
        URL url = new URL(endpointAddress);
        HttpURLConnection connect = (HttpURLConnection)url.openConnection();
        connect.addRequestProperty("Accept", "text/plain,application/xml");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)500L, (long)connect.getResponseCode());
        InputStream in = connect.getErrorStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book_notfound_mapped.txt");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Exception is not mapped correctly", (Object)this.getStringFromInputStream(expected).trim(), (Object)this.getStringFromInputStream(in).trim());
    }

    @Test
    public void testGetBookNotExistent() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/bookstore/nonexistent";
        URL url = new URL(endpointAddress);
        HttpURLConnection connect = (HttpURLConnection)url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)405L, (long)connect.getResponseCode());
        InputStream in = connect.getErrorStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Exception is not mapped correctly", (Object)"Nonexistent method", (Object)this.getStringFromInputStream(in).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostPetStatus() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/petstore/pets";
        URL url = new URL(endpointAddress);
        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setDefaultUseCaches(false);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Accept", "text/xml");
        httpUrlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        httpUrlConnection.setRequestProperty("Connection", "close");
        OutputStream outputstream = httpUrlConnection.getOutputStream();
        File inputFile = new File(((Object)((Object)this)).getClass().getResource("resources/singleValPostBody.txt").toURI());
        byte[] tmp = new byte[4096];
        int i = 0;
        FileInputStream is = new FileInputStream(inputFile);
        try {
            while ((i = ((InputStream)is).read(tmp)) >= 0) {
                outputstream.write(tmp, 0, i);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        outputstream.flush();
        int responseCode = httpUrlConnection.getResponseCode();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)200L, (long)responseCode);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Wrong status returned", (Object)"open", (Object)this.getStringFromInputStream(httpUrlConnection.getInputStream()));
        httpUrlConnection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostPetStatus2() throws Exception {
        Socket s = new Socket("localhost", 9080);
        IOUtils.copyAndCloseInput((InputStream)((Object)((Object)this)).getClass().getResource("resources/formRequest.txt").openStream(), (OutputStream)s.getOutputStream());
        s.getOutputStream().flush();
        try {
            JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((String)"Wrong status returned", (boolean)this.getStringFromInputStream(s.getInputStream()).contains("open"));
        }
        finally {
            s.close();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }

    private void compileSrc(File classes, File unzippedSrc, InputStream zipFile) throws Exception {
        this.unzip(zipFile, unzippedSrc);
        StringBuilder classPath = new StringBuilder();
        try {
            JAXRSClientServerResourceCreatedSpringProviderTest.setupClasspath(classPath, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        List srcFiles = FileUtils.getFilesRecurse((File)unzippedSrc, (String)".+\\.java$");
        if (!this.compileJavaSrc(classPath.toString(), srcFiles, classes.toString())) {
            JAXRSClientServerResourceCreatedSpringProviderTest.fail((String)"Could not compile classes");
        }
    }

    private void unzip(InputStream fin, File unzippedSrc) throws Exception {
        ZipInputStream zin = new ZipInputStream(fin);
        ZipEntry ze = null;
        while ((ze = zin.getNextEntry()) != null) {
            String entryName = ze.getName();
            int index = entryName.lastIndexOf(System.getProperty("file.separator"));
            File packageDir = new File(unzippedSrc, entryName.substring(0, index));
            packageDir.mkdirs();
            FileOutputStream fout = new FileOutputStream(new File(packageDir, entryName.substring(index + 1)));
            int c = zin.read();
            while (c != -1) {
                fout.write(c);
                c = zin.read();
            }
            zin.closeEntry();
            fout.close();
        }
        zin.close();
    }

    protected boolean compileJavaSrc(String classPath, List<File> srcList, String dest) {
        String[] javacCommand = new String[srcList.size() + 7];
        javacCommand[0] = "javac";
        javacCommand[1] = "-classpath";
        javacCommand[2] = classPath;
        javacCommand[3] = "-d";
        javacCommand[4] = dest;
        javacCommand[5] = "-target";
        javacCommand[6] = "1.5";
        int i = 7;
        for (File f : srcList) {
            javacCommand[i++] = f.getAbsolutePath();
        }
        Compiler javaCompiler = new Compiler();
        return javaCompiler.internalCompile(javacCommand, 7);
    }

    static void setupClasspath(StringBuilder classPath, ClassLoader classLoader) throws URISyntaxException, IOException {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ClassLoader tcl = classLoader;
        do {
            if (!(tcl instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)tcl).getURLs();
            if (urls == null) {
                urls = new URL[]{};
            }
            for (URL url : urls) {
                File file;
                if (!url.getProtocol().startsWith("file") || url.toURI().getPath() == null) continue;
                try {
                    file = new File(url.toURI().getPath());
                }
                catch (URISyntaxException urise) {
                    if (url.getPath() == null) continue;
                    file = new File(url.getPath());
                }
                if (!file.exists()) continue;
                classPath.append(file.getAbsolutePath()).append(System.getProperty("path.separator"));
                if (!file.getName().endsWith(".jar")) continue;
                JAXRSClientServerResourceCreatedSpringProviderTest.addClasspathFromManifest(classPath, file);
            }
        } while (null != (tcl = tcl.getParent()) && !tcl.equals(scl.getParent()));
    }

    static void addClasspathFromManifest(StringBuilder classPath, File file) throws URISyntaxException, IOException {
        JarFile jar = new JarFile(file);
        Attributes attr = null;
        if (jar.getManifest() != null) {
            attr = jar.getManifest().getMainAttributes();
        }
        if (attr != null) {
            String cp = attr.getValue("Class-Path");
            while (cp != null) {
                URI uri;
                File f2;
                String fileName = cp;
                int idx = fileName.indexOf(32);
                if (idx != -1) {
                    fileName = fileName.substring(0, idx);
                    cp = cp.substring(idx + 1).trim();
                } else {
                    cp = null;
                }
                if (!(f2 = (uri = new URI(fileName)).isAbsolute() ? new File(uri) : new File(file, fileName)).exists()) continue;
                classPath.append(f2.getAbsolutePath());
                classPath.append(System.getProperty("path.separator"));
            }
        }
    }

    private String getOs() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("win")) {
            return "win";
        }
        return "unix";
    }
}

