/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.systest.jaxrs.AtomBookServer;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.codehaus.jettison.json.JSONObject;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSAtomBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = AtomBookServer.PORT;
    private Abdera abdera = new Abdera();

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSAtomBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSAtomBookTest.launchServer(AtomBookServer.class));
    }

    @Test
    public void testGetBooks() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/bookstore/books/feed";
        Feed feed = this.getFeed(endpointAddress, null);
        JAXRSAtomBookTest.assertEquals((Object)("http://localhost:" + PORT + "/bookstore/bookstore/books/feed"), (Object)feed.getBaseUri().toString());
        JAXRSAtomBookTest.assertEquals((Object)"Collection of Books", (Object)feed.getTitle());
        this.getAndCompareJson("http://localhost:" + PORT + "/bookstore/bookstore/books/feed", "resources/expected_atom_books_json.txt", "application/json");
        this.getAndCompareJson("http://localhost:" + PORT + "/bookstore/bookstore/books/jsonfeed", "resources/expected_atom_books_jsonfeed.txt", "application/json, text/html, application/xml;q=0.9, application/xhtml+xml, image/png, image/jpeg, image/gif, image/x-xbitmap, */*;q=0.1");
        Entry entry = this.addEntry(endpointAddress);
        entry = this.addEntry(endpointAddress + "/relative");
        endpointAddress = "http://localhost:" + PORT + "/bookstore/bookstore/books/subresources/123";
        entry = this.getEntry(endpointAddress, null);
        JAXRSAtomBookTest.assertEquals((Object)"CXF in Action", (Object)entry.getTitle());
        this.getAndCompareJson("http://localhost:" + PORT + "/bookstore/bookstore/books/entries/123", "resources/expected_atom_book_json.txt", "application/json");
        this.getAndCompareJson("http://localhost:" + PORT + "/bookstore/bookstore/books/entries/123?_type=" + "application/json", "resources/expected_atom_book_json.txt", "*/*");
        this.getAndCompareJson("http://localhost:" + PORT + "/bookstore/bookstore/books/entries/123?_type=" + "json", "resources/expected_atom_book_json.txt", "*/*");
        this.getAndCompareJson("http://localhost:" + PORT + "/bookstore/bookstore/books/entries/123.json", "resources/expected_atom_book_json.txt", "*/*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry addEntry(String endpointAddress) throws Exception {
        Entry e = this.createBookEntry(256, "AtomBook");
        StringWriter w = new StringWriter();
        e.writeTo((Writer)w);
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestEntity((RequestEntity)new StringRequestEntity(w.toString(), "application/atom+xml", null));
        HttpClient httpclient = new HttpClient();
        String location = null;
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSAtomBookTest.assertEquals((long)201L, (long)result);
            location = post.getResponseHeader("Location").getValue();
            InputStream ins = post.getResponseBodyAsStream();
            Document entryDoc = this.abdera.getParser().parse(this.copyIn(ins));
            JAXRSAtomBookTest.assertEquals((Object)((Entry)entryDoc.getRoot()).toString(), (Object)e.toString());
        }
        finally {
            post.releaseConnection();
        }
        Entry entry = this.getEntry(location, null);
        JAXRSAtomBookTest.assertEquals((Object)location, (Object)entry.getBaseUri().toString());
        JAXRSAtomBookTest.assertEquals((Object)"AtomBook", (Object)entry.getTitle());
        return entry;
    }

    @Test
    public void testGetBooks2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/sub/";
        Feed feed = this.getFeed(endpointAddress, null);
        JAXRSAtomBookTest.assertEquals((Object)("http://localhost:" + PORT + "/bookstore/sub/"), (Object)feed.getBaseUri().toString());
        JAXRSAtomBookTest.assertEquals((Object)"Collection of Books", (Object)feed.getTitle());
        this.getAndCompareJson("http://localhost:" + PORT + "/bookstore/sub/books/entries/123.json", "resources/expected_atom_book_json2.txt", "*/*");
    }

    @Test
    public void testGetBooks3() throws Exception {
        this.getAndCompareJson("http://localhost:" + PORT + "/atom/atom/books/entries/123.json", "resources/expected_atom_book_json3.txt", "*/*");
    }

    @Test
    public void testGetBooksWithCustomProvider() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/bookstore4/books/feed";
        Feed feed = this.getFeed(endpointAddress, null);
        JAXRSAtomBookTest.assertEquals((Object)("http://localhost:" + PORT + "/bookstore/bookstore4/books/feed"), (Object)feed.getBaseUri().toString());
        JAXRSAtomBookTest.assertEquals((Object)"Collection of Books", (Object)feed.getTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompareJson(String address, String resourcePath, String type) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Content-Type", "*/*");
        get.setRequestHeader("Accept", type);
        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod((HttpMethod)get);
            String jsonContent = this.getStringFromInputStream(get.getResponseBodyAsStream());
            String expected = this.getStringFromInputStream(((Object)((Object)this)).getClass().getResourceAsStream(resourcePath));
            expected = expected.replaceAll("9080", PORT);
            JSONObject obj1 = new JSONObject(jsonContent);
            JSONObject obj2 = new JSONObject(expected);
            JAXRSAtomBookTest.assertEquals((String)"Atom entry should've been formatted as json", (Object)obj1.toString(), (Object)obj2.toString());
        }
        finally {
            get.releaseConnection();
        }
    }

    private Entry createBookEntry(int id, String name) throws Exception {
        Book b = new Book();
        b.setId(id);
        b.setName(name);
        Factory factory = Abdera.getNewFactory();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Entry e = factory.getAbdera().newEntry();
        e.setTitle(b.getName());
        e.setId(Long.toString(b.getId()));
        StringWriter writer = new StringWriter();
        jc.createMarshaller().marshal((Object)b, (Writer)writer);
        e.setContentElement(factory.newContent());
        e.getContentElement().setContentType(Content.Type.XML);
        e.getContentElement().setValue(writer.toString());
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Feed getFeed(String endpointAddress, String acceptType) throws Exception {
        GetMethod get = new GetMethod(endpointAddress);
        get.setRequestHeader("Content-Type", "*/*");
        if (acceptType != null) {
            get.setRequestHeader("Accept", acceptType);
        }
        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod((HttpMethod)get);
            Document doc = this.abdera.getParser().parse(this.copyIn(get.getResponseBodyAsStream()));
            Feed feed = (Feed)doc.getRoot();
            return feed;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(String endpointAddress, String acceptType) throws Exception {
        GetMethod get = new GetMethod(endpointAddress);
        get.setRequestHeader("Content-Type", "*/*");
        if (acceptType != null) {
            get.setRequestHeader("Accept", acceptType);
        }
        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod((HttpMethod)get);
            Document doc = this.abdera.getParser().parse(this.copyIn(get.getResponseBodyAsStream()));
            Entry entry = (Entry)doc.getRoot();
            return entry;
        }
        finally {
            get.releaseConnection();
        }
    }

    private InputStream copyIn(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        in = bos.getInputStream();
        bos.close();
        return in;
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }
}

