/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.AegisElementProvider;
import org.apache.cxf.jaxrs.provider.DataBindingJSONProvider;
import org.apache.cxf.sdo.SDODataBinding;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookDataBindingServer;
import org.apache.cxf.systest.jaxrs.sdo.SDOResource;
import org.apache.cxf.systest.jaxrs.sdo.Structure;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSDataBindingTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookDataBindingServer.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSDataBindingTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSDataBindingTest.launchServer(BookDataBindingServer.class));
    }

    @Test
    public void testGetBookJAXB() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/databinding/jaxb/bookstore/books/123"));
        Book book = (Book)client.accept(new String[]{"application/xml"}).get(Book.class);
        JAXRSDataBindingTest.assertEquals((long)123L, (long)book.getId());
        JAXRSDataBindingTest.assertEquals((Object)"CXF in Action", (Object)book.getName());
    }

    @Test
    public void testGetBookAegis() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/databinding/aegis/bookstore/books/123"), Collections.singletonList(new AegisElementProvider()));
        Book book = (Book)client.accept(new String[]{"application/xml"}).get(Book.class);
        JAXRSDataBindingTest.assertEquals((long)123L, (long)book.getId());
        JAXRSDataBindingTest.assertEquals((Object)"CXF in Action", (Object)book.getName());
    }

    @Test
    public void testSDOStructure() throws Exception {
        this.doTestSDOStructure("http://localhost:" + PORT + "/databinding/sdo");
    }

    @Test
    public void testSDOStructureWithAnnotation() throws Exception {
        this.doTestSDOStructure("http://localhost:" + PORT + "/databinding/sdo2");
    }

    private void doTestSDOStructure(String address) throws Exception {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setDataBinding((DataBinding)new SDODataBinding());
        bean.setAddress(address);
        bean.setResourceClass(SDOResource.class);
        SDOResource client = (SDOResource)bean.create(SDOResource.class, new Object[0]);
        Structure struct = client.getStructure();
        JAXRSDataBindingTest.assertEquals((Object)"sdo", (Object)struct.getText());
        JAXRSDataBindingTest.assertEquals((double)123.5, (double)struct.getDbl(), (double)0.01);
        JAXRSDataBindingTest.assertEquals((long)3L, (long)struct.getInt());
    }

    @Test
    public void testSDOStructureJSON() throws Exception {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        SDODataBinding db = new SDODataBinding();
        bean.setDataBinding((DataBinding)db);
        DataBindingJSONProvider provider = new DataBindingJSONProvider();
        provider.setNamespaceMap(Collections.singletonMap("http://apache.org/structure/types", "p0"));
        provider.setDataBinding((DataBinding)db);
        bean.setProvider((Object)provider);
        bean.setAddress("http://localhost:" + PORT + "/databinding/sdo");
        bean.setResourceClass(SDOResource.class);
        ArrayList<LoggingInInterceptor> list = new ArrayList<LoggingInInterceptor>();
        list.add(new LoggingInInterceptor());
        bean.setInInterceptors(list);
        SDOResource client = (SDOResource)bean.create(SDOResource.class, new Object[0]);
        WebClient.client((Object)client).accept(new String[]{"application/json"});
        Structure struct = client.getStructure();
        JAXRSDataBindingTest.assertEquals((Object)"sdo", (Object)struct.getText());
        JAXRSDataBindingTest.assertEquals((double)123.5, (double)struct.getDbl(), (double)0.01);
        JAXRSDataBindingTest.assertEquals((long)3L, (long)struct.getInt());
    }
}

