/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.xml.bind.JAXBContext;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.provider.AtomEntryProvider;
import org.apache.cxf.jaxrs.provider.AtomFeedProvider;
import org.apache.cxf.management.web.logging.LogLevel;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.ReadWriteLogStorage;
import org.apache.cxf.management.web.logging.ReadableLogStorage;
import org.apache.cxf.systest.jaxrs.AbstractSpringServer;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSLoggingAtomPullSpringTest
extends AbstractClientServerTestBase {
    public static final String PORT = SpringServer.PORT;
    private static JAXBContext context;
    private int fakyLogger;
    private int namedLogger;
    private int resourceLogger;
    private int throwables;

    @BeforeClass
    public static void beforeClass() throws Exception {
        new Resource();
        new Resource2();
        new Resource3();
        JAXRSLoggingAtomPullSpringTest.launchServer(SpringServer.class, (boolean)true);
        context = JAXBContext.newInstance((Class[])new Class[]{LogRecord.class});
    }

    @Before
    public void before() throws Exception {
        Storage.clearRecords();
    }

    @Test
    public void testFeed() throws Exception {
        String listing = (String)WebClient.create((String)("http://localhost:" + PORT + "/services")).get(String.class);
        JAXRSLoggingAtomPullSpringTest.assertTrue((String)listing, (boolean)listing.contains("http://localhost:" + PORT + "/atom/logs"));
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/resource/root"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        this.checkSimpleFeed(this.getFeed("http://localhost:" + PORT + "/atom/logs").getEntries());
        this.checkSimpleFeed(this.getFeed("http://localhost:" + PORT + "/atom/logs").getEntries());
        LinkedList<Entry> entries = new LinkedList<Entry>();
        WebClient wcEntry = WebClient.create((String)("http://localhost:" + PORT + "/atom/logs"), Collections.singletonList(new AtomEntryProvider())).accept(new String[]{"application/atom+xml;type=entry"});
        HTTPConduit conduit = WebClient.getConfig((Object)wcEntry).getHttpConduit();
        conduit.getClient().setReceiveTimeout(1000000L);
        conduit.getClient().setConnectionTimeout(1000000L);
        for (int i = 0; i < 8; ++i) {
            Entry entry = (Entry)wcEntry.path((Object)("entry/" + i)).get(Entry.class);
            entry.toString();
            entries.add(entry);
            wcEntry.back(true);
        }
        this.checkSimpleFeed(entries);
    }

    private void checkSimpleFeed(List<Entry> entries) throws Exception {
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)8L, (long)entries.size());
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "Resource", "namedLogger");
        }
        this.verifyCounters();
    }

    @Test
    public void testPagedFeed() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/resource2/paged"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        this.verifyPages("http://localhost:" + PORT + "/atom2/logs", "next", 3, 2, "theNamedLogger");
        this.verifyPages("http://localhost:" + PORT + "/atom2/logs/3", "previous", 2, 3, "theNamedLogger");
    }

    @Test
    public void testPagedFeedWithReadWriteStorage() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/resource3/storage"));
        HTTPConduit conduit = WebClient.getConfig((Object)wc).getHttpConduit();
        conduit.getClient().setReceiveTimeout(1000000L);
        conduit.getClient().setConnectionTimeout(1000000L);
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        this.verifyStoragePages("http://localhost:" + PORT + "/atom3/logs", "next", "Resource3", "theStorageLogger");
        List<LogRecord> list = Storage.getRecords();
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)4L, (long)list.size());
        this.verifyStoragePages("http://localhost:" + PORT + "/atom3/logs", "next", "Resource3", "theStorageLogger");
        this.verifyStoragePages("http://localhost:" + PORT + "/atom3/logs/2", "previous", "Resource3", "theStorageLogger");
    }

    @Test
    public void testPagedFeedWithReadOnlyStorage() throws Exception {
        this.verifyStoragePages("http://localhost:" + PORT + "/atom4/logs", "next", "Resource4", "readOnlyStorageLogger");
        this.verifyStoragePages("http://localhost:" + PORT + "/atom4/logs/2", "previous", "Resource4", "readOnlyStorageLogger");
    }

    private void verifyStoragePages(String startAddress, String rel, String resourceName, String nLogger) throws Exception {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String href1 = this.fillPagedEntries(entries, startAddress, 4, rel, true);
        JAXRSLoggingAtomPullSpringTest.assertNull((Object)this.fillPagedEntries(entries, href1, 4, rel, false));
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)8L, (long)entries.size());
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), resourceName, nLogger);
        }
        if ("Resource4".equals(resourceName)) {
            JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.throwables);
            JAXRSLoggingAtomPullSpringTest.assertEquals((long)6L, (long)this.resourceLogger);
            JAXRSLoggingAtomPullSpringTest.assertEquals((long)2L, (long)this.namedLogger);
            JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.fakyLogger);
        } else {
            this.verifyCounters();
        }
    }

    private void verifyPages(String startAddress, String rel, int firstValue, int lastValue, String nLogger) throws Exception {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String href1 = this.fillPagedEntries(entries, startAddress, firstValue, rel, true);
        String href2 = this.fillPagedEntries(entries, href1, 3, rel, true);
        JAXRSLoggingAtomPullSpringTest.assertNull((Object)this.fillPagedEntries(entries, href2, lastValue, rel, false));
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)8L, (long)entries.size());
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "Resource2", nLogger);
        }
        this.verifyCounters();
    }

    private String fillPagedEntries(List<Entry> entries, String href, int expected, String rel, boolean relExpected) {
        Feed feed = this.getFeed(href);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)expected, (long)feed.getEntries().size());
        entries.addAll(feed.getEntries());
        Link link = feed.getLink(rel);
        if (relExpected) {
            JAXRSLoggingAtomPullSpringTest.assertNotNull((Object)link);
            return link.getHref().toString();
        }
        return null;
    }

    private Feed getFeed(String address) {
        WebClient wc = WebClient.create((String)address, Collections.singletonList(new AtomFeedProvider()));
        Feed feed = (Feed)wc.accept(new String[]{"application/atom+xml"}).get(Feed.class);
        feed.toString();
        return feed;
    }

    private static void doLog(Logger l1, Logger l2) {
        l1.severe("severe message");
        l1.warning("warning message");
        l1.info("info message");
        java.util.logging.LogRecord r = new java.util.logging.LogRecord(Level.FINE, "fine message");
        if ("Resource4".equals(l1.getName())) {
            r.setLoggerName(l1.getName());
        }
        r.setThrown(new IllegalArgumentException("tadaam"));
        l1.log(r);
        r = new java.util.logging.LogRecord(Level.FINER, "finer message with {0} and {1}");
        r.setParameters(new Object[]{"param1", "param2"});
        r.setLoggerName("faky-logger");
        l1.log(r);
        l1.finest("finest message");
        l2.severe("severe message");
        l2.severe("severe message2");
        l2.info("info message - should not pass!");
        l2.finer("finer message - should not pass!");
    }

    private LogRecord readLogRecord(String value) throws Exception {
        return (LogRecord)context.createUnmarshaller().unmarshal((Reader)new StringReader(value));
    }

    private void updateCounters(LogRecord record, String clsName, String namedLoggerName) {
        String name = record.getLoggerName();
        if (name != null && name.length() > 0) {
            if (("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$" + clsName).equals(name)) {
                ++this.resourceLogger;
            } else if (namedLoggerName.equals(name)) {
                ++this.namedLogger;
            } else if ("faky-logger".equals(name)) {
                ++this.fakyLogger;
            }
        }
        if (record.getThrowable().length() > 0) {
            ++this.throwables;
        }
    }

    private void resetCounters() {
        this.fakyLogger = 0;
        this.namedLogger = 0;
        this.resourceLogger = 0;
        this.throwables = 0;
    }

    private void verifyCounters() {
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.throwables);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)4L, (long)this.resourceLogger);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)2L, (long)this.namedLogger);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.fakyLogger);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public static class Storage
    implements ReadWriteLogStorage {
        private static List<LogRecord> records = new LinkedList<LogRecord>();

        public void load(List<LogRecord> list, SearchCondition<LogRecord> sc, int from, int quantity) {
            list.addAll(records.subList(from, from + quantity));
        }

        public void save(List<LogRecord> list) {
            records.addAll(list);
        }

        public void clear() {
        }

        public void close() {
        }

        public int getSize() {
            return records.size();
        }

        public static List<LogRecord> getRecords() {
            return records;
        }

        public static void clearRecords() {
            records.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public static class ExternalStorage
    implements ReadableLogStorage {
        private List<LogRecord> records = new LinkedList<LogRecord>();

        public ExternalStorage() {
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.SEVERE, null);
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.WARNING, null);
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.INFO, null);
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.FINE, new IllegalArgumentException());
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.FINEST, null);
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.FINER, null);
            this.addRecord("readOnlyStorageLogger", Level.SEVERE, null);
            this.addRecord("readOnlyStorageLogger", Level.SEVERE, null);
        }

        private void addRecord(String loggerName, Level level, Throwable t) {
            LogRecord lr = new LogRecord();
            lr.setLoggerName(loggerName);
            lr.setLevel(LogLevel.fromJUL((Level)level));
            if (t != null) {
                lr.setThrowable(t);
            }
            this.records.add(lr);
        }

        public void close() {
        }

        public int getSize() {
            return -1;
        }

        public void load(List<LogRecord> list, SearchCondition<LogRecord> condition, int loadFrom, int maxNumberOfRecords) {
            int limit = loadFrom + maxNumberOfRecords;
            for (int i = loadFrom; i < limit; ++i) {
                if (!condition.isMet((Object)this.records.get(i))) continue;
                list.add(this.records.get(i));
            }
        }
    }

    @Ignore
    @Path(value="/storage")
    public static class Resource3 {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource3.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource3.class, null, (String)"theStorageLogger");

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPullSpringTest.doLog(Resource3.LOG1, Resource3.LOG2);
        }
    }

    @Ignore
    @Path(value="/paged")
    public static class Resource2 {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource2.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource2.class, null, (String)"theNamedLogger");

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPullSpringTest.doLog(Resource2.LOG1, Resource2.LOG2);
        }
    }

    @Ignore
    @Path(value="/root")
    public static class Resource {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource.class, null, (String)"namedLogger");

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPullSpringTest.doLog(Resource.LOG1, Resource.LOG2);
        }
    }

    @Ignore
    public static class SpringServer
    extends AbstractSpringServer {
        public SpringServer() {
            super("/jaxrs_logging_atompull");
        }
    }
}

