/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.jaxws;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundDetails;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.BookSubresource;
import org.apache.cxf.systest.jaxrs.BookSubresourceImpl;
import org.apache.cxf.systest.jaxrs.jaxws.BookStoreJaxrsJaxws;

public class BookStoreSoapRestImpl
implements BookStoreJaxrsJaxws {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    @Resource
    private WebServiceContext jaxwsContext;
    @Resource
    private MessageContext jaxrsContext;
    @Resource(name="restClient")
    private BookStoreJaxrsJaxws webClient;
    private boolean invocationInProcess;

    public BookStoreSoapRestImpl() {
        this.init();
    }

    @PostConstruct
    public void verifyWebClient() {
        if (this.webClient == null) {
            throw new RuntimeException();
        }
        WebClient.client((Object)this.webClient).accept(new String[]{"application/xml"});
    }

    public Book getBook(Long id) throws BookNotFoundFault {
        if (this.books.get(id) == null) {
            if (id == 0L) {
                try {
                    ServletOutputStream os = this.jaxrsContext.getHttpServletResponse().getOutputStream();
                    JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
                    Marshaller m = c.createMarshaller();
                    m.marshal((Object)this.books.get(123L), (OutputStream)os);
                    os.flush();
                    return null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException();
                }
            }
            int returnCode = 404;
            if (id == 321L) {
                returnCode = 525;
            } else if (id == 322L) {
                BookNotFoundDetails details = new BookNotFoundDetails();
                details.setId(id);
                throw new BookNotFoundFault(details);
            }
            String msg = "No Book with id " + id + " is available";
            Response.ResponseBuilder builder = Response.status((int)returnCode).header("BOOK-HEADER", (Object)msg);
            if (returnCode == 404) {
                builder.type("text/plain").entity((Object)msg);
            }
            throw new WebApplicationException(builder.build());
        }
        if (!this.invocationInProcess) {
            this.invocationInProcess = true;
            return this.webClient.getBook(id);
        }
        this.invocationInProcess = false;
        System.out.println(this.getContentType());
        return this.books.get(id);
    }

    public Book addBook(Book book) {
        book.setId(124L);
        this.books.put(book.getId(), book);
        return this.books.get(book.getId());
    }

    private void init() {
        Book book = new Book();
        book.setId(new Long(123L));
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }

    private String getContentType() {
        HttpServletRequest request = this.jaxrsContext.getHttpServletRequest();
        if (request == null) {
            request = (HttpServletRequest)this.jaxwsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        }
        return request.getContentType();
    }

    @WebMethod(exclude=true)
    public BookSubresource getBookSubresource(String id) {
        return new BookSubresourceImpl(Long.valueOf(id));
    }

    @WebMethod(exclude=true)
    public BookStoreJaxrsJaxws getBookStore(String id) {
        if (!"number1".equals(id)) {
            throw new WebApplicationException(404);
        }
        return this;
    }

    public Book addFastinfoBook(Book book) {
        return book;
    }

    public Book getFastinfoBook() {
        return new Book("CXF2", 2L);
    }
}

