/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.badgerfish.BadgerFishXMLInputFactory;
import org.codehaus.jettison.badgerfish.BadgerFishXMLOutputFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public final class BadgerFishProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();
    @Context
    private HttpHeaders requestHeaders;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType m) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType m) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType m) {
        return -1L;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) {
        try {
            JAXBContext context = this.getJAXBContext(type);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            BadgerFishXMLInputFactory factory = new BadgerFishXMLInputFactory();
            XMLStreamReader xsw = factory.createXMLStreamReader(is);
            Object obj = unmarshaller.unmarshal(xsw);
            xsw.close();
            return obj;
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void writeTo(Object obj, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) {
        try {
            if (!new Locale("badgerFishLanguage").equals(this.requestHeaders.getLanguage())) {
                throw new RuntimeException();
            }
            JAXBContext context = this.getJAXBContext(obj.getClass());
            Marshaller marshaller = context.createMarshaller();
            BadgerFishXMLOutputFactory factory = new BadgerFishXMLOutputFactory();
            XMLStreamWriter xsw = factory.createXMLStreamWriter(os);
            marshaller.marshal(obj, xsw);
            xsw.close();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJAXBContext(Class type) throws JAXBException {
        Map<Class, JAXBContext> map = jaxbContexts;
        synchronized (map) {
            JAXBContext context = jaxbContexts.get(type);
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{type});
                jaxbContexts.put(type, context);
            }
            return context;
        }
    }
}

