/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSClientServerStreamingTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = JAXRSClientServerStreamingTest.allocatePort(Server.class);

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerStreamingTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerStreamingTest.launchServer(Server.class));
    }

    @Test
    public void testGetBook123() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/books/123", "application/xml", 200);
    }

    @Test
    public void testGetBookUsingStaxWriter() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/books/123", "text/xml", 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompare(String address, String acceptType, int expectedStatus) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerStreamingTest.assertEquals((long)expectedStatus, (long)result);
            Book book = this.readBook(get.getResponseBodyAsStream());
            JAXRSClientServerStreamingTest.assertEquals((long)123L, (long)book.getId());
            JAXRSClientServerStreamingTest.assertEquals((Object)"CXF in Action", (Object)book.getName());
        }
        finally {
            get.releaseConnection();
        }
    }

    private Book readBook(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Book)u.unmarshal(is);
    }

    @Ignore
    public static class CustomJaxbProvider
    extends JAXBElementProvider {
        protected XMLStreamWriter getStreamWriter(Object obj, OutputStream os, MediaType mt) {
            if (mt.equals((Object)MediaType.TEXT_XML_TYPE)) {
                return new CachingXmlEventWriter();
            }
            throw new RuntimeException();
        }
    }

    @Ignore
    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
            sf.setResourceClasses(new Class[]{BookStore.class});
            sf.setResourceProvider(BookStore.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStore()));
            JAXBElementProvider p1 = new JAXBElementProvider();
            p1.setEnableBuffering(true);
            p1.setEnableStreaming(true);
            CustomJaxbProvider p2 = new CustomJaxbProvider();
            p2.setProduceMediaTypes(Collections.singletonList("text/xml"));
            ArrayList<JAXBElementProvider> providers = new ArrayList<JAXBElementProvider>();
            providers.add(p1);
            providers.add(p2);
            sf.setProviders(providers);
            sf.setAddress("http://localhost:" + PORT + "/");
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("org.apache.cxf.serviceloader-context", "true");
            sf.setProperties(properties);
            sf.create();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

