/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityOutFaultInterceptor
extends AbstractPhaseInterceptor<Message> {
    public SecurityOutFaultInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        Fault fault = (Fault)message.getContent(Exception.class);
        Throwable ex = fault.getCause();
        if (!(ex instanceof SecurityException)) {
            throw new RuntimeException("Security Exception is expected");
        }
        HttpServletResponse response = (HttpServletResponse)message.getExchange().getInMessage().get((Object)"HTTP.RESPONSE");
        int status = ex instanceof AccessDeniedException ? 403 : 401;
        response.setStatus(status);
        try {
            response.getOutputStream().write(ex.getMessage().getBytes());
            response.getOutputStream().flush();
        }
        catch (IOException iex) {
            // empty catch block
        }
        message.getInterceptorChain().abort();
    }
}

