/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.systest.jaxrs.BookNoXmlRootElement;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.BookStorePerRequest;
import org.apache.cxf.systest.jaxrs.CustomOutFaultInterceptor;
import org.apache.cxf.systest.jaxrs.CustomOutInterceptor;
import org.apache.cxf.systest.jaxrs.FaultyRequestHandler;
import org.apache.cxf.systest.jaxrs.GenericHandlerWriter;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;

public class BookServer
extends AbstractBusTestServerBase {
    public static final String PORT = BookServer.allocatePort(BookServer.class);

    protected void run() {
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setResourceClasses(new Class[]{BookStore.class, BookStorePerRequest.class});
        ArrayList<Object> providers = new ArrayList<Object>();
        BinaryDataProvider p = new BinaryDataProvider();
        p.setProduceMediaTypes(Collections.singletonList("application/bar"));
        p.setEnableBuffering(true);
        providers.add(p);
        JAXBElementProvider jaxbProvider = new JAXBElementProvider();
        HashMap<String, String> jaxbElementClassMap = new HashMap<String, String>();
        jaxbElementClassMap.put(BookNoXmlRootElement.class.getName(), "BookNoXmlRootElement");
        jaxbProvider.setJaxbElementClassMap(jaxbElementClassMap);
        providers.add(jaxbProvider);
        providers.add(new GenericHandlerWriter());
        providers.add(new FaultyRequestHandler());
        sf.setProviders(providers);
        ArrayList<CustomOutInterceptor> outInts = new ArrayList<CustomOutInterceptor>();
        outInts.add(new CustomOutInterceptor());
        sf.setOutInterceptors(outInts);
        ArrayList<CustomOutFaultInterceptor> outFaultInts = new ArrayList<CustomOutFaultInterceptor>();
        outFaultInts.add(new CustomOutFaultInterceptor());
        sf.setOutFaultInterceptors(outFaultInts);
        sf.setResourceProvider(BookStore.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStore(), true));
        sf.setAddress("http://localhost:" + PORT + "/");
        sf.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            BookServer s = new BookServer();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }
}

