/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookServerResourceCreatedSpring;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerResourceCreatedSpringBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerResourceCreatedSpring.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerResourceCreatedSpringBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerResourceCreatedSpringBookTest.launchServer(BookServerResourceCreatedSpring.class));
    }

    @Test
    public void testGetBookSimple() throws Exception {
        String address = "http://localhost:" + PORT + "/webapp/rest/simplebooks/444";
        JAXRSClientServerResourceCreatedSpringBookTest.assertEquals((long)444L, (long)((Book)WebClient.create((String)address).get(Book.class)).getId());
    }

    @Test
    public void testGetBookSimpleMatrixEnd() throws Exception {
        String address = "http://localhost:" + PORT + "/webapp/rest/simplebooks/444;bookId=ssn";
        JAXRSClientServerResourceCreatedSpringBookTest.assertEquals((long)444L, (long)((Book)WebClient.create((String)address).get(Book.class)).getId());
    }

    @Test
    public void testGetBookSimpleMatrixMiddle() throws Exception {
        String address = "http://localhost:" + PORT + "/webapp/rest/simplebooks/444;bookId=ssn/book";
        JAXRSClientServerResourceCreatedSpringBookTest.assertEquals((long)444L, (long)((Book)WebClient.create((String)address).get(Book.class)).getId());
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/rest/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceCreatedSpringBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSClientServerResourceCreatedSpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testPetStore() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/rest/petstore/pets/24";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "text/xml");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceCreatedSpringBookTest.assertNotNull((Object)in);
        JAXRSClientServerResourceCreatedSpringBookTest.assertEquals((Object)"The Pet Store is closed", (Object)this.getStringFromInputStream(in));
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }
}

