/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.provider.AegisElementProvider;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookServerSpring;
import org.apache.cxf.systest.jaxrs.BookStoreNoAnnotations;
import org.apache.cxf.systest.jaxrs.ChapterNoAnnotations;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSClientServerSpringBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerSpring.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerSpringBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerSpringBookTest.launchServer(BookServerSpring.class));
    }

    @Test
    public void testGetGenericBook() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/the/thebooks8/books";
        WebClient wc = WebClient.create((String)baseAddress);
        Long id = (Long)wc.type("application/xml").accept(new String[]{"text/plain"}).post((Object)new Book("CXF", 1L), Long.class);
        JAXRSClientServerSpringBookTest.assertEquals((Object)new Long(1L), (Object)id);
        Book book = (Book)wc.accept(new String[]{"application/xml"}).query("id", new Object[]{1L}).get(Book.class);
        JAXRSClientServerSpringBookTest.assertEquals((Object)"CXF", (Object)book.getName());
    }

    @Test
    public void testGetBookByUriInfo() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks/bookstore/bookinfo?" + "param1=12&param2=3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetBookWithEncodedSemicolon() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks/bookstore/semicolon%3B";
        WebClient client = WebClient.create((String)endpointAddress);
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        Book book = (Book)client.get(Book.class);
        JAXRSClientServerSpringBookTest.assertEquals((long)333L, (long)book.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)";", (Object)book.getName());
    }

    @Test
    public void testGetBookWithEncodedSemicolonAndMatrixParam() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks/bookstore/semicolon2%3B;a=b";
        WebClient client = WebClient.create((String)endpointAddress);
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        Book book = (Book)client.get(Book.class);
        JAXRSClientServerSpringBookTest.assertEquals((long)333L, (long)book.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)";b", (Object)book.getName());
    }

    @Test
    public void testGetBookXSLTHtml() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks5/bookstore/books/xslt";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xhtml+xml"}).path((Object)666).matrix("name2", new Object[]{2}).query("name", new Object[]{"Action - "});
        XMLSource source = (XMLSource)wc.get(XMLSource.class);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xhtml", "http://www.w3.org/1999/xhtml");
        Book2 b = (Book2)source.getNode("xhtml:html/xhtml:body/xhtml:ul/xhtml:Book", namespaces, Book2.class);
        JAXRSClientServerSpringBookTest.assertEquals((long)666L, (long)b.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)"CXF in Action - 2", (Object)b.getName());
    }

    @Test
    public void testGetBookByUriInfo2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks3/bookstore/bookinfo?" + "param1=12&param2=3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/bookstore/books/123";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt", "application/vnd.example-com.foo+json");
    }

    @Test
    public void testGetBookJsonp() throws Exception {
        String url = "http://localhost:" + PORT + "/the/jsonp/books/123";
        WebClient client = WebClient.create((String)url);
        client.accept(new String[]{"application/json, application/x-javascript"});
        client.query("_jsonp", new Object[]{"callback"});
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        Response r = client.get();
        JAXRSClientServerSpringBookTest.assertEquals((Object)"application/x+javascript", (Object)r.getMetadata().getFirst((Object)"Content-Type"));
        JAXRSClientServerSpringBookTest.assertEquals((Object)"callback({\"Book\":{\"id\":123,\"name\":\"CXF in Action\"}});", (Object)IOUtils.readStringFromStream((InputStream)((InputStream)r.getEntity())));
    }

    @Test
    public void testGetBookWithoutJsonpCallback() throws Exception {
        String url = "http://localhost:" + PORT + "/the/jsonp/books/123";
        WebClient client = WebClient.create((String)url);
        client.accept(new String[]{"application/json, application/x-javascript"});
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        Response r = client.get();
        JAXRSClientServerSpringBookTest.assertEquals((Object)"application/json", (Object)r.getMetadata().getFirst((Object)"Content-Type"));
        JAXRSClientServerSpringBookTest.assertEquals((Object)"{\"Book\":{\"id\":123,\"name\":\"CXF in Action\"}}", (Object)IOUtils.readStringFromStream((InputStream)((InputStream)r.getEntity())));
    }

    @Test
    public void testGetBookAsArray() throws Exception {
        URL url = new URL("http://localhost:" + PORT + "/the/bookstore/books/list/123");
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        InputStream in = connect.getInputStream();
        JAXRSClientServerSpringBookTest.assertEquals((Object)"{\"Books\":{\"books\":[{\"id\":123,\"name\":\"CXF in Action\"}]}}", (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBookWithEncodedQueryValue() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/bookstore/booksquery?id=12%2B3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetBookWithEncodedPathValue() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/bookstore/id=12%2B3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetBookWithEncodedPathValue2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/bookstore/id=12+3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetDefaultBook() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/bookstore";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    private void getBook(String endpointAddress, String resource) throws Exception {
        this.getBook(endpointAddress, resource, "application/json");
    }

    private void getBook(String endpointAddress, String resource, String type) throws Exception {
        this.getBook(endpointAddress, resource, type, null);
    }

    private void getBook(String endpointAddress, String resource, String type, String mHeader) throws Exception {
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Content-Type", "*/*");
        connect.addRequestProperty("Accept", type);
        connect.addRequestProperty("Accept-Encoding", "gzip;q=1.0, identity; q=0.5, *;q=0");
        if (mHeader != null) {
            connect.addRequestProperty("X-HTTP-Method-Override", mHeader);
        }
        InputStream in = connect.getInputStream();
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        JAXRSClientServerSpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    private void getBookAegis(String endpointAddress, String type) throws Exception {
        this.getBookAegis(endpointAddress, type, null);
    }

    private void getBookAegis(String endpointAddress, String type, String mHeader) throws Exception {
        WebClient client = WebClient.create((String)endpointAddress, Collections.singletonList(new AegisElementProvider()));
        if (mHeader != null) {
            client = client.header("X-HTTP-Method-Override", new Object[]{mHeader});
        }
        Book book = (Book)client.accept(new String[]{type}).get(Book.class);
        JAXRSClientServerSpringBookTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)"CXF in Action - 2", (Object)book.getName());
    }

    @Test
    public void testAddInvalidXmlBook() throws Exception {
        this.doPost("http://localhost:" + PORT + "/the/bookstore/books/convert", 400, "application/xml", "resources/add_book.txt", null);
        this.doPost("http://localhost:" + PORT + "/the/thebooks/bookstore/books/convert", 400, "application/xml", "resources/add_book.txt", null);
    }

    @Test
    public void testAddInvalidJsonBook() throws Exception {
        this.doPost("http://localhost:" + PORT + "/the/bookstore/books/convert", 400, "application/json", "resources/add_book2json_invalid.txt", null);
        this.doPost("http://localhost:" + PORT + "/the/thebooks/bookstore/books/convert", 400, "application/json", "resources/add_book2json_invalid.txt", null);
    }

    @Test
    public void testAddValidXmlBook() throws Exception {
        this.doPost("http://localhost:" + PORT + "/the/bookstore/books/convert", 200, "application/xml", "resources/add_book2.txt", "resources/expected_get_book123.txt");
        this.doPost("http://localhost:" + PORT + "/the/thebooks/bookstore/books/convert", 200, "application/xml", "resources/add_book2.txt", "resources/expected_get_book123.txt");
    }

    @Test
    public void testGetBookAegis() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks4/bookstore/books/aegis";
        this.getBookAegis(endpointAddress, "application/xml");
    }

    @Test
    public void testRetrieveBookAegis1() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks4/bookstore/books/aegis/retrieve?_method=RETRIEVE";
        this.getBookAegis(endpointAddress, "application/xml");
    }

    @Test
    public void testRetrieveBookAegis2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks4/bookstore/books/aegis/retrieve";
        this.getBookAegis(endpointAddress, "application/xml", "RETRIEVE");
    }

    @Test
    public void testRetrieveBookAegis3() throws Exception {
        Socket s = new Socket("localhost", Integer.parseInt(PORT));
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/retrieveRequest.txt");
        byte[] bytes = IOUtils.readBytesFromStream((InputStream)is);
        s.getOutputStream().write(bytes);
        s.getOutputStream().flush();
        BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
        StringBuilder sb = new StringBuilder();
        String str = null;
        while ((str = r.readLine()) != null) {
            sb.append(str);
        }
        String aegisData = sb.toString();
        s.getInputStream().close();
        s.close();
        JAXRSClientServerSpringBookTest.assertTrue((boolean)aegisData.contains("CXF in Action - 2"));
    }

    @Test
    public void testGetBookUserResource() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks6/bookstore/books/123";
        this.getBook(endpointAddress, "resources/expected_get_book123.txt", "application/xml");
    }

    @Test
    public void testGetBookUserResource2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks7/bookstore/books/123";
        this.getBook(endpointAddress, "resources/expected_get_book123.txt", "application/xml");
    }

    @Test
    public void testGetBookUserResourceFromProxy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks6";
        BookStoreNoAnnotations bStore = (BookStoreNoAnnotations)JAXRSClientFactory.createFromModel((String)endpointAddress, BookStoreNoAnnotations.class, (String)"classpath:/org/apache/cxf/systest/jaxrs/resources/resources.xml", null);
        Book b = bStore.getBook(123L);
        JAXRSClientServerSpringBookTest.assertNotNull((Object)b);
        JAXRSClientServerSpringBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
        ChapterNoAnnotations proxy = bStore.getBookChapter(123L);
        ChapterNoAnnotations c = proxy.getItself();
        JAXRSClientServerSpringBookTest.assertNotNull((Object)c);
        JAXRSClientServerSpringBookTest.assertEquals((long)1L, (long)c.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)"chapter 1", (Object)c.getTitle());
    }

    @Test
    public void testGetBookXSLTXml() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooks5/bookstore/books/xslt";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).path((Object)666).matrix("name2", new Object[]{2}).query("name", new Object[]{"Action - "});
        Book b = (Book)wc.get(Book.class);
        JAXRSClientServerSpringBookTest.assertEquals((long)666L, (long)b.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)"CXF in Action - 2", (Object)b.getName());
    }

    @Test
    public void testReaderWriterFromJaxrsFilters() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooksWithStax/bookstore/books/convert2/123";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.type("application/xml").accept(new String[]{"application/xml"});
        Book2 b = new Book2();
        b.setId(777L);
        b.setName("CXF - 777");
        Book2 b2 = (Book2)wc.invoke("PUT", (Object)b, Book2.class);
        JAXRSClientServerSpringBookTest.assertNotSame((Object)b, (Object)b2);
        JAXRSClientServerSpringBookTest.assertEquals((long)777L, (long)b2.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)"CXF - 777", (Object)b2.getName());
    }

    @Test
    public void testReaderWriterFromInterceptors() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/the/thebooksWithStax/bookstore/books/convert";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.type("application/xml").accept(new String[]{"application/xml"});
        Book2 b = new Book2();
        b.setId(777L);
        b.setName("CXF - 777");
        Book2 b2 = (Book2)wc.invoke("POST", (Object)b, Book2.class);
        JAXRSClientServerSpringBookTest.assertNotSame((Object)b, (Object)b2);
        JAXRSClientServerSpringBookTest.assertEquals((long)777L, (long)b2.getId());
        JAXRSClientServerSpringBookTest.assertEquals((Object)"CXF - 777", (Object)b2.getName());
    }

    @Test
    public void testAddValidBookJson() throws Exception {
        this.doPost("http://localhost:" + PORT + "/the/bookstore/books/convert", 200, "application/json", "resources/add_book2json.txt", "resources/expected_get_book123.txt");
        this.doPost("http://localhost:" + PORT + "/the/thebooks/bookstore/books/convert", 200, "application/json", "resources/add_book2json.txt", "resources/expected_get_book123.txt");
        this.doPost("http://localhost:" + PORT + "/the/thebooks/bookstore/books/convert", 200, "application/vnd.example-com.foo+json", "resources/add_book2json.txt", "resources/expected_get_book123.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPost(String endpointAddress, int expectedStatus, String contentType, String inResource, String expectedResource) throws Exception {
        File input = new File(((Object)((Object)this)).getClass().getResource(inResource).toURI());
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestHeader("Content-Type", contentType);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerSpringBookTest.assertEquals((long)expectedStatus, (long)result);
            if (expectedStatus != 400) {
                InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream(expectedResource);
                JAXRSClientServerSpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
            } else {
                JAXRSClientServerSpringBookTest.assertTrue((boolean)post.getResponseBodyAsString().contains("Cannot find the declaration of element"));
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }

    @Ignore
    @XmlRootElement(name="Book", namespace="http://www.w3.org/1999/xhtml")
    public static class Book2 {
        @XmlElement(name="id", namespace="http://www.w3.org/1999/xhtml")
        private long id1;
        @XmlElement(name="name", namespace="http://www.w3.org/1999/xhtml")
        private String name1;

        public long getId() {
            return this.id1;
        }

        public void setId(Long theId) {
            this.id1 = theId;
        }

        public String getName() {
            return this.name1;
        }

        public void setName(String n) {
            this.name1 = n;
        }
    }
}

