/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.jaxrs.ext.MessageContext;

@Path(value="/bookstore")
public class BookContinuationStore {
    private Map<String, String> books = new HashMap<String, String>();
    private Map<String, Continuation> suspended = new HashMap<String, Continuation>();
    private Executor executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
    @Resource
    private MessageContext context;

    public BookContinuationStore() {
        this.init();
    }

    @GET
    @Path(value="/books/{id}")
    public String getBookDescription(@PathParam(value="id") String id) {
        return this.handleContinuationRequest(id);
    }

    @Path(value="/books/subresources/")
    public BookContinuationStore getBookStore() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}")
    public String handleContinuationRequest(@PathParam(value="id") String id) {
        Continuation continuation = this.getContinuation(id);
        if (continuation == null) {
            throw new RuntimeException("Failed to get continuation");
        }
        Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (!continuation.isNew()) {
                String savedId = continuation.getObject().toString();
                if (!savedId.equals(id)) {
                    throw new RuntimeException("SavedId is wrong");
                }
                return this.books.get(savedId);
            }
            continuation.setObject((Object)id);
            this.suspendInvocation(id, continuation);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeRequest(String name) {
        Continuation suspendedCont = null;
        Continuation continuation = this.suspended;
        synchronized (continuation) {
            suspendedCont = this.suspended.get(name);
        }
        if (suspendedCont != null) {
            continuation = suspendedCont;
            synchronized (continuation) {
                suspendedCont.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendInvocation(String name, Continuation cont) {
        Map<String, Continuation> map;
        System.out.println("Suspending invocation for " + name);
        try {
            cont.suspend(500000L);
            map = this.suspended;
        }
        catch (Throwable throwable) {
            Map<String, Continuation> map2 = this.suspended;
            synchronized (map2) {
                this.suspended.put(name, cont);
            }
            this.executor.execute(new Runnable(name){
                final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    BookContinuationStore.this.resumeRequest(this.val$name);
                }
            });
            throw throwable;
        }
        synchronized (map) {
            this.suspended.put(name, cont);
        }
        this.executor.execute(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Continuation getContinuation(String name) {
        System.out.println("Getting continuation for " + name);
        Map<String, Continuation> map = this.suspended;
        synchronized (map) {
            Continuation suspendedCont = this.suspended.remove(name);
            if (suspendedCont != null) {
                return suspendedCont;
            }
        }
        ContinuationProvider provider = (ContinuationProvider)this.context.get((Object)ContinuationProvider.class.getName());
        return provider.getContinuation();
    }

    private void init() {
        this.books.put("1", "CXF in Action1");
        this.books.put("2", "CXF in Action2");
        this.books.put("3", "CXF in Action3");
        this.books.put("4", "CXF in Action4");
        this.books.put("5", "CXF in Action5");
    }
}

