/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.annotations.GZIP;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxrs.ext.Oneway;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundDetails;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.BookSubresource;
import org.apache.cxf.systest.jaxrs.BookSubresourceImpl;
import org.apache.cxf.systest.jaxrs.BookWrapper;
import org.apache.cxf.systest.jaxrs.CD;
import org.apache.cxf.systest.jaxrs.CDs;
import org.apache.cxf.systest.jaxrs.GenericHandler;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/bookstore")
@GZIP(threshold=1)
public class BookStore {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private Map<Long, CD> cds = new HashMap<Long, CD>();
    private long bookId = 123L;
    private long cdId = 123L;
    private String currentBookId;
    @PathParam(value="CDId")
    private String currentCdId;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private SecurityContext securityContext;

    public BookStore() {
        this.init();
    }

    @PostConstruct
    public void postConstruct() {
        System.out.println("PostConstruct called");
    }

    @PreDestroy
    public void preDestroy() {
        System.out.println("PreDestroy called");
    }

    @GET
    @Path(value="/books/colon/{a}:{b}:{c}")
    @Produces(value={"application/xml"})
    public Book getBookWithColonMarks(@PathParam(value="a") String id1, @PathParam(value="b") String id2, @PathParam(value="c") String id3) throws BookNotFoundFault {
        return this.doGetBook(id1 + id2 + id3);
    }

    @POST
    @Path(value="emptypost")
    public void emptypost() {
        System.out.println("empty post");
    }

    @GET
    @Path(value="webappexception")
    public Book throwException() {
        Response response = Response.serverError().entity((Object)"This is a WebApplicationException").build();
        throw new WebApplicationException(response);
    }

    @GET
    @Path(value="webappexceptionXML")
    public Book throwExceptionXML() {
        Response response = Response.status((int)406).type("application/xml").entity((Object)"<Book><name>Exception</name><id>999</id></Book>").build();
        throw new WebApplicationException(response);
    }

    @GET
    @Path(value="tempredirect")
    public Response tempRedirectAndSetCookies() {
        URI uri = UriBuilder.fromPath((String)"whatever/redirection").queryParam("css1", new Object[]{"http://bar"}).build(new Object[0]);
        return Response.temporaryRedirect((URI)uri).header("Set-Cookie", (Object)"a=b").header("Set-Cookie", (Object)"c=d").build();
    }

    @GET
    @Path(value="setcookies")
    public Response setComplexCookies() {
        return Response.ok().header("Set-Cookie", (Object)"bar.com.anoncart=107894933471602436; Domain=.bar.com; Expires=Thu, 01-Oct-2020 23:44:22 GMT; Path=/").build();
    }

    @GET
    @Path(value="setmanycookies")
    public Response setTwoCookies() {
        return Response.ok().header("Set-Cookie", (Object)"JSESSIONID=0475F7F30A26E5B0C15D69; Path=/").header("Set-Cookie", (Object)"COOKIETWO=dummy; Expires=Sat, 20-Nov-2010 19:11:32 GMT; Path=/").header("Set-Cookie", (Object)"COOKIETWO=dummy2; expires=Sat, 20-Nov-2010 19:11:32 GMT; Path=/").build();
    }

    @GET
    @Path(value="propagate-exception")
    public Book propogateException() throws BookNotFoundFault {
        throw new BookNotFoundFault("Book Exception");
    }

    @GET
    @Path(value="name-in-query")
    @Produces(value={"application/xml"})
    public Book getBookFromQuery(@QueryParam(value="name") String name) {
        return new Book(name, 321L);
    }

    @GET
    @Path(value="propagate-exception2")
    public Book propogateException2() throws BookNotFoundFault {
        PhaseInterceptorChain.getCurrentMessage().put((Object)"org.apache.cxf.propagate.exception", (Object)Boolean.FALSE);
        throw new BookNotFoundFault("Book Exception");
    }

    @GET
    @Path(value="propagate-exception3")
    public Book propogateException3() throws BookNotFoundFault {
        PhaseInterceptorChain.getCurrentMessage().getExchange().put((Object)"org.apache.cxf.systest.for-out-fault-interceptor", (Object)Boolean.TRUE);
        throw new BookNotFoundFault("Book Exception");
    }

    @GET
    @Path(value="books/check/{id}")
    @Produces(value={"text/plain"})
    public boolean checkBook(@PathParam(value="id") Long id) {
        return this.books.containsKey(id);
    }

    @POST
    @Path(value="books/check2")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Boolean checkBook2(Long id) {
        return this.books.containsKey(id);
    }

    @GET
    @Path(value="timetable")
    public Calendar getTimetable() {
        return new GregorianCalendar();
    }

    @GET
    @Path(value="wrongparametertype")
    public void wrongParameterType(@QueryParam(value="p") Map p) {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @GET
    @Path(value="exceptionduringconstruction")
    public void wrongParameterType(@QueryParam(value="p") BadBook p) {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @POST
    @Path(value="/unsupportedcontenttype")
    @Consumes(value={"application/xml"})
    public String unsupportedContentType() {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @GET
    @Path(value="/bookurl/{URL}/")
    public Book getBookByURL(@PathParam(value="URL") String urlValue) throws Exception {
        String url2 = new URL(urlValue).toString();
        int index = url2.lastIndexOf(47);
        return this.doGetBook(url2.substring(index + 1));
    }

    @POST
    @Path(value="post401")
    public Response get401WithText() throws Exception {
        return Response.status((int)401).entity((Object)"This is 401").build();
    }

    @POST
    @Path(value="/collections")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public List<Book> getBookCollection(List<Book> bs) throws Exception {
        if (bs == null || bs.size() != 2) {
            throw new RuntimeException();
        }
        return bs;
    }

    @GET
    @Path(value="/collections")
    @Produces(value={"application/xml", "application/json"})
    public List<Book> getBookCollection() throws Exception {
        return new ArrayList<Book>(this.books.values());
    }

    @POST
    @Path(value="/array")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Book[] getBookArray(Book[] bs) throws Exception {
        if (bs == null || bs.length != 2) {
            throw new RuntimeException();
        }
        return bs;
    }

    @GET
    @Path(value="/segment/{pathsegment}/")
    public Book getBookBySegment(@PathParam(value="pathsegment") PathSegment segment) throws Exception {
        if (!"matrix2".equals(segment.getPath())) {
            throw new RuntimeException();
        }
        MultivaluedMap map = segment.getMatrixParameters();
        String s1 = ((String)map.getFirst((Object)"first")).toString();
        String s2 = ((String)map.getFirst((Object)"second")).toString();
        return this.doGetBook(s1 + s2);
    }

    @GET
    @Path(value="/segment/list/{pathsegment:.+}/")
    public Book getBookBySegment(@PathParam(value="pathsegment") List<PathSegment> list) throws Exception {
        return this.doGetBook(list.get(0).getPath() + list.get(1).getPath() + list.get(2).getPath());
    }

    @GET
    @Path(value="/segment/matrix")
    public Book getBookByMatrixParams(@MatrixParam(value="first") String s1, @MatrixParam(value="second") String s2) throws Exception {
        return this.doGetBook(s1 + s2);
    }

    @GET
    @Path(value="/segment/matrix-list")
    public Book getBookByMatrixListParams(@MatrixParam(value="first") List<String> list) throws Exception {
        if (list.size() != 2) {
            throw new RuntimeException();
        }
        return this.doGetBook(list.get(0) + list.get(1));
    }

    @GET
    @Path(value="/bookheaders/")
    public Book getBookByHeader(@HeaderParam(value="BOOK") List<String> ids) throws Exception {
        List types = this.httpHeaders.getAcceptableMediaTypes();
        if (types.size() != 2 || !"text/xml".equals(((MediaType)types.get(0)).toString()) || !MediaType.APPLICATION_XML_TYPE.isCompatible((MediaType)types.get(1))) {
            throw new WebApplicationException();
        }
        List locales = this.httpHeaders.getAcceptableLanguages();
        if (locales.size() != 2 || !"en".equals(((Locale)locales.get(0)).getLanguage()) || !"da".equals(((Locale)locales.get(1)).getLanguage())) {
            throw new WebApplicationException();
        }
        Map cookies = this.httpHeaders.getCookies();
        if (!(cookies.size() == 3 && cookies.containsKey("a") && cookies.containsKey("c") && cookies.containsKey("e"))) {
            throw new WebApplicationException();
        }
        List cookiesList = this.httpHeaders.getRequestHeader("Cookie");
        if (!(cookiesList.size() == 3 && cookiesList.contains("a=b") && cookiesList.contains("c=d") && cookiesList.contains("e=f"))) {
            throw new WebApplicationException();
        }
        return this.doGetBook(ids.get(0) + ids.get(1) + ids.get(2));
    }

    @GET
    @Path(value="/bookheaders2/")
    public Book getBookByHeader(@DefaultValue(value="123") @HeaderParam(value="BOOK2") String id) throws Exception {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/getheadbook/")
    public Book getBookGetHead() throws Exception {
        return this.doGetBook("123");
    }

    @HEAD
    @Path(value="/getheadbook/")
    public Response getBookGetHead2() throws Exception {
        return Response.ok().header("HEAD_HEADER", (Object)"HEAD_HEADER_VALUE").build();
    }

    @GET
    @Path(value="/bookquery")
    public Book getBookByURLQuery(@QueryParam(value="urlid") String urlValue) throws Exception {
        String url2 = new URL(urlValue).toString();
        int index = url2.lastIndexOf(47);
        return this.doGetBook(url2.substring(index + 1));
    }

    @GET
    @Path(value="/bookidarray")
    public Book getBookByURLQuery(@QueryParam(value="id") String[] ids) throws Exception {
        if (ids == null || ids.length != 3) {
            throw new WebApplicationException();
        }
        return this.doGetBook(ids[0] + ids[1] + ids[2]);
    }

    @GET
    @Path(value="/securebooks/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getSecureBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        if (!this.securityContext.isSecure()) {
            throw new WebApplicationException(Response.status((int)403).entity((Object)"Unsecure link").build());
        }
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/genericbooks/{bookId}/")
    @Produces(value={"application/xml"})
    public GenericEntity<GenericHandler<Book>> getGenericBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return new GenericEntity<GenericHandler<Book>>(new GenericHandler<Book>(this.doGetBook(id))){};
    }

    @GET
    @Path(value="/genericresponse/{bookId}/")
    @Produces(value={"application/xml"})
    public Response getGenericResponseBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return Response.ok(this.getGenericBook(id)).build();
    }

    @GET
    @Path(value="/books/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/response/{bookId}/")
    @Produces(value={"application/xml"})
    public Response getBookAsResponse(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        Book entity = this.doGetBook(id);
        EntityTag etag = new EntityTag(Integer.toString(entity.hashCode()));
        return Response.ok().tag(etag).entity((Object)entity).build();
    }

    @GET
    @Path(value="/books/{bookId}/cglib")
    @Produces(value={"application/xml"})
    public Book getBookCGLIB(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.createCglibProxy(this.doGetBook(id));
    }

    @GET
    @Path(value="/the books/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getBookWithSpace(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/search")
    @Produces(value={"application/xml"})
    public Book getBook(@Context SearchContext searchContext) throws BookNotFoundFault {
        SearchCondition sc = searchContext.getCondition(Book.class);
        if (sc == null) {
            throw new BookNotFoundFault("Search exception");
        }
        List found = sc.findAll(this.books.values());
        if (found.size() != 1) {
            throw new BookNotFoundFault("Single book is expected");
        }
        return (Book)found.get(0);
    }

    @GET
    @Path(value="/books/{bookId}/")
    @Produces(value={"text/xml"})
    public Book getBookTextXml(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/wrapper/{bookId}/")
    @Produces(value={"application/xml"})
    public BookWrapper getWrappedBook(@PathParam(value="bookId") Long id) throws BookNotFoundFault {
        BookWrapper bw = new BookWrapper();
        Book b = new Book("CXF in Action", 99999L);
        bw.setBook(b);
        return bw;
    }

    @GET
    @Path(value="/books/wrapper2/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getWrappedBook2(@PathParam(value="bookId") Long id) throws BookNotFoundFault {
        return new Book("CXF in Action", 99999L);
    }

    @GET
    @Path(value="books/custom/{bookId:\\d\\d\\d}")
    public Book getBookCustom(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/query")
    public Book getBookQuery(@QueryParam(value="bookId") long id) throws BookNotFoundFault {
        return this.doGetBook(Long.toString(id));
    }

    @GET
    @Path(value="/books/defaultquery")
    public Book getDefaultBookQuery(@DefaultValue(value="123") @QueryParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/missingquery")
    public Book getBookMissingQuery(@QueryParam(value="bookId") long id) throws BookNotFoundFault {
        if (id != 0L) {
            throw new RuntimeException();
        }
        return this.doGetBook("123");
    }

    @GET
    @Path(value="/books/element")
    public JAXBElement<Book> getBookElement() throws Exception {
        return new JAXBElement(new QName("", "Book"), Book.class, (Object)this.doGetBook("123"));
    }

    @POST
    @Path(value="/books/element/echo")
    public JAXBElement<Book> echoBookElement(JAXBElement<Book> element) throws Exception {
        return element;
    }

    @POST
    @Path(value="/books/element/echo")
    public JAXBElement<? super Book> echoBookElementWildcard(JAXBElement<? extends Book> element) throws Exception {
        return element;
    }

    @GET
    @Path(value="/books/adapter")
    @XmlJavaTypeAdapter(value=BookInfoAdapter.class)
    public BookInfo getBookAdapter() throws Exception {
        return new BookInfo(this.doGetBook("123"));
    }

    @POST
    @Path(value="/books/adapter-list")
    @XmlJavaTypeAdapter(value=BookInfoAdapter.class)
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml", "application/json"})
    public List<BookInfo> getBookAdapterList(@XmlJavaTypeAdapter(value=BookInfoAdapter.class) List<BookInfo> collection) throws Exception {
        if (collection.size() != 1) {
            throw new WebApplicationException(400);
        }
        return collection;
    }

    @GET
    @Path(value="/books/interface/adapter")
    public BookInfoInterface getBookAdapterInterface() throws Exception {
        return new BookInfo2(this.doGetBook("123"));
    }

    @PathParam(value="bookId")
    public void setBookId(String id) {
        this.currentBookId = id;
    }

    @GET
    @Path(value="/books/{bookId}/")
    @Produces(value={"application/json;q=0.9"})
    public Book getBookAsJSON() throws BookNotFoundFault {
        return this.doGetBook(this.currentBookId);
    }

    @GET
    @Path(value="/books/buffer")
    @Produces(value={"application/bar"})
    public InputStream getBufferedBook() {
        return this.getClass().getResourceAsStream("resources/expected_get_book123.txt");
    }

    @GET
    @Path(value="/books/fail-early")
    @Produces(value={"application/bar"})
    public StreamingOutput failEarlyInWrite() {
        return new StreamingOutputImpl(true);
    }

    @GET
    @Path(value="/books/fail-late")
    @Produces(value={"application/bar"})
    public StreamingOutput writeToStreamAndFail() {
        return new StreamingOutputImpl(false);
    }

    private Book doGetBook(String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    @Path(value="/booksubresource/{bookId}/")
    public Book getBookSubResource(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    @Path(value="/booksubresourceobject/{bookId}/")
    public Object getBookSubResourceObject(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.getBookSubResource(id);
    }

    @GET
    @Path(value="/booknames/{bookId}/")
    @Produces(value={"text/*"})
    public String getBookName(@PathParam(value="bookId") int id) throws BookNotFoundFault {
        Book book = this.books.get(new Long(id));
        if (book != null) {
            return book.getName();
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(id);
        throw new BookNotFoundFault(details);
    }

    @POST
    @Path(value="/books")
    @Produces(value={"text/xml"})
    @Consumes(value={"application/xml"})
    public Response addBook(Book book) {
        String ct1 = this.httpHeaders.getMediaType().toString();
        String ct2 = (String)this.httpHeaders.getRequestHeader("Content-Type").get(0);
        String ct3 = (String)this.httpHeaders.getRequestHeaders().getFirst((Object)"Content-Type");
        if (!("application/xml".equals(ct1) && ct1.equals(ct2) && ct1.equals(ct3))) {
            throw new RuntimeException("Unexpected content type");
        }
        book.setId(this.bookId + 1L);
        this.books.put(book.getId(), book);
        return Response.ok((Object)book).build();
    }

    @POST
    @Path(value="/oneway")
    @Oneway
    public void onewayRequest() {
        if (!PhaseInterceptorChain.getCurrentMessage().getExchange().isOneWay()) {
            throw new WebApplicationException();
        }
    }

    @POST
    @Path(value="/books/customstatus")
    @Produces(value={"application/xml"})
    @Consumes(value={"text/xml"})
    public Book addBookCustomFailure(Book book, @Context HttpServletResponse response) {
        response.setStatus(233);
        response.addHeader("CustomHeader", "CustomValue");
        book.setId(888L);
        return book;
    }

    @POST
    @Path(value="/booksinfo")
    @Produces(value={"text/xml"})
    @Consumes(value={"application/xml"})
    public Response addBook(@XmlJavaTypeAdapter(value=BookInfoAdapter.class) BookInfo bookInfo) {
        return Response.ok((Object)bookInfo.asBook()).build();
    }

    @POST
    @Path(value="/binarybooks")
    @Produces(value={"text/xml"})
    @Consumes(value={"application/octet-stream"})
    public Response addBinaryBook(long[] book) {
        return Response.ok((Object)book).build();
    }

    @PUT
    @Path(value="/books/")
    public Response updateBook(Book book) {
        Response r;
        Book b = this.books.get(book.getId());
        if (b != null) {
            this.books.put(book.getId(), book);
            r = Response.ok().build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @PUT
    @Path(value="/books/{id}")
    public Response createBook(@PathParam(value="id") Long id) {
        Response r;
        Book b = this.books.get(id);
        if (b == null) {
            Book newBook = new Book();
            newBook.setId(id);
            this.books.put(newBook.getId(), newBook);
            r = Response.ok().build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @PUT
    @Path(value="/bookswithdom/")
    public DOMSource updateBook(DOMSource ds) {
        XMLUtils.printDOM((Node)ds.getNode());
        return ds;
    }

    @PUT
    @Path(value="/bookswithjson/")
    @Consumes(value={"application/json"})
    public Response updateBookJSON(Book book) {
        Response r;
        Book b = this.books.get(book.getId());
        if (b != null) {
            this.books.put(book.getId(), book);
            r = Response.ok().build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @DELETE
    @Path(value="/books/{bookId}/")
    public Response deleteBook(@PathParam(value="bookId") String id) {
        Book b = this.books.get(Long.parseLong(id));
        Response r = b != null ? Response.ok().build() : Response.notModified().build();
        return r;
    }

    @DELETE
    @Path(value="/books/id")
    public Response deleteWithQuery(@QueryParam(value="value") @DefaultValue(value="-1") int id) {
        if (id != 123) {
            throw new WebApplicationException();
        }
        Book b = this.books.get(new Long(id));
        Response r = b != null ? Response.ok().build() : Response.notModified().build();
        return r;
    }

    @POST
    @Path(value="/booksplain")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Long echoBookId(long theBookId) {
        return new Long(theBookId);
    }

    @POST
    @Path(value="/booksecho")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response echoBookNameAndHeader(@HeaderParam(value="CustomHeader") String headerValue, String name) {
        return Response.ok().entity((Object)name).header("CustomHeader", (Object)headerValue).build();
    }

    @Path(value="/bookstoresub")
    public BookStore echoThroughBookStoreSub() {
        return this;
    }

    @POST
    @Path(value="/booksecho2")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response echoBookNameAndHeader2(String name) {
        return this.echoBookNameAndHeader((String)this.httpHeaders.getRequestHeader("CustomHeader").get(0), name);
    }

    @GET
    @Path(value="/cd/{CDId}/")
    public CD getCD() {
        CD cd = this.cds.get(Long.parseLong(this.currentCdId));
        return cd;
    }

    @GET
    @Path(value="/cdwithmultitypes/{CDId}/")
    @Produces(value={"application/xml", "application/bar+xml", "application/json"})
    public CD getCDWithMultiContentTypes(@PathParam(value="CDId") String id) {
        CD cd = this.cds.get(Long.parseLong(id));
        return cd;
    }

    @GET
    @Path(value="/cds/")
    public CDs getCDs() {
        CDs c = new CDs();
        c.setCD(this.cds.values());
        return c;
    }

    @Path(value="/interface")
    public BookSubresource getBookFromSubresource() {
        return new BookSubresourceImpl();
    }

    final void init() {
        Book book = new Book();
        book.setId(this.bookId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
        CD cd = new CD();
        cd.setId(this.cdId);
        cd.setName("BOHEMIAN RHAPSODY");
        this.cds.put(cd.getId(), cd);
        CD cd1 = new CD();
        cd1.setId(++this.cdId);
        cd1.setName("BICYCLE RACE");
        this.cds.put(cd1.getId(), cd1);
    }

    private Book createCglibProxy(final Book book) {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)book, args);
            }
        };
        return (Book)ProxyHelper.getProxy((ClassLoader)this.getClass().getClassLoader(), (Class[])new Class[]{Book.class}, (InvocationHandler)handler);
    }

    private static class StreamingOutputImpl
    implements StreamingOutput {
        private boolean failEarly;

        public StreamingOutputImpl(boolean failEarly) {
            this.failEarly = failEarly;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            if (this.failEarly) {
                throw new WebApplicationException(Response.status((int)410).type("text/plain").entity((Object)"This is supposed to go on the wire").build());
            }
            output.write("This is not supposed to go on the wire".getBytes());
            throw new WebApplicationException(410);
        }
    }

    static class BadBook {
        public BadBook(String s) {
            throw new RuntimeException("The bad book");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BookInfoAdapter
    extends XmlAdapter<Book, BookInfo> {
        public Book marshal(BookInfo v) throws Exception {
            return new Book(v.getName(), v.getId());
        }

        public BookInfo unmarshal(Book b) throws Exception {
            return new BookInfo(b);
        }
    }

    static class BookInfo2
    extends BookInfo
    implements BookInfoInterface {
        public BookInfo2() {
        }

        public BookInfo2(Book b) {
            super(b);
        }
    }

    static class BookInfo {
        private String name;
        private long id;

        public BookInfo() {
        }

        public BookInfo(Book b) {
            this.name = b.getName();
            this.id = b.getId();
            if (this.id == 0L) {
                this.id = 124L;
            }
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public Book asBook() {
            Book b = new Book();
            b.setId(this.id);
            b.setName(this.name);
            return b;
        }
    }

    @XmlJavaTypeAdapter(value=BookInfoAdapter.class)
    private static interface BookInfoInterface {
        public String getName();

        public long getId();
    }
}

