/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.BookStoreNoAnnotationsInterface;
import org.apache.cxf.systest.jaxrs.Chapter;
import org.apache.cxf.systest.jaxrs.ChapterNoAnnotations;
import org.apache.cxf.systest.jaxrs.HttpHeadersContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookStoreNoAnnotationsImpl
implements BookStoreNoAnnotationsInterface,
HttpHeadersContext {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    @Context
    private UriInfo ui;
    private HttpHeaders hs;

    public BookStoreNoAnnotationsImpl() {
        Book b = new Book();
        b.setId(123L);
        b.setName("CXF in Action");
        this.books.put(b.getId(), b);
    }

    @Override
    public void setHttpHeaders(HttpHeaders headers) {
        this.hs = headers;
    }

    @Override
    public Book getBook(Long id) throws BookNotFoundFault {
        if (this.hs == null) {
            throw new WebApplicationException(Response.serverError().build());
        }
        boolean springProxy = this.hs.getRequestHeader("SpringProxy").contains("true");
        if (!springProxy && this.ui == null) {
            throw new WebApplicationException(Response.serverError().build());
        }
        return this.books.get(id);
    }

    @Override
    public ChapterNoAnnotations getBookChapter(Long id) throws BookNotFoundFault {
        Book b = this.books.get(id);
        Chapter ch = b.getChapter(1);
        ChapterNoAnnotations ch2 = new ChapterNoAnnotations();
        ch2.setId(ch.getId());
        ch2.setTitle(ch.getTitle());
        return ch2;
    }

    @Override
    public List<Book> getBooks(List<Book> thebooks) {
        return thebooks;
    }

    @Override
    public void pingBookStore() {
    }
}

