/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.security.BookHttpsServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSHttpsBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookHttpsServer.PORT;
    private static final String CLIENT_CONFIG_FILE = "org/apache/cxf/systest/jaxrs/security/jaxrs-https.xml";
    private static final String CLIENT_CONFIG_FILE2 = "org/apache/cxf/systest/jaxrs/security/jaxrs-https-url.xml";

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSHttpsBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSHttpsBookTest.launchServer(BookHttpsServer.class));
    }

    @Test
    public void testGetBook123Proxy() throws Exception {
        this.doTestGetBook123Proxy(CLIENT_CONFIG_FILE);
    }

    @Test
    public void testGetBook123ProxyWithURLConduitId() throws Exception {
        this.doTestGetBook123Proxy(CLIENT_CONFIG_FILE2);
    }

    private void doTestGetBook123Proxy(String configFile) throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("https://localhost:" + PORT), BookStore.class, (String)configFile);
        JAXRSHttpsBookTest.assertEquals((Object)("https://localhost:" + PORT), (Object)WebClient.client((Object)bs).getBaseURI().toString());
        Book b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetBook123ProxyToWebClient() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("https://localhost:" + PORT), BookStore.class, (String)CLIENT_CONFIG_FILE);
        Book b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        WebClient wc = WebClient.fromClient((Client)WebClient.client((Object)bs));
        wc.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b2 = (Book)wc.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b2.getId());
    }

    @Test
    public void testGetBook123WebClientToProxy() throws Exception {
        WebClient wc = WebClient.create((String)("https://localhost:" + PORT), (String)CLIENT_CONFIG_FILE);
        wc.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)wc.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b.getId());
        wc.back(true);
        BookStore bs = (BookStore)JAXRSClientFactory.fromClient((Client)wc, BookStore.class);
        Book b2 = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b2.getId(), (long)123L);
    }

    @Test
    public void testGetBook123WebClient() throws Exception {
        this.doTestGetBook123WebClient(CLIENT_CONFIG_FILE);
    }

    @Test
    public void testGetBook123WebClientWithURLConduitId() throws Exception {
        this.doTestGetBook123WebClient(CLIENT_CONFIG_FILE2);
    }

    private void doTestGetBook123WebClient(String configFile) throws Exception {
        WebClient client = WebClient.create((String)("https://localhost:" + PORT), (String)configFile);
        JAXRSHttpsBookTest.assertEquals((Object)("https://localhost:" + PORT), (Object)client.getBaseURI().toString());
        client.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)client.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b.getId());
    }
}

