/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookServerResourceJacksonSpringProviders;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerResourceJacksonSpringProviderTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerResourceJacksonSpringProviders.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerResourceJacksonSpringProviderTest.launchServer(BookServerResourceJacksonSpringProviders.class));
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertNotNull((Object)in);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((String)"Jackson output not correct", (Object)"{\"name\":\"CXF in Action\",\"id\":123}", (Object)this.getStringFromInputStream(in).trim());
    }

    @Test
    public void testGetCollectionOfBooks() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/bookstore/collections";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new JacksonJsonProvider()));
        wc.accept(new String[]{"application/json"});
        Collection collection = wc.getCollection(Book.class);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)1L, (long)collection.size());
        Book book = (Book)collection.iterator().next();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)123L, (long)book.getId());
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }
}

