/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ServerWebApplicationException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNonSpringServer;
import org.apache.cxf.systest.jaxrs.BookStoreNoAnnotationsInterface;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerNonSpringBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookNonSpringServer.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerNonSpringBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerNonSpringBookTest.launchServer(BookNonSpringServer.class, (boolean)true));
    }

    @Test
    public void testGetBook123Singleton() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/singleton/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123UserModel() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/usermodel/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123UserModelAuthorize() throws Exception {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress("http://localhost:" + PORT + "/usermodel/bookstore/books");
        bean.setUsername("Barry");
        bean.setPassword("password");
        bean.setModelRef("classpath:org/apache/cxf/systest/jaxrs/resources/resources.xml");
        WebClient proxy = bean.createWebClient();
        proxy.path("{id}/authorize", new Object[]{123});
        Book book = (Book)proxy.get(Book.class);
        JAXRSClientServerNonSpringBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testGetChapterUserModel() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/usermodel/bookstore/books/123/chapter", "resources/expected_get_chapter1_utf.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123UserModelInterface() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/usermodel2/bookstore2/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBooksUserModelInterface() throws Exception {
        BookStoreNoAnnotationsInterface proxy = (BookStoreNoAnnotationsInterface)JAXRSClientFactory.createFromModel((String)("http://localhost:" + PORT + "/usermodel2"), BookStoreNoAnnotationsInterface.class, (String)"classpath:org/apache/cxf/systest/jaxrs/resources/resources2.xml", null);
        Book book = new Book("From Model", 1L);
        List<Book> books = new ArrayList<Book>();
        books.add(book);
        books = proxy.getBooks(books);
        JAXRSClientServerNonSpringBookTest.assertEquals((long)1L, (long)books.size());
        JAXRSClientServerNonSpringBookTest.assertNotSame((Object)book, (Object)books.get(0));
        JAXRSClientServerNonSpringBookTest.assertEquals((Object)"From Model", (Object)books.get(0).getName());
    }

    @Test
    public void testUserModelInterfaceOneWay() throws Exception {
        BookStoreNoAnnotationsInterface proxy = (BookStoreNoAnnotationsInterface)JAXRSClientFactory.createFromModel((String)("http://localhost:" + PORT + "/usermodel2"), BookStoreNoAnnotationsInterface.class, (String)"classpath:org/apache/cxf/systest/jaxrs/resources/resources2.xml", null);
        proxy.pingBookStore();
        JAXRSClientServerNonSpringBookTest.assertEquals((long)202L, (long)WebClient.client((Object)proxy).getResponse().getStatus());
    }

    @Test
    public void testGetBook123ApplicationSingleton() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/application/bookstore/default"));
        wc.accept(new String[]{"application/xml"});
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerNonSpringBookTest.assertEquals((Object)"default", (Object)book.getName());
        JAXRSClientServerNonSpringBookTest.assertEquals((long)543L, (long)book.getId());
    }

    @Test
    public void testGetBook123ApplicationPerRequest() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/application/bookstore2/bookheaders", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123Application11Singleton() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/application11/thebooks/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetNonExistentBook() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/application11/thebooks/bookstore/books/321"));
        try {
            wc.accept(new String[]{"*/*"}).get(Book.class);
            JAXRSClientServerNonSpringBookTest.fail();
        }
        catch (ServerWebApplicationException ex) {
            JAXRSClientServerNonSpringBookTest.assertEquals((Object)"No book found at all : 321", (Object)ex.getMessage());
        }
    }

    @Test
    public void testBookWithNonExistentMethod() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/application11/thebooks/bookstore/nonexistent"));
        try {
            wc.accept(new String[]{"*/*"}).get(Book.class);
            JAXRSClientServerNonSpringBookTest.fail();
        }
        catch (ServerWebApplicationException ex) {
            JAXRSClientServerNonSpringBookTest.assertEquals((Object)"Nonexistent method", (Object)ex.getMessage());
        }
    }

    private void getAndCompareAsStrings(String address, String resourcePath, String acceptType, int status) throws Exception {
        String expected = this.getStringFromInputStream(((Object)((Object)this)).getClass().getResourceAsStream(resourcePath));
        this.getAndCompare(address, expected, acceptType, acceptType, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompare(String address, String expectedValue, String acceptType, String expectedContentType, int expectedStatus) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        get.setRequestHeader("Accept-Language", "da;q=0.8,en");
        get.setRequestHeader("Book", "1,2,3");
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerNonSpringBookTest.assertEquals((long)expectedStatus, (long)result);
            String content = this.getStringFromInputStream(get.getResponseBodyAsStream());
            JAXRSClientServerNonSpringBookTest.assertEquals((String)"Expected value is wrong", (Object)expectedValue, (Object)content);
            if (expectedContentType != null) {
                Header ct = get.getResponseHeader("Content-Type");
                JAXRSClientServerNonSpringBookTest.assertEquals((String)"Wrong type of response", (Object)expectedContentType, (Object)ct.getValue());
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }
}

