/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.LogRecords;
import org.apache.cxf.systest.jaxrs.AbstractSpringServer;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSLoggingAtomPushSpringTest
extends AbstractClientServerTestBase {
    public static final String PORT = SpringServer.PORT;
    private JAXBContext context;
    private int fakyLogger;
    private int namedLogger;
    private int resourceLogger;
    private int throwables;

    @BeforeClass
    public static void beforeClass() throws Exception {
        JAXRSLoggingAtomPushSpringTest.launchServer(SpringServer.class, (boolean)true);
    }

    @Before
    public void before() throws Exception {
        Resource.clear();
        Resource2.clear();
        Resource3.clear();
        Resource4.clear();
        Resource5.clear();
        this.context = JAXBContext.newInstance((Class[])new Class[]{LogRecords.class, LogRecord.class});
    }

    @Test
    public void testFeedsWithLogRecordsOneEntry() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/root"));
        try {
            wc.path((Object)"/log").get();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Thread.sleep(3000L);
        List<Feed> elements = Resource.getElements();
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)8L, (long)elements.size());
        this.resetCounters();
        for (Feed feed : elements) {
            List entries = feed.getEntries();
            JAXRSLoggingAtomPushSpringTest.assertEquals((long)1L, (long)entries.size());
            Entry e = (Entry)entries.get(0);
            LogRecords records = this.readLogRecords(e.getContent());
            List list = records.getLogRecords();
            JAXRSLoggingAtomPushSpringTest.assertNotNull((Object)list);
            JAXRSLoggingAtomPushSpringTest.assertEquals((long)1L, (long)list.size());
            this.updateCounters((LogRecord)list.get(0), "Resource");
        }
        this.verifyCounters();
    }

    @Test
    public void testFeedsWithBatchLogRecordsOneEntry() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/batch"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        List<Feed> elements = Resource2.getElements();
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)2L, (long)elements.size());
        this.resetCounters();
        for (Feed feed : elements) {
            List entries = feed.getEntries();
            JAXRSLoggingAtomPushSpringTest.assertEquals((long)4L, (long)entries.size());
            for (Entry e : entries) {
                this.updateCounters(this.readLogRecord(e.getContent()), "Resource2");
            }
        }
        this.verifyCounters();
    }

    @Test
    public void testEntriesWithLogRecordsOneEntry() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/entries"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        List<Entry> elements = Resource3.getElements();
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)8L, (long)elements.size());
        this.resetCounters();
        for (Entry e : elements) {
            this.updateCounters(this.readLogRecord(e.getContent()), "Resource3");
        }
        this.verifyCounters();
    }

    @Test
    public void testManyEntries() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/entriesMany"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        List<Entry> elements = Resource4.getElements();
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)4L, (long)elements.size());
        this.resetCounters();
        for (Entry e : elements) {
            LogRecords records = this.readLogRecords(e.getContent());
            List list = records.getLogRecords();
            JAXRSLoggingAtomPushSpringTest.assertNotNull((Object)list);
            JAXRSLoggingAtomPushSpringTest.assertEquals((long)2L, (long)list.size());
            for (LogRecord record : list) {
                this.updateCounters(record, "Resource4");
            }
        }
        this.verifyCounters();
    }

    @Test
    public void testFeedsWithLogRecordsExtension() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/extensions"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        List<Feed> elements = Resource5.getElements();
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)8L, (long)elements.size());
        this.resetCounters();
        for (Feed feed : elements) {
            List entries = feed.getEntries();
            JAXRSLoggingAtomPushSpringTest.assertEquals((long)1L, (long)entries.size());
            Entry e = (Entry)entries.get(0);
            LogRecords records = this.readLogRecordsExtension(e);
            List list = records.getLogRecords();
            JAXRSLoggingAtomPushSpringTest.assertNotNull((Object)list);
            JAXRSLoggingAtomPushSpringTest.assertEquals((long)1L, (long)list.size());
            this.updateCounters((LogRecord)list.get(0), "Resource5");
        }
        this.verifyCounters();
    }

    private static void doLog(Logger l1, Logger l2) {
        l1.severe("severe message");
        l1.warning("warning message");
        l1.info("info message");
        java.util.logging.LogRecord r = new java.util.logging.LogRecord(Level.FINE, "fine message");
        r.setThrown(new IllegalArgumentException("tadaam"));
        l1.log(r);
        r = new java.util.logging.LogRecord(Level.FINER, "finer message with {0} and {1}");
        r.setParameters(new Object[]{"param1", "param2"});
        r.setLoggerName("faky-logger");
        l1.log(r);
        l1.finest("finest message");
        l2.severe("severe message");
        l2.severe("severe message2");
        l2.info("info message - should not pass!");
        l2.finer("finer message - should not pass!");
    }

    private LogRecords readLogRecords(String value) throws Exception {
        return (LogRecords)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(value));
    }

    private LogRecord readLogRecord(String value) throws Exception {
        return (LogRecord)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(value));
    }

    private LogRecords readLogRecordsExtension(Entry e) throws Exception {
        ExtensibleElement el = (ExtensibleElement)e.getExtension(new QName("http://cxf.apache.org/log", "logRecords", "log"));
        LogRecords records = new LogRecords();
        ArrayList<LogRecord> list = new ArrayList<LogRecord>();
        for (Element element : el.getElements()) {
            Element throwable;
            LogRecord record = new LogRecord();
            Element loggerName = element.getFirstChild(new QName("http://cxf.apache.org/log", "loggerName", "log"));
            if (loggerName != null) {
                record.setLoggerName(loggerName.getText());
            }
            if ((throwable = element.getFirstChild(new QName("http://cxf.apache.org/log", "throwable", "log"))) != null) {
                record.setThrowable(throwable.getText());
            }
            list.add(record);
        }
        records.setLogRecords(list);
        return records;
    }

    private void updateCounters(LogRecord record, String clsName) {
        String name = record.getLoggerName();
        if (name != null && name.length() > 0) {
            if (("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPushSpringTest$" + clsName).equals(name)) {
                ++this.resourceLogger;
            } else if ("namedLogger".equals(name)) {
                ++this.namedLogger;
            } else if ("faky-logger".equals(name)) {
                ++this.fakyLogger;
            }
        } else {
            JAXRSLoggingAtomPushSpringTest.assertNotNull((Object)record.getThrowable());
            ++this.throwables;
        }
    }

    private void resetCounters() {
        this.fakyLogger = 0;
        this.namedLogger = 0;
        this.resourceLogger = 0;
        this.throwables = 0;
    }

    private void verifyCounters() {
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)1L, (long)this.throwables);
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)4L, (long)this.resourceLogger);
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)2L, (long)this.namedLogger);
        JAXRSLoggingAtomPushSpringTest.assertEquals((long)1L, (long)this.fakyLogger);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    @Path(value="/extensions")
    public static class Resource5 {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource5.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource5.class, null, (String)"namedLogger");
        private static List<Feed> feeds = new ArrayList<Feed>();

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPushSpringTest.doLog(Resource5.LOG1, Resource5.LOG2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        @Path(value="/feeds")
        public void consume(Feed feed) {
            feed.toString();
            Class<Resource5> clazz = Resource5.class;
            synchronized (Resource5.class) {
                feeds.add(feed);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public static void clear() {
            feeds.clear();
        }

        public static List<Feed> getElements() {
            return new ArrayList<Feed>(feeds);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    @Path(value="/entriesMany")
    public static class Resource4 {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource4.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource4.class, null, (String)"namedLogger");
        private static List<Entry> entries = new ArrayList<Entry>();

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPushSpringTest.doLog(Resource4.LOG1, Resource4.LOG2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        @Path(value="/entries")
        public void consume(Entry entry) {
            entry.toString();
            Class<Resource4> clazz = Resource4.class;
            synchronized (Resource4.class) {
                entries.add(entry);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public static void clear() {
            entries.clear();
        }

        public static synchronized List<Entry> getElements() {
            return new ArrayList<Entry>(entries);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    @Path(value="/entries")
    public static class Resource3 {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource3.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource3.class, null, (String)"namedLogger");
        private static List<Entry> entries = new ArrayList<Entry>();

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPushSpringTest.doLog(Resource3.LOG1, Resource3.LOG2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        @Path(value="/entries")
        public void consume(Entry entry) {
            entry.toString();
            Class<Resource3> clazz = Resource3.class;
            synchronized (Resource3.class) {
                entries.add(entry);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public static void clear() {
            entries.clear();
        }

        public static synchronized List<Entry> getElements() {
            return new ArrayList<Entry>(entries);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    @Path(value="/batch")
    public static class Resource2 {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource2.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource2.class, null, (String)"namedLogger");
        private static List<Feed> feeds = new ArrayList<Feed>();

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPushSpringTest.doLog(Resource2.LOG1, Resource2.LOG2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        @Path(value="/feeds")
        public void consume(Feed feed) {
            feed.toString();
            Class<Resource2> clazz = Resource2.class;
            synchronized (Resource2.class) {
                feeds.add(feed);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public static void clear() {
            feeds.clear();
        }

        public static synchronized List<Feed> getElements() {
            return new ArrayList<Feed>(feeds);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    @Path(value="/root")
    public static class Resource {
        private static final Logger LOG1;
        private static final Logger LOG2;
        private static List<Feed> feeds;

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPushSpringTest.doLog(Resource.LOG1, Resource.LOG2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        @Path(value="/feeds")
        public void consume(Feed feed) {
            feed.toString();
            Class<Resource> clazz = Resource.class;
            synchronized (Resource.class) {
                feeds.add(feed);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public static void clear() {
            feeds.clear();
        }

        public static synchronized List<Feed> getElements() {
            return new ArrayList<Feed>(feeds);
        }

        static {
            System.gc();
            LOG1 = LogUtils.getL7dLogger(Resource.class);
            LOG2 = LogUtils.getL7dLogger(Resource.class, null, (String)"namedLogger");
            feeds = new ArrayList<Feed>();
        }
    }

    @Ignore
    public static class SpringServer
    extends AbstractSpringServer {
        public SpringServer() {
            super("/jaxrs_logging_atompush");
        }
    }
}

