/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.FIStaxInInterceptor;
import org.apache.cxf.interceptor.FIStaxOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.interceptor.transform.TransformInInterceptor;
import org.apache.cxf.interceptor.transform.TransformOutInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.BookServerRestSoap;
import org.apache.cxf.systest.jaxrs.BookSubresource;
import org.apache.cxf.systest.jaxrs.OrderBean;
import org.apache.cxf.systest.jaxrs.jaxws.BookSoapService;
import org.apache.cxf.systest.jaxrs.jaxws.BookStoreJaxrsJaxws;
import org.apache.cxf.systest.jaxrs.jaxws.BookStoreSoapRestFastInfoset2;
import org.apache.cxf.systest.jaxrs.jaxws.BookStoreSoapRestFastInfoset3;
import org.apache.cxf.systest.jaxrs.jaxws.HelloWorld;
import org.apache.cxf.systest.jaxrs.jaxws.User;
import org.apache.cxf.systest.jaxrs.jaxws.UserImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSSoapBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerRestSoap.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSSoapBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSSoapBookTest.launchServer(BookServerRestSoap.class));
    }

    @Test
    public void testHelloRest() throws Exception {
        String address = "http://localhost:" + PORT + "/test/services/hello-rest";
        HelloWorld service = (HelloWorld)JAXRSClientFactory.create((String)address, HelloWorld.class);
        this.useHelloService(service);
    }

    @Test
    public void testHelloSoap() throws Exception {
        QName serviceName = new QName("http://hello.com", "HelloWorld");
        QName portName = new QName("http://hello.com", "HelloWorldPort");
        String address = "http://localhost:" + PORT + "/test/services/hello-soap";
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", address);
        HelloWorld hw = (HelloWorld)service.getPort(HelloWorld.class);
        this.useHelloService(hw);
    }

    @Test
    public void testHelloSoapCustomDataBinding() throws Exception {
        QName serviceName = new QName("http://hello.com", "HelloWorld");
        QName portName = new QName("http://hello.com", "HelloWorldPort");
        String address = "http://localhost:" + PORT + "/test/services/hello-soap-databinding";
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", address);
        HelloWorld hw = (HelloWorld)service.getPort(HelloWorld.class);
        UserImpl user = new UserImpl("Barry");
        User user2 = hw.echoUser(user);
        JAXRSSoapBookTest.assertNotSame((Object)user, (Object)user2);
        JAXRSSoapBookTest.assertEquals((Object)"Barry", (Object)user.getName());
    }

    private void useHelloService(HelloWorld service) {
        JAXRSSoapBookTest.assertEquals((Object)"Hello Barry", (Object)service.sayHi("Barry"));
        JAXRSSoapBookTest.assertEquals((Object)"Hello Fred", (Object)service.sayHiToUser(new UserImpl("Fred")));
        Map<Integer, User> users = service.getUsers();
        JAXRSSoapBookTest.assertEquals((long)1L, (long)users.size());
        JAXRSSoapBookTest.assertEquals((Object)"Fred", (Object)users.entrySet().iterator().next().getValue().getName());
        users = service.echoUsers(users);
        JAXRSSoapBookTest.assertEquals((long)1L, (long)users.size());
        JAXRSSoapBookTest.assertEquals((Object)"Fred", (Object)users.entrySet().iterator().next().getValue().getName());
    }

    @Test
    public void testGetAll() throws Exception {
        InputStream in = this.getHttpInputStream("http://localhost:" + PORT + "/test/services/rest2/myRestService");
        JAXRSSoapBookTest.assertEquals((Object)"0", (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBookTransform() throws Exception {
        String address = "http://localhost:" + PORT + "/test/v1/rest-transform/bookstore/books/123";
        WebClient client = WebClient.create((String)address);
        Response r = client.get();
        String str = this.getStringFromInputStream((InputStream)r.getEntity());
        JAXRSSoapBookTest.assertTrue((boolean)str.contains("TheBook"));
    }

    @Test
    public void testPostBookTransform() throws Exception {
        String address = "http://localhost:" + PORT + "/test/v1/rest-transform/bookstore/books";
        TransformOutInterceptor out = new TransformOutInterceptor();
        out.setOutTransformElements(Collections.singletonMap("{http://www.example.org/books}*", "{http://www.example.org/super-books}*"));
        TransformInInterceptor in = new TransformInInterceptor();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TheBook", "{http://www.example.org/books}Book");
        map.put("id", "{http://www.example.org/books}id");
        in.setInTransformElements(map);
        WebClient client = WebClient.create((String)address);
        WebClient.getConfig((Object)client).getInInterceptors().add(in);
        WebClient.getConfig((Object)client).getOutInterceptors().add(out);
        Book2 book = (Book2)client.accept(new String[]{"text/xml"}).post((Object)new Book2(), Book2.class);
        JAXRSSoapBookTest.assertEquals((long)124L, (long)book.getId());
    }

    @Test
    public void testPostBookTransformV2() throws Exception {
        String address = "http://localhost:" + PORT + "/test/v2/rest-transform/bookstore/books";
        WebClient client = WebClient.create((String)address);
        Book book = (Book)client.accept(new String[]{"text/xml"}).post((Object)new Book(), Book.class);
        JAXRSSoapBookTest.assertEquals((long)124L, (long)book.getId());
    }

    @Test
    public void testGetBookFastinfoset() throws Exception {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress("http://localhost:" + PORT + "/test/services/rest3/bookstore/fastinfoset2");
        bean.getInInterceptors().add(new FIStaxInInterceptor());
        JAXBElementProvider p = new JAXBElementProvider();
        p.setConsumeMediaTypes(Collections.singletonList("application/fastinfoset"));
        bean.setProvider((Object)p);
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        props.put("org.apache.cxf.fastinfoset.get.supported", Boolean.TRUE);
        bean.setProperties(props);
        WebClient client = bean.createWebClient();
        Book b = (Book)client.accept(new String[]{"application/fastinfoset"}).get(Book.class);
        JAXRSSoapBookTest.assertEquals((Object)"CXF2", (Object)b.getName());
        JAXRSSoapBookTest.assertEquals((long)2L, (long)b.getId());
    }

    @Test
    public void testPostGetBookFastinfoset() throws Exception {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress("http://localhost:" + PORT + "/test/services/rest3/bookstore/fastinfoset");
        bean.getOutInterceptors().add(new FIStaxOutInterceptor());
        bean.getInInterceptors().add(new FIStaxInInterceptor());
        JAXBElementProvider p = new JAXBElementProvider();
        p.setConsumeMediaTypes(Collections.singletonList("application/fastinfoset"));
        p.setProduceMediaTypes(Collections.singletonList("application/fastinfoset"));
        bean.setProvider((Object)p);
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        props.put("org.apache.cxf.fastinfoset.enabled", Boolean.TRUE);
        bean.setProperties(props);
        WebClient client = bean.createWebClient();
        Book b = new Book("CXF", 1L);
        Book b2 = (Book)client.type("application/fastinfoset").accept(new String[]{"application/fastinfoset"}).post((Object)b, Book.class);
        JAXRSSoapBookTest.assertEquals((Object)b2.getName(), (Object)b.getName());
        JAXRSSoapBookTest.assertEquals((long)b2.getId(), (long)b.getId());
    }

    @Test
    public void testPostGetBookFastinfosetProxy() throws Exception {
        JAXBElementProvider p = new JAXBElementProvider();
        p.setConsumeMediaTypes(Collections.singletonList("application/fastinfoset"));
        p.setProduceMediaTypes(Collections.singletonList("application/fastinfoset"));
        BookStoreJaxrsJaxws client = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)("http://localhost:" + PORT + "/test/services/rest4"), BookStoreSoapRestFastInfoset2.class, Collections.singletonList(p));
        Book b = new Book("CXF", 1L);
        Book b2 = client.addFastinfoBook(b);
        JAXRSSoapBookTest.assertEquals((Object)b2.getName(), (Object)b.getName());
        JAXRSSoapBookTest.assertEquals((long)b2.getId(), (long)b.getId());
        this.checkFiInterceptors(WebClient.getConfig((Object)client));
    }

    @Test
    public void testPostGetBookFastinfosetProxyInterceptors() throws Exception {
        JAXBElementProvider p = new JAXBElementProvider();
        p.setConsumeMediaTypes(Collections.singletonList("application/fastinfoset"));
        p.setProduceMediaTypes(Collections.singletonList("application/fastinfoset"));
        BookStoreJaxrsJaxws client = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)("http://localhost:" + PORT + "/test/services/rest5"), BookStoreSoapRestFastInfoset3.class, Collections.singletonList(p));
        Book b = new Book("CXF", 1L);
        Map props = WebClient.getConfig((Object)client).getRequestContext();
        props.put("org.apache.cxf.fastinfoset.enabled", Boolean.TRUE);
        Book b2 = client.addFastinfoBook(b);
        JAXRSSoapBookTest.assertEquals((Object)b2.getName(), (Object)b.getName());
        JAXRSSoapBookTest.assertEquals((long)b2.getId(), (long)b.getId());
        this.checkFiInterceptors(WebClient.getConfig((Object)client));
    }

    private void checkFiInterceptors(ClientConfiguration cfg) {
        int count = 0;
        for (Interceptor in : cfg.getInInterceptors()) {
            if (!(in instanceof FIStaxInInterceptor)) continue;
            ++count;
            break;
        }
        for (Interceptor in : cfg.getOutInterceptors()) {
            if (!(in instanceof FIStaxOutInterceptor)) continue;
            ++count;
            break;
        }
        JAXRSSoapBookTest.assertEquals((String)"In and Out FastInfoset interceptors are expected", (long)2L, (long)count);
    }

    @Test
    public void testGetBook123ServletResponse() throws Exception {
        InputStream in = this.getHttpInputStream("http://localhost:" + PORT + "/test/services/rest/bookstore/0");
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSSoapBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBook123() throws Exception {
        InputStream in = this.getHttpInputStream("http://localhost:" + PORT + "/test/services/rest/bookstore/123");
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSSoapBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBook123Client() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class);
        HTTPConduit conduit = (HTTPConduit)WebClient.getConfig((Object)proxy).getConduit();
        Book b = proxy.getBook(new Long("123"));
        JAXRSSoapBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
        HTTPConduit conduit2 = (HTTPConduit)WebClient.getConfig((Object)proxy).getConduit();
        JAXRSSoapBookTest.assertSame((Object)conduit, (Object)conduit2);
        conduit.getClient().setAutoRedirect(true);
        b = proxy.getBook(new Long("123"));
        JAXRSSoapBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testGetBook123WebClient() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        WebClient client = WebClient.create((String)baseAddress);
        client.path((Object)"/bookstore/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)client.get(Book.class);
        JAXRSSoapBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testGetBook123XMLSource() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        WebClient client = WebClient.create((String)baseAddress);
        client.path((Object)"/bookstore/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        XMLSource source = (XMLSource)client.get(XMLSource.class);
        source.setBuffering(true);
        Book b = (Book)source.getNode("/Book", Book.class);
        JAXRSSoapBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
        b = (Book)source.getNode("/Book", Book.class);
        JAXRSSoapBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testNoBookWebClient() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        WebClient client = WebClient.create((String)baseAddress);
        client.path((Object)"/bookstore/books/0/subresource").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)client.get(Book.class);
        JAXRSSoapBookTest.assertNull((Object)b);
        JAXRSSoapBookTest.assertEquals((long)204L, (long)client.getResponse().getStatus());
    }

    @Test
    public void testGetBook123WebClientResponse() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        WebClient client = WebClient.create((String)baseAddress);
        client.path((Object)"/bookstore/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = this.readBook((InputStream)client.get().getEntity());
        JAXRSSoapBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testGetBook356ClientException() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class, Collections.singletonList(new TestResponseExceptionMapper()));
        try {
            proxy.getBook(356L);
            JAXRSSoapBookTest.fail();
        }
        catch (BookNotFoundFault ex) {
            JAXRSSoapBookTest.assertEquals((Object)"No Book with id 356 is available", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNoBook357WebClient() throws Exception {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("org.apache.cxf.http.throw_io_exceptions", Boolean.TRUE);
        bean.setProperties(properties);
        bean.setAddress("http://localhost:" + PORT + "/test/services/rest/bookstore/356");
        WebClient wc = bean.createWebClient();
        Response response = wc.get();
        JAXRSSoapBookTest.assertEquals((long)404L, (long)response.getStatus());
        String msg = IOUtils.readStringFromStream((InputStream)((InputStream)response.getEntity()));
        JAXRSSoapBookTest.assertEquals((Object)"No Book with id 356 is available", (Object)msg);
    }

    @Test
    public void testOtherInterceptorDrainingStream() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(baseAddress);
        bean.getInInterceptors().add(new TestStreamDrainInterptor());
        WebClient client = bean.createWebClient();
        client.path((Object)"/bookstore/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)client.get(Book.class);
        JAXRSSoapBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testGetBookSubresourceClient() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class);
        BookSubresource bs = proxy.getBookSubresource("125");
        Book b = bs.getTheBook();
        JAXRSSoapBookTest.assertEquals((long)125L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testGetBookSubresourceClientNoProduces() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class);
        BookSubresource bs = proxy.getBookSubresource("125");
        Book b = bs.getTheBookNoProduces();
        JAXRSSoapBookTest.assertEquals((long)125L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testGetBookSubresourceParamExtensions() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class);
        BookSubresource bs = proxy.getBookSubresource("139");
        Book bean = new Book("CXF Rocks", 139L);
        Book b = bs.getTheBook4(bean, bean, bean, bean);
        JAXRSSoapBookTest.assertEquals((long)139L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF Rocks", (Object)b.getName());
    }

    @Test
    public void testAddOrderFormBean() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class);
        BookSubresource bs = proxy.getBookSubresource("139");
        OrderBean order = new OrderBean();
        order.setId(123L);
        order.setWeight(100);
        OrderBean order2 = bs.addOrder(order);
        JAXRSSoapBookTest.assertEquals((Object)123L, (Object)order2.getId());
    }

    @Test
    public void testGetBookSubresourceWebClientParamExtensions() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/test/services/rest"));
        client.type(MediaType.TEXT_PLAIN_TYPE).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        client.path((Object)"/bookstore/books/139/subresource4/139/CXF Rocks");
        Book bean = new Book("CXF Rocks", 139L);
        Form form = new Form();
        form.set("name", (Object)"CXF Rocks").set("id", (Object)139L);
        Book b = this.readBook((InputStream)client.matrix("", new Object[]{bean}).query("", new Object[]{bean}).form(form).getEntity());
        JAXRSSoapBookTest.assertEquals((long)139L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF Rocks", (Object)b.getName());
    }

    @Test
    public void testGetBookSubresourceClient2() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class);
        this.doTestSubresource(proxy);
        BookStoreJaxrsJaxws proxy2 = proxy.getBookStore("number1");
        this.doTestSubresource(proxy2);
        BookStoreJaxrsJaxws proxy3 = proxy2.getBookStore("number1");
        this.doTestSubresource(proxy3);
    }

    @Test
    public void testGetBookSubresourceWebClientProxyBean() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/test/services/rest"));
        client.type(MediaType.TEXT_PLAIN_TYPE).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.TEXT_XML_TYPE});
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.fromClient((Client)client, BookStoreJaxrsJaxws.class, (boolean)true);
        this.doTestSubresource(proxy);
        BookStoreJaxrsJaxws proxy2 = (BookStoreJaxrsJaxws)JAXRSClientFactory.fromClient((Client)WebClient.client((Object)proxy), BookStoreJaxrsJaxws.class);
        this.doTestSubresource(proxy2);
    }

    @Test
    public void testGetBookSubresourceWebClientProxy2() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/test/services/rest/bookstore")).path((Object)"/books/378");
        client.type(MediaType.TEXT_PLAIN_TYPE).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        BookSubresource proxy = (BookSubresource)JAXRSClientFactory.fromClient((Client)client, BookSubresource.class);
        Book b = proxy.getTheBook2("CXF ", "in ", "Acti", "on ", "- 3", "7", "8");
        JAXRSSoapBookTest.assertEquals((long)378L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action - 378", (Object)b.getName());
    }

    private void doTestSubresource(BookStoreJaxrsJaxws proxy) throws Exception {
        BookSubresource bs = proxy.getBookSubresource("378");
        Book b = bs.getTheBook2("CXF ", "in ", "Acti", "on ", "- 3", "7", "8");
        JAXRSSoapBookTest.assertEquals((long)378L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action - 378", (Object)b.getName());
        WebClient.client((Object)bs).reset().header("N4", new Object[]{"- 4"});
        b = bs.getTheBook2("CXF ", "in ", "Acti", "on ", null, "7", "8");
        JAXRSSoapBookTest.assertEquals((long)378L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action - 478", (Object)b.getName());
    }

    @Test
    public void testGetBookWebClientForm() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest/bookstore/books/679/subresource3";
        WebClient wc = WebClient.create((String)baseAddress);
        MetadataMap map = new MetadataMap();
        map.putSingle((Object)"id", (Object)"679");
        map.add((Object)"name", (Object)"CXF in Action - ");
        map.add((Object)"name", (Object)"679");
        Book b = this.readBook((InputStream)wc.accept(new String[]{"application/xml"}).form((Map)map).getEntity());
        JAXRSSoapBookTest.assertEquals((long)679L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action - 679", (Object)b.getName());
    }

    @Test
    public void testGetBookWebClientForm2() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest/bookstore/books/679/subresource3";
        WebClient wc = WebClient.create((String)baseAddress);
        Form f = new Form();
        f.set("id", (Object)"679").set("name", (Object)"CXF in Action - ").set("name", (Object)"679");
        Book b = this.readBook((InputStream)wc.accept(new String[]{"application/xml"}).form(f).getEntity());
        JAXRSSoapBookTest.assertEquals((long)679L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action - 679", (Object)b.getName());
    }

    @Test
    public void testGetBookSubresourceClientFormParam() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class);
        BookSubresource bs = proxy.getBookSubresource("679");
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("CXF in Action - ");
        parts.add(Integer.toString(679));
        Book b = bs.getTheBook3("679", parts);
        JAXRSSoapBookTest.assertEquals((long)679L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action - 679", (Object)b.getName());
    }

    @Test
    public void testAddGetBook123WebClient() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        WebClient client = WebClient.create((String)baseAddress);
        client.path((Object)"/bookstore/books").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).type(MediaType.APPLICATION_XML_TYPE);
        Book b = new Book();
        b.setId(124L);
        b.setName("CXF in Action - 2");
        Book b2 = (Book)client.post((Object)b, Book.class);
        JAXRSSoapBookTest.assertNotSame((Object)b, (Object)b2);
        JAXRSSoapBookTest.assertEquals((long)124L, (long)b2.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action - 2", (Object)b2.getName());
    }

    @Test
    public void testAddGetBook123Client() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)JAXRSClientFactory.create((String)baseAddress, BookStoreJaxrsJaxws.class);
        Book b = new Book();
        b.setId(124L);
        b.setName("CXF in Action - 2");
        Book b2 = proxy.addBook(b);
        JAXRSSoapBookTest.assertNotSame((Object)b, (Object)b2);
        JAXRSSoapBookTest.assertEquals((long)124L, (long)b2.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action - 2", (Object)b2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddGetBookRest() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/test/services/rest/bookstore/books";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/add_book.txt").toURI());
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestHeader("Content-Type", "application/xml");
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSSoapBookTest.assertEquals((long)200L, (long)result);
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book.txt");
            JAXRSSoapBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testGetBookSoap() throws Exception {
        String wsdlAddress = "http://localhost:" + PORT + "/test/services/soap/bookservice?wsdl";
        URL wsdlUrl = new URL(wsdlAddress);
        BookSoapService service = new BookSoapService(wsdlUrl, new QName("http://books.com", "BookService"));
        BookStoreJaxrsJaxws store = service.getBookPort();
        Book book = store.getBook(new Long(123L));
        JAXRSSoapBookTest.assertEquals((String)"id is wrong", (long)book.getId(), (long)123L);
    }

    @Test
    public void testGetUnqualifiedBookSoap() throws Exception {
        String wsdlAddress = "http://localhost:" + PORT + "/test/services/soap-transform/bookservice?wsdl";
        BookSoapService service = new BookSoapService(new URL(wsdlAddress), new QName("http://books.com", "BookService"));
        BookStoreJaxrsJaxws store = service.getBookPort();
        TransformOutInterceptor out = new TransformOutInterceptor();
        HashMap<String, String> mapOut = new HashMap<String, String>();
        mapOut.put("{http://jaxws.jaxrs.systest.cxf.apache.org/}*", "*");
        out.setOutTransformElements(mapOut);
        TransformInInterceptor in = new TransformInInterceptor();
        HashMap<String, String> mapIn = new HashMap<String, String>();
        mapIn.put("getBookResponse", "{http://jaxws.jaxrs.systest.cxf.apache.org/}getBookResponse");
        in.setInTransformElements(mapIn);
        org.apache.cxf.endpoint.Client cl = ClientProxy.getClient((Object)store);
        ((HTTPConduit)cl.getConduit()).getClient().setReceiveTimeout(10000000L);
        cl.getInInterceptors().add(in);
        cl.getOutInterceptors().add(out);
        Book book = store.getBook(new Long(123L));
        JAXRSSoapBookTest.assertEquals((String)"id is wrong", (long)book.getId(), (long)123L);
    }

    @Test
    public void testServiceListingsAndWadl() throws Exception {
        String listings = this.getStringFromInputStream(this.getHttpInputStream("http://localhost:" + PORT + "/test/services"));
        JAXRSSoapBookTest.assertNotNull((Object)listings);
        JAXRSSoapBookTest.assertTrue((boolean)listings.contains("http://localhost:" + PORT + "/test/services/soap/bookservice?wsdl"));
        JAXRSSoapBookTest.assertFalse((boolean)listings.contains("http://localhost:" + PORT + "/test/services/soap/bookservice2?wsdl"));
        JAXRSSoapBookTest.assertTrue((boolean)listings.contains("http://localhost:" + PORT + "/test/services/rest?_wadl"));
        JAXRSSoapBookTest.assertEquals((long)200L, (long)WebClient.create((String)("http://localhost:" + PORT + "/test/services/rest?_wadl&type=xml")).get().getStatus());
        JAXRSSoapBookTest.assertTrue((boolean)listings.contains("http://localhost:" + PORT + "/test/services/rest2?_wadl"));
        JAXRSSoapBookTest.assertEquals((long)200L, (long)WebClient.create((String)("http://localhost:" + PORT + "/test/services/rest2?_wadl&type=xml")).get().getStatus());
        JAXRSSoapBookTest.assertFalse((boolean)listings.contains("http://localhost:" + PORT + "/test/services/rest3?_wadl"));
        JAXRSSoapBookTest.assertFalse((boolean)listings.contains("Atom Log Feed"));
        WebClient webClient = WebClient.create((String)("http://localhost:" + PORT + "/test/services/rest3?_wadl"));
        JAXRSSoapBookTest.assertEquals((long)404L, (long)webClient.get().getStatus());
    }

    @Test
    public void testAddFeatureToClient() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(baseAddress);
        bean.setResourceClass(BookStoreJaxrsJaxws.class);
        TestFeature testFeature = new TestFeature();
        ArrayList<TestFeature> features = new ArrayList<TestFeature>();
        features.add(testFeature);
        bean.setFeatures(features);
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)bean.create();
        Book b = proxy.getBook(new Long("123"));
        JAXRSSoapBookTest.assertTrue((String)"Out Interceptor not invoked", (boolean)testFeature.handleMessageOnOutInterceptorCalled());
        JAXRSSoapBookTest.assertTrue((String)"In Interceptor not invoked", (boolean)testFeature.handleMessageOnInInterceptorCalled());
        JAXRSSoapBookTest.assertEquals((long)123L, (long)b.getId());
        JAXRSSoapBookTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testServerFaultInInterceptor() throws Exception {
        this.serverFaultInInterceptorTest("999");
        this.serverFaultInInterceptorTest("322");
    }

    @Test
    public void testClientFaultOutInterceptor() throws Exception {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(baseAddress);
        bean.setResourceClass(BookStoreJaxrsJaxws.class);
        boolean addBadOutInterceptor = true;
        TestFeature testFeature = new TestFeature(true);
        ArrayList<TestFeature> features = new ArrayList<TestFeature>();
        features.add(testFeature);
        bean.setFeatures(features);
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)bean.create();
        try {
            proxy.getBook(new Long("123"));
            JAXRSSoapBookTest.fail((String)"Method should have thrown an exception");
        }
        catch (Exception e) {
            JAXRSSoapBookTest.assertTrue((String)"Out Interceptor not invoked", (boolean)testFeature.handleMessageOnOutInterceptorCalled());
            JAXRSSoapBookTest.assertTrue((String)"In Interceptor not invoked", (!testFeature.handleMessageOnInInterceptorCalled() ? 1 : 0) != 0);
            JAXRSSoapBookTest.assertTrue((String)"Wrong exception caught", (boolean)"fault from bad interceptor".equals(e.getCause().getMessage()));
            JAXRSSoapBookTest.assertTrue((String)"Client In Fault In Interceptor was invoked", (!testFeature.faultInInterceptorCalled() ? 1 : 0) != 0);
        }
    }

    private void serverFaultInInterceptorTest(String param) {
        String baseAddress = "http://localhost:" + PORT + "/test/services/rest";
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(baseAddress);
        bean.setResourceClass(BookStoreJaxrsJaxws.class);
        TestFeature testFeature = new TestFeature();
        ArrayList<TestFeature> features = new ArrayList<TestFeature>();
        features.add(testFeature);
        bean.setFeatures(features);
        BookStoreJaxrsJaxws proxy = (BookStoreJaxrsJaxws)bean.create();
        WebClient.getConfig((Object)proxy).getRequestContext().put("org.apache.cxf.http.no_io_exceptions", false);
        try {
            proxy.getBook(new Long(param));
            JAXRSSoapBookTest.fail((String)"Method should have thrown an exception");
        }
        catch (Exception e) {
            JAXRSSoapBookTest.assertTrue((String)"Out Interceptor not invoked", (boolean)testFeature.handleMessageOnOutInterceptorCalled());
            if ("322".equals(param)) {
                JAXRSSoapBookTest.assertTrue((String)"In Interceptor not invoked", (boolean)testFeature.handleMessageOnInInterceptorCalled());
            } else {
                JAXRSSoapBookTest.assertTrue((String)"In Interceptor not invoked", (!testFeature.handleMessageOnInInterceptorCalled() ? 1 : 0) != 0);
            }
            JAXRSSoapBookTest.assertTrue((String)"Client In Fault In Interceptor not invoked", (boolean)testFeature.faultInInterceptorCalled());
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }

    private InputStream getHttpInputStream(String endpointAddress) throws Exception {
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/xml,text/plain");
        return connect.getInputStream();
    }

    private Book readBook(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Book)u.unmarshal(is);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public class TestFaultInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private boolean handleMessageCalled;

        public TestFaultInInterceptor() {
            this("pre-stream");
        }

        public TestFaultInInterceptor(String s) {
            super("pre-stream");
        }

        public void handleMessage(Message message) throws Fault {
            this.handleMessageCalled = true;
        }

        protected boolean handleMessageCalled() {
            return this.handleMessageCalled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public class TestOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private boolean handleMessageCalled;
        private boolean isBadOutInterceptor;

        public TestOutInterceptor(boolean isBadOutInterceptor) {
            this("pre-marshal");
            this.isBadOutInterceptor = isBadOutInterceptor;
        }

        public TestOutInterceptor(String s) {
            super("pre-marshal");
        }

        public void handleMessage(Message message) throws Fault {
            this.handleMessageCalled = true;
            if (this.isBadOutInterceptor) {
                throw new Fault((Throwable)new Exception("fault from bad interceptor"));
            }
        }

        protected boolean handleMessageCalled() {
            return this.handleMessageCalled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public class TestInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private boolean handleMessageCalled;

        public TestInInterceptor() {
            this("pre-stream");
        }

        public TestInInterceptor(String s) {
            super("pre-stream");
        }

        public void handleMessage(Message message) throws Fault {
            this.handleMessageCalled = true;
        }

        protected boolean handleMessageCalled() {
            return this.handleMessageCalled;
        }
    }

    @Ignore
    public class TestFeature
    extends AbstractFeature {
        private TestOutInterceptor testOutInterceptor;
        private TestInInterceptor testInInterceptor;
        private TestFaultInInterceptor testFaultInInterceptor;
        private boolean addBadOutInterceptor;

        public TestFeature() {
        }

        public TestFeature(boolean addBadOutInterceptor) {
            this.addBadOutInterceptor = addBadOutInterceptor;
        }

        protected void initializeProvider(InterceptorProvider provider, Bus bus) {
            this.testOutInterceptor = new TestOutInterceptor(this.addBadOutInterceptor);
            this.testInInterceptor = new TestInInterceptor();
            this.testFaultInInterceptor = new TestFaultInInterceptor();
            provider.getOutInterceptors().add(this.testOutInterceptor);
            provider.getInInterceptors().add(this.testInInterceptor);
            provider.getInFaultInterceptors().add(this.testFaultInInterceptor);
        }

        protected boolean handleMessageOnOutInterceptorCalled() {
            return this.testOutInterceptor.handleMessageCalled();
        }

        protected boolean handleMessageOnInInterceptorCalled() {
            return this.testInInterceptor.handleMessageCalled();
        }

        protected boolean faultInInterceptorCalled() {
            return this.testFaultInInterceptor.handleMessageCalled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public class TestStreamDrainInterptor
    extends AbstractPhaseInterceptor<Message> {
        public TestStreamDrainInterptor() {
            super("receive");
        }

        public void handleMessage(Message message) throws Fault {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (is == null) {
                return;
            }
            try {
                byte[] payload = IOUtils.readBytesFromStream((InputStream)is);
                Assert.assertTrue((String)"payload was null", (payload != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"payload was EMPTY", (payload.length > 0 ? 1 : 0) != 0);
                message.setContent(InputStream.class, (Object)new ByteArrayInputStream(payload));
            }
            catch (Exception e) {
                String error = "Failed to read the stream properly due to " + e.getMessage();
                Assert.assertFalse((String)error, (e != null ? 1 : 0) != 0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public static class TestResponseExceptionMapper
    implements ResponseExceptionMapper<BookNotFoundFault> {
        public BookNotFoundFault fromResponse(Response r) {
            Object value = r.getMetadata().getFirst((Object)"BOOK-HEADER");
            if (value != null) {
                return new BookNotFoundFault(value.toString());
            }
            throw new WebApplicationException();
        }
    }
}

