/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.net.URISyntaxException;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;

public abstract class AbstractSpringServer
extends AbstractBusTestServerBase {
    public static final String PORT = AbstractSpringServer.allocatePort(AbstractSpringServer.class);
    private Server server;
    private String resourcePath;
    private String contextPath;
    private int port;

    protected AbstractSpringServer(String path) {
        this(path, "/", Integer.parseInt(PORT));
    }

    protected AbstractSpringServer(String path, int portNumber) {
        this(path, "/", portNumber);
    }

    protected AbstractSpringServer(String path, String cPath) {
        this(path, cPath, Integer.parseInt(PORT));
    }

    protected AbstractSpringServer(String path, String cPath, int portNumber) {
        this.resourcePath = path;
        this.contextPath = cPath;
        this.port = portNumber;
    }

    protected void run() {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        WebAppContext webappcontext = new WebAppContext();
        webappcontext.setContextPath(this.contextPath);
        String warPath = null;
        try {
            warPath = ((Object)((Object)this)).getClass().getResource(this.resourcePath).toURI().getPath();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        webappcontext.setWar(warPath);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{webappcontext, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        try {
            this.configureServer(this.server);
            this.server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void configureServer(Server theserver) throws Exception {
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }
}

