/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.awt.Image;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.JSONProvider;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.MultipartServer;
import org.apache.cxf.systest.jaxrs.MultipartStore;
import org.apache.cxf.systest.jaxrs.XopType;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSMultipartTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = MultipartServer.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSMultipartTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSMultipartTest.launchServer(MultipartServer.class, (boolean)true));
    }

    @Test
    public void testBookAsRootAttachmentStreamSource() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/stream";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testBookAsRootAttachmentStreamSourceNoContentId() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/stream";
        this.doAddBook(address, "attachmentData3", 200);
    }

    @Test
    public void testBookAsRootAttachmentInputStream() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/istream";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testBookAsMessageContextDataHandler() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/mchandlers";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testBookAsMessageContextAttachments() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/attachments";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testBookJSONForm() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jsonform";
        this.doAddFormBook(address, "attachmentFormJson", 200);
    }

    @Test
    public void testBookJaxbForm() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxbform";
        this.doAddFormBook(address, "attachmentFormJaxb", 200);
    }

    @Test
    public void testBookJSONJAXBForm() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jsonjaxbform";
        this.doAddFormBook(address, "attachmentFormJsonJaxb", 200);
    }

    @Test
    public void testBookJSONJAXBFormEncoded() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jsonjaxbform";
        this.doAddFormBook(address, "attachmentFormJsonJaxbEncoded", 200);
    }

    @Test
    public void testBookJSONFormTwoFiles() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/filesform";
        this.doAddFormBook(address, "attachmentFormJsonFiles", 200);
    }

    @Test
    public void testBookJSONFormOneFile() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/fileform";
        this.doAddFormBook(address, "attachmentFormJsonFile", 200);
    }

    @Test
    public void testBookAsMessageContextAttachment() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/attachment";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsRootAttachmentJAXB() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxb";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsDataSource() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/dsource";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsDataSource2() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/dsource2";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsBody() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/body";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookFormData() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/form";
        this.doAddBook("multipart/form-data", address, "attachmentForm", 200);
    }

    @Test
    public void testAddBookFormParam() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/formparam";
        this.doAddBook("multipart/form-data", address, "attachmentForm", 200);
    }

    @Test
    public void testAddBookFormBody() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/formbody";
        this.doAddBook("multipart/form-data", address, "attachmentForm", 200);
    }

    @Test
    public void testAddBookFormBody2() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/formbody2";
        this.doAddBook("multipart/form-data", address, "attachmentForm", 200);
    }

    @Test
    public void testAddBookFormParamBean() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/formparambean";
        this.doAddBook("multipart/form-data", address, "attachmentForm", 200);
    }

    @Test
    public void testAddBookAsJAXB2() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxb2";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsJAXBBody() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxb-body";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsListOfAttachments() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/listattachments";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsListOfStreams() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/lististreams";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsJAXBJSON() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxbjson";
        this.doAddBook(address, "attachmentData2", 200);
    }

    @Test
    public void testAddBookAsJAXBJSONProxy() throws Exception {
        MultipartStore store = (MultipartStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), MultipartStore.class);
        Book b = store.addBookJaxbJsonWithConsumes(new Book2("CXF in Action", 1L), new Book("CXF in Action - 2", 2L));
        JAXRSMultipartTest.assertEquals((long)124L, (long)b.getId());
        JAXRSMultipartTest.assertEquals((Object)"CXF in Action - 2", (Object)b.getName());
    }

    @Test
    public void testAddBookAsJAXBOnlyProxy() throws Exception {
        MultipartStore store = (MultipartStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), MultipartStore.class);
        Book2 b = store.addBookJaxbOnlyWithConsumes(new Book2("CXF in Action", 1L));
        JAXRSMultipartTest.assertEquals((long)1L, (long)b.getId());
        JAXRSMultipartTest.assertEquals((Object)"CXF in Action", (Object)b.getName());
    }

    @Test
    public void testAddBookAsJAXBJSONMixed() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxbjson";
        this.doAddBook("multipart/mixed", address, "attachmentData2", 200);
    }

    @Test
    public void testConsumesMismatch() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/mismatch1";
        this.doAddBook(address, "attachmentData2", 415);
    }

    @Test
    public void testConsumesMismatch2() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/mismatch2";
        this.doAddBook(address, "attachmentData2", 415);
    }

    @Test
    public void testAddBookAsDataHandler() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/dhandler";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookWebClient() {
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/add_book.txt");
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxb";
        WebClient client = WebClient.create((String)address);
        client.type("multipart/related;type=text/xml").accept(new String[]{"text/xml"});
        Book book = (Book)client.post((Object)is1, Book.class);
        JAXRSMultipartTest.assertEquals((Object)"CXF in Action - 2", (Object)book.getName());
    }

    @Test
    public void testAddCollectionOfBooksWithProxy() {
        this.doTestAddCollectionOfBooksWithProxy(true);
    }

    @Test
    public void testAddCollectionOfBooksWithProxyWithoutHeader() {
        this.doTestAddCollectionOfBooksWithProxy(false);
    }

    public void doTestAddCollectionOfBooksWithProxy(boolean addHeader) {
        String address = "http://localhost:" + PORT;
        MultipartStore client = (MultipartStore)JAXRSClientFactory.create((String)address, MultipartStore.class);
        if (addHeader) {
            WebClient.client((Object)client).header("Content-Type", new Object[]{"multipart/mixed;type=application/xml"});
        }
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(new Book("CXF 1", 1L));
        books.add(new Book("CXF 2", 2L));
        List<Book> books2 = addHeader ? client.addBooks(books) : client.addBooksWithoutHeader(books);
        JAXRSMultipartTest.assertNotSame(books, books2);
        JAXRSMultipartTest.assertEquals((long)2L, (long)books2.size());
        JAXRSMultipartTest.assertEquals((long)((Book)books.get(0)).getId(), (long)books2.get(0).getId());
        JAXRSMultipartTest.assertEquals((long)((Book)books.get(1)).getId(), (long)books2.get(1).getId());
    }

    @Test
    public void testXopWebClient() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/xop";
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(address);
        bean.setProperties(Collections.singletonMap("mtom-enabled", "true"));
        WebClient client = bean.createWebClient();
        HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
        conduit.getClient().setReceiveTimeout(1000000L);
        conduit.getClient().setConnectionTimeout(1000000L);
        client.type("multipart/related").accept(new String[]{"multipart/related"});
        XopType xop = new XopType();
        xop.setName("xopName");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/book.xsd");
        byte[] data = IOUtils.readBytesFromStream((InputStream)is);
        xop.setAttachinfo(new DataHandler((DataSource)new ByteArrayDataSource(data, "application/octet-stream")));
        String bookXsd = IOUtils.readStringFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/book.xsd"));
        xop.setAttachinfo2(bookXsd.getBytes());
        if (Boolean.getBoolean("java.awt.headless")) {
            System.out.println("Running headless. Ignoring an Image property.");
        } else {
            xop.setImage(this.getImage("/org/apache/cxf/systest/jaxrs/resources/java.jpg"));
        }
        XopType xop2 = (XopType)client.post((Object)xop, XopType.class);
        String bookXsdOriginal = IOUtils.readStringFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/book.xsd"));
        String bookXsd2 = IOUtils.readStringFromStream((InputStream)xop2.getAttachinfo().getInputStream());
        JAXRSMultipartTest.assertEquals((Object)bookXsdOriginal, (Object)bookXsd2);
    }

    private Image getImage(String name) throws Exception {
        return ImageIO.read(((Object)((Object)this)).getClass().getResource(name));
    }

    @Test
    public void testNullableParamsMultipartAnnotation() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/testnullpart";
        this.doTestNullPart(address);
    }

    @Test
    public void testNullableParamsFormParamAnnotation() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/testnullpartFormParam";
        this.doTestNullPart(address);
    }

    private void doTestNullPart(String address) throws Exception {
        WebClient client = WebClient.create((String)address);
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        client.type("multipart/form-data").accept(new String[]{"text/plain"});
        LinkedList<Attachment> atts = new LinkedList<Attachment>();
        atts.add(new Attachment("somepart", "text/plain", (Object)"hello there"));
        Response r = client.postCollection(atts, Attachment.class);
        JAXRSMultipartTest.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        JAXRSMultipartTest.assertEquals((Object)"nobody home", (Object)IOUtils.readStringFromStream((InputStream)((InputStream)r.getEntity())));
    }

    @Test
    public void testAddBookJaxbJsonImageWebClient() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxbjsonimage";
        WebClient client = WebClient.create((String)address);
        client.type("multipart/mixed").accept(new String[]{"multipart/mixed"});
        Book jaxb = new Book("jaxb", 1L);
        Book json = new Book("json", 2L);
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg");
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        objects.put("application/xml", jaxb);
        objects.put("application/json", json);
        objects.put("application/octet-stream", is1);
        Collection coll = client.postAndGetCollection(objects, Attachment.class);
        ArrayList result = new ArrayList(coll);
        Book jaxb2 = this.readBookFromInputStream(((Attachment)result.get(0)).getDataHandler().getInputStream());
        JAXRSMultipartTest.assertEquals((Object)"jaxb", (Object)jaxb2.getName());
        JAXRSMultipartTest.assertEquals((long)1L, (long)jaxb2.getId());
        Book json2 = this.readJSONBookFromInputStream(((Attachment)result.get(1)).getDataHandler().getInputStream());
        JAXRSMultipartTest.assertEquals((Object)"json", (Object)json2.getName());
        JAXRSMultipartTest.assertEquals((long)2L, (long)json2.getId());
        InputStream is2 = ((Attachment)result.get(2)).getDataHandler().getInputStream();
        byte[] image1 = IOUtils.readBytesFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg"));
        byte[] image2 = IOUtils.readBytesFromStream((InputStream)is2);
        JAXRSMultipartTest.assertTrue((boolean)Arrays.equals(image1, image2));
    }

    @Test
    public void testGetBookJaxbJsonProxy() throws Exception {
        String address = "http://localhost:" + PORT;
        MultipartStore client = (MultipartStore)JAXRSClientFactory.create((String)address, MultipartStore.class);
        Map<String, Book> map = client.getBookJaxbJson();
        ArrayList<Book> result = new ArrayList<Book>(map.values());
        Book jaxb = (Book)result.get(0);
        JAXRSMultipartTest.assertEquals((Object)"jaxb", (Object)jaxb.getName());
        JAXRSMultipartTest.assertEquals((long)1L, (long)jaxb.getId());
        Book json = (Book)result.get(1);
        JAXRSMultipartTest.assertEquals((Object)"json", (Object)json.getName());
        JAXRSMultipartTest.assertEquals((long)2L, (long)json.getId());
    }

    @Test
    public void testGetBookJaxbJsonProxy2() throws Exception {
        String address = "http://localhost:" + PORT;
        MultipartStore client = (MultipartStore)JAXRSClientFactory.create((String)address, MultipartStore.class);
        Map<String, Object> map = client.getBookJaxbJsonObject();
        ArrayList<Object> result = new ArrayList<Object>(map.values());
        JAXRSMultipartTest.assertEquals((long)2L, (long)result.size());
        JAXRSMultipartTest.assertTrue((boolean)((Attachment)result.get(0)).getContentType().toString().contains("application/xml"));
        JAXRSMultipartTest.assertTrue((boolean)((Attachment)result.get(1)).getContentType().toString().contains("application/json"));
    }

    @Test
    public void testAddBookJaxbJsonImageAttachments() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxbimagejson";
        WebClient client = WebClient.create((String)address);
        client.type("multipart/mixed").accept(new String[]{"multipart/mixed"});
        Book jaxb = new Book("jaxb", 1L);
        Book json = new Book("json", 2L);
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg");
        ArrayList<Attachment> objects = new ArrayList<Attachment>();
        objects.add(new Attachment("<theroot>", "application/xml", (Object)jaxb));
        objects.add(new Attachment("thejson", "application/json", (Object)json));
        objects.add(new Attachment("theimage", "application/octet-stream", (Object)is1));
        Collection coll = client.postAndGetCollection(objects, Attachment.class);
        ArrayList result = new ArrayList(coll);
        Book jaxb2 = this.readBookFromInputStream(((Attachment)result.get(0)).getDataHandler().getInputStream());
        JAXRSMultipartTest.assertEquals((Object)"jaxb", (Object)jaxb2.getName());
        JAXRSMultipartTest.assertEquals((long)1L, (long)jaxb2.getId());
        Book json2 = this.readJSONBookFromInputStream(((Attachment)result.get(1)).getDataHandler().getInputStream());
        JAXRSMultipartTest.assertEquals((Object)"json", (Object)json2.getName());
        JAXRSMultipartTest.assertEquals((long)2L, (long)json2.getId());
        InputStream is2 = ((Attachment)result.get(2)).getDataHandler().getInputStream();
        byte[] image1 = IOUtils.readBytesFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg"));
        byte[] image2 = IOUtils.readBytesFromStream((InputStream)is2);
        JAXRSMultipartTest.assertTrue((boolean)Arrays.equals(image1, image2));
    }

    @Test
    public void testAddGetJaxbBooksWebClient() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/jaxbonly";
        WebClient client = WebClient.create((String)address);
        client.type("multipart/mixed;type=application/xml").accept(new String[]{"multipart/mixed"});
        Book b = new Book("jaxb", 1L);
        Book b2 = new Book("jaxb2", 2L);
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(b);
        books.add(b2);
        Collection coll = client.postAndGetCollection(books, Book.class);
        ArrayList result = new ArrayList(coll);
        Book jaxb = (Book)result.get(0);
        JAXRSMultipartTest.assertEquals((Object)"jaxb", (Object)jaxb.getName());
        JAXRSMultipartTest.assertEquals((long)1L, (long)jaxb.getId());
        Book jaxb2 = (Book)result.get(1);
        JAXRSMultipartTest.assertEquals((Object)"jaxb2", (Object)jaxb2.getName());
        JAXRSMultipartTest.assertEquals((long)2L, (long)jaxb2.getId());
    }

    @Test
    public void testAddGetImageWebClient() throws Exception {
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg");
        String address = "http://localhost:" + PORT + "/bookstore/books/image";
        WebClient client = WebClient.create((String)address);
        HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
        conduit.getClient().setReceiveTimeout(1000000L);
        conduit.getClient().setConnectionTimeout(1000000L);
        client.type("multipart/mixed").accept(new String[]{"multipart/mixed"});
        InputStream is2 = (InputStream)client.post((Object)is1, InputStream.class);
        byte[] image1 = IOUtils.readBytesFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg"));
        byte[] image2 = IOUtils.readBytesFromStream((InputStream)is2);
        JAXRSMultipartTest.assertTrue((boolean)Arrays.equals(image1, image2));
    }

    @Test
    public void testUploadImageFromForm() throws Exception {
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg");
        String address = "http://localhost:" + PORT + "/bookstore/books/formimage";
        WebClient client = WebClient.create((String)address);
        HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
        conduit.getClient().setReceiveTimeout(1000000L);
        conduit.getClient().setConnectionTimeout(1000000L);
        client.type("multipart/form-data").accept(new String[]{"multipart/form-data"});
        ContentDisposition cd = new ContentDisposition("attachment;filename=java.jpg");
        MetadataMap headers = new MetadataMap();
        headers.putSingle((Object)"Content-ID", (Object)"image");
        headers.putSingle((Object)"Content-Disposition", (Object)cd.toString());
        headers.putSingle((Object)"Content-Location", (Object)"http://host/bar");
        headers.putSingle((Object)"custom-header", (Object)"custom");
        Attachment att = new Attachment(is1, (MultivaluedMap)headers);
        MultipartBody body = new MultipartBody(att);
        MultipartBody body2 = (MultipartBody)client.post((Object)body, MultipartBody.class);
        InputStream is2 = body2.getRootAttachment().getDataHandler().getInputStream();
        byte[] image1 = IOUtils.readBytesFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg"));
        byte[] image2 = IOUtils.readBytesFromStream((InputStream)is2);
        JAXRSMultipartTest.assertTrue((boolean)Arrays.equals(image1, image2));
        ContentDisposition cd2 = body2.getRootAttachment().getContentDisposition();
        JAXRSMultipartTest.assertEquals((Object)"attachment;filename=java.jpg", (Object)cd2.toString());
        JAXRSMultipartTest.assertEquals((Object)"java.jpg", (Object)cd2.getParameter("filename"));
        JAXRSMultipartTest.assertEquals((Object)"http://host/location", (Object)body2.getRootAttachment().getHeader("Content-Location"));
    }

    @Test
    public void testUploadImageFromForm2() throws Exception {
        File file = new File(((Object)((Object)this)).getClass().getResource("/org/apache/cxf/systest/jaxrs/resources/java.jpg").toURI().getPath());
        String address = "http://localhost:" + PORT + "/bookstore/books/formimage2";
        WebClient client = WebClient.create((String)address);
        HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
        conduit.getClient().setReceiveTimeout(1000000L);
        conduit.getClient().setConnectionTimeout(1000000L);
        client.type("multipart/form-data").accept(new String[]{"multipart/form-data"});
        MultipartBody body2 = (MultipartBody)client.post((Object)file, MultipartBody.class);
        InputStream is2 = body2.getRootAttachment().getDataHandler().getInputStream();
        byte[] image1 = IOUtils.readBytesFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg"));
        byte[] image2 = IOUtils.readBytesFromStream((InputStream)is2);
        JAXRSMultipartTest.assertTrue((boolean)Arrays.equals(image1, image2));
        ContentDisposition cd2 = body2.getRootAttachment().getContentDisposition();
        JAXRSMultipartTest.assertEquals((Object)"form-data;name=file;filename=java.jpg", (Object)cd2.toString());
        JAXRSMultipartTest.assertEquals((Object)"java.jpg", (Object)cd2.getParameter("filename"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipartRequestNoBody() throws Exception {
        PostMethod post = new PostMethod("http://localhost:" + PORT + "/bookstore/books/image");
        String ct = "multipart/mixed";
        post.setRequestHeader("Content-Type", ct);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSMultipartTest.assertEquals((long)400L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipartRequestTooLarge() throws Exception {
        PostMethod post = new PostMethod("http://localhost:" + PORT + "/bookstore/books/image");
        String ct = "multipart/mixed";
        post.setRequestHeader("Content-Type", ct);
        Part[] parts = new Part[]{new FilePart("image", (PartSource)new ByteArrayPartSource("testfile.png", new byte[0xF00000]), "image/png", null)};
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSMultipartTest.assertEquals((long)413L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    private void doAddBook(String address, String resourceName, int status) throws Exception {
        this.doAddBook("multipart/related", address, resourceName, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddBook(String type, String address, String resourceName, int status) throws Exception {
        PostMethod post = new PostMethod(address);
        String ct = type + "; type=\"text/xml\"; " + "start=\"rootPart\"; " + "boundary=\"----=_Part_4_701508.1145579811786\"";
        post.setRequestHeader("Content-Type", ct);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/" + resourceName);
        InputStreamRequestEntity entity = new InputStreamRequestEntity(is);
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSMultipartTest.assertEquals((long)status, (long)result);
            if (status == 200) {
                InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book.txt");
                JAXRSMultipartTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddFormBook(String address, String resourceName, int status) throws Exception {
        PostMethod post = new PostMethod(address);
        String ct = "multipart/form-data; boundary=bqJky99mlBWa-ZuqjC53mG6EzbmlxB";
        post.setRequestHeader("Content-Type", ct);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/" + resourceName);
        InputStreamRequestEntity entity = new InputStreamRequestEntity(is);
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSMultipartTest.assertEquals((long)status, (long)result);
            if (status == 200) {
                InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book.txt");
                JAXRSMultipartTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }

    private Book readBookFromInputStream(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Book)u.unmarshal(is);
    }

    private Book readJSONBookFromInputStream(InputStream is) throws Exception {
        JSONProvider provider = new JSONProvider();
        return (Book)provider.readFrom(Book.class, Book.class, new Annotation[0], MediaType.APPLICATION_JSON_TYPE, null, is);
    }
}

