/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.AbstractSpringServer;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSUriInfoTest
extends AbstractClientServerTestBase {
    public static final String PORT = SpringServer.PORT;

    @BeforeClass
    public static void beforeClass() throws Exception {
        JAXRSUriInfoTest.launchServer(SpringServer.class, (boolean)true);
    }

    @Test
    public void testBasePathAndPathAndPathParam() throws Exception {
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1", "\"\"", "/");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1/", "\"\"", "/");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1/test", "\"test\"", "test");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1/", "\"\"", "/");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1", "\"\"", "/");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1/bar", "\"bar\"", "bar");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1/bar", "\"bar\"", "bar");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1/bar/test", "\"bar/test\"", "bar/test");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1/bar", "\"bar\"", "bar");
        this.checkUriInfo("http://localhost:" + PORT + "/app/v1/bar", "\"bar\"", "bar");
    }

    private void checkUriInfo(String address, String path, String pathParam) {
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"text/plain"});
        String data = (String)wc.get(String.class);
        JAXRSUriInfoTest.assertEquals((Object)("http://localhost:" + PORT + "/app/v1/," + path + "," + pathParam), (Object)data);
    }

    @Ignore
    @Path(value="/")
    public static class Resource {
        @Context
        private UriInfo uriInfo;

        @GET
        @Path(value="/{path:.*}")
        @Produces(value={"text/plain"})
        public String getBasePathAndPathParam(@PathParam(value="path") String path) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.uriInfo.getBaseUri());
            sb.append(",\"" + path + "\"");
            sb.append("," + this.uriInfo.getPath());
            return sb.toString();
        }
    }

    @Ignore
    public static class SpringServer
    extends AbstractSpringServer {
        public SpringServer() {
            super("/jaxrs_uriinfo", "/app");
        }
    }
}

