/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.failover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.clustering.RandomStrategy;
import org.apache.cxf.clustering.RetryStrategy;
import org.apache.cxf.clustering.SequentialStrategy;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ServerWebApplicationException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.features.clustering.FailoverFeature;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.failover.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class FailoverTest
extends AbstractBusClientServerTestBase {
    public static final String NON_PORT = FailoverTest.allocatePort(FailoverTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        FailoverTest.assertTrue((String)"server did not launch correctly", (boolean)FailoverTest.launchServer(Server.class, (boolean)true));
        boolean activeReplica1Started = false;
        boolean activeReplica2Started = false;
        for (int i = 0; i < 60; ++i) {
            if (!activeReplica1Started) {
                activeReplica1Started = FailoverTest.checkReplica(Server.ADDRESS2);
            }
            if (!activeReplica2Started) {
                activeReplica2Started = FailoverTest.checkReplica(Server.ADDRESS3);
            }
            if (activeReplica1Started && activeReplica2Started) break;
            Thread.sleep(1000L);
        }
    }

    private static boolean checkReplica(String address) {
        try {
            Response r = WebClient.create((String)address).query("_wadl", new Object[0]).get();
            return r.getStatus() == 200;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Test
    public void testSequentialStrategy() throws Exception {
        FailoverFeature feature = this.getFeature(false, false, Server.ADDRESS2, Server.ADDRESS3);
        this.strategyTest(Server.ADDRESS1, feature, Server.ADDRESS2, null, false, false, false);
    }

    @Test
    public void testSequentialStrategyWithCustomTargetSelector() throws Exception {
        FailoverFeature feature = this.getFeature(true, false, Server.ADDRESS2, Server.ADDRESS3);
        this.strategyTest("resolver://info", feature, Server.ADDRESS3, null, false, false, false);
    }

    @Test
    public void testSequentialStrategyWithCustomTargetSelector2() throws Exception {
        FailoverFeature feature = this.getFeature(true, false, Server.ADDRESS2, Server.ADDRESS3);
        this.strategyTest("resolver://info", feature, Server.ADDRESS3, null, false, false, true);
    }

    @Test
    public void testSequentialStrategyWebClient() throws Exception {
        FailoverFeature feature = this.getFeature(false, false, Server.ADDRESS2, Server.ADDRESS3);
        this.strategyTestWebClient(Server.ADDRESS1, feature, Server.ADDRESS2, null, false, false);
    }

    @Test
    public void testRandomStrategyWebClient() throws Exception {
        FailoverFeature feature = this.getFeature(false, true, Server.ADDRESS3, Server.ADDRESS2);
        this.strategyTestWebClient(Server.ADDRESS1, feature, Server.ADDRESS3, Server.ADDRESS2, false, true);
    }

    @Test
    public void testRandomStrategy() throws Exception {
        FailoverFeature feature = this.getFeature(false, true, Server.ADDRESS2, Server.ADDRESS3);
        this.strategyTest(Server.ADDRESS1, feature, Server.ADDRESS2, Server.ADDRESS3, false, true, true);
    }

    @Test
    public void testRandomStrategy2() throws Exception {
        FailoverFeature feature = this.getFeature(false, true, Server.ADDRESS2, Server.ADDRESS3);
        this.strategyTest(Server.ADDRESS1, feature, Server.ADDRESS2, Server.ADDRESS3, false, true, false);
    }

    @Test
    public void testSequentialStrategyWithDiffBaseAddresses() throws Exception {
        FailoverFeature feature = this.getFeature(false, false, Server.ADDRESS3, null);
        this.strategyTest(Server.ADDRESS1, feature, Server.ADDRESS3, Server.ADDRESS2, false, false, false);
    }

    public void testSequentialStrategyWithDiffBaseAddresses2() throws Exception {
        FailoverFeature feature = this.getFeature(false, false, Server.ADDRESS3, null);
        this.strategyTest(Server.ADDRESS1, feature, Server.ADDRESS3, Server.ADDRESS2, false, false, true);
    }

    @Test(expected=ServerWebApplicationException.class)
    public void testSequentialStrategyWithServerException() throws Exception {
        FailoverFeature feature = this.getFeature(false, false, Server.ADDRESS2, Server.ADDRESS3);
        this.strategyTest(Server.ADDRESS1, feature, Server.ADDRESS2, Server.ADDRESS3, true, false, false);
    }

    @Test(expected=ClientWebApplicationException.class)
    public void testSequentialStrategyFailure() throws Exception {
        FailoverFeature feature = this.getFeature(false, false, "http://localhost:" + NON_PORT + "/non-existent");
        this.strategyTest(Server.ADDRESS1, feature, null, null, false, false, false);
    }

    @Test
    public void testSequentialStrategyWithRetries() throws Exception {
        String address = "http://localhost:" + NON_PORT + "/non-existent";
        String address2 = "http://localhost:" + NON_PORT + "/non-existent2";
        FailoverFeature feature = new FailoverFeature();
        ArrayList<String> alternateAddresses = new ArrayList<String>();
        alternateAddresses.add(address);
        alternateAddresses.add(address2);
        CustomRetryStrategy strategy = new CustomRetryStrategy();
        strategy.setMaxNumberOfRetries(5);
        strategy.setAlternateAddresses(alternateAddresses);
        feature.setStrategy((FailoverStrategy)strategy);
        BookStore store = this.getBookStore(address, feature);
        try {
            store.getBook("1");
            FailoverTest.fail((String)"Exception expected");
        }
        catch (ClientWebApplicationException ex) {
            FailoverTest.assertEquals((long)10L, (long)strategy.getTotalCount());
            FailoverTest.assertEquals((long)5L, (long)strategy.getAddressCount(address));
            FailoverTest.assertEquals((long)5L, (long)strategy.getAddressCount(address2));
        }
    }

    private FailoverFeature getFeature(boolean custom, boolean random, String ... address) {
        SequentialStrategy strategy;
        FailoverFeature feature = new FailoverFeature();
        ArrayList<String> alternateAddresses = new ArrayList<String>();
        for (String s : address) {
            alternateAddresses.add(s);
        }
        if (!random) {
            strategy = new SequentialStrategy();
            strategy.setAlternateAddresses(alternateAddresses);
            feature.setStrategy((FailoverStrategy)strategy);
        } else {
            strategy = new RandomStrategy();
            strategy.setAlternateAddresses(alternateAddresses);
            feature.setStrategy((FailoverStrategy)strategy);
        }
        if (custom) {
            ReplaceInitialAddressSelector selector = new ReplaceInitialAddressSelector();
            feature.setTargetSelector((FailoverTargetSelector)selector);
        }
        return feature;
    }

    protected BookStore getBookStore(String address, FailoverFeature feature) throws Exception {
        JAXRSClientFactoryBean bean = this.createBean(address, feature);
        bean.setServiceClass(BookStore.class);
        return (BookStore)bean.create(BookStore.class, new Object[0]);
    }

    protected WebClient getWebClient(String address, FailoverFeature feature) throws Exception {
        JAXRSClientFactoryBean bean = this.createBean(address, feature);
        return bean.createWebClient();
    }

    protected JAXRSClientFactoryBean createBean(String address, FailoverFeature feature) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(address);
        ArrayList<FailoverFeature> features = new ArrayList<FailoverFeature>();
        features.add(feature);
        bean.setFeatures(features);
        return bean;
    }

    protected void strategyTest(String inactiveReplica, FailoverFeature feature, String activeReplica1, String activeReplica2, boolean expectServerException, boolean expectRandom, boolean singleProxy) throws Exception {
        boolean randomized = false;
        String prevEndpoint = null;
        BookStore bookStore = null;
        if (singleProxy) {
            bookStore = this.getBookStore(inactiveReplica, feature);
        }
        for (int i = 0; i < 20; ++i) {
            if (!singleProxy) {
                bookStore = this.getBookStore(inactiveReplica, feature);
            }
            this.verifyStrategy(bookStore, expectRandom ? RandomStrategy.class : SequentialStrategy.class);
            String bookId = expectServerException ? "9999" : "123";
            Exception ex = null;
            try {
                Book book = bookStore.getBook(bookId);
                FailoverTest.assertNotNull((String)"expected non-null response", (Object)book);
                FailoverTest.assertEquals((String)"unexpected id", (long)123L, (long)book.getId());
            }
            catch (Exception error) {
                if (!expectServerException) {
                    throw error;
                }
                ex = error;
            }
            String currEndpoint = this.getCurrentEndpointAddress(bookStore);
            FailoverTest.assertFalse((boolean)currEndpoint.equals(inactiveReplica));
            if (expectRandom) {
                FailoverTest.assertTrue((currEndpoint.equals(activeReplica1) || currEndpoint.equals(activeReplica2) ? 1 : 0) != 0);
            } else {
                FailoverTest.assertTrue((boolean)currEndpoint.equals(activeReplica1));
            }
            if (expectServerException) {
                FailoverTest.assertNotNull((Object)ex);
                throw ex;
            }
            if (prevEndpoint != null && !currEndpoint.equals(prevEndpoint)) {
                randomized = true;
            }
            prevEndpoint = currEndpoint;
        }
        if (!singleProxy) {
            FailoverTest.assertEquals((String)"unexpected random/sequential distribution of failovers", (Object)expectRandom, (Object)randomized);
        }
    }

    protected void strategyTestWebClient(String inactiveReplica, FailoverFeature feature, String activeReplica1, String activeReplica2, boolean expectServerException, boolean expectRandom) throws Exception {
        boolean randomized = false;
        String prevEndpoint = null;
        for (int i = 0; i < 20; ++i) {
            WebClient bookStore = this.getWebClient(inactiveReplica, feature);
            this.verifyStrategy(bookStore, expectRandom ? RandomStrategy.class : SequentialStrategy.class);
            String bookId = expectServerException ? "9999" : "123";
            bookStore.path((Object)"bookstore/books").path((Object)bookId);
            Exception ex = null;
            try {
                Book book = (Book)bookStore.get(Book.class);
                FailoverTest.assertNotNull((String)"expected non-null response", (Object)book);
                FailoverTest.assertEquals((String)"unexpected id", (long)123L, (long)book.getId());
            }
            catch (Exception error) {
                if (!expectServerException) {
                    throw error;
                }
                ex = error;
            }
            String currEndpoint = this.getCurrentEndpointAddress(bookStore);
            FailoverTest.assertFalse((boolean)currEndpoint.equals(inactiveReplica));
            if (expectRandom) {
                FailoverTest.assertTrue((currEndpoint.equals(activeReplica1) || currEndpoint.equals(activeReplica2) ? 1 : 0) != 0);
            } else {
                FailoverTest.assertTrue((boolean)currEndpoint.equals(activeReplica1));
            }
            if (expectServerException) {
                FailoverTest.assertNotNull((Object)ex);
                throw ex;
            }
            if (prevEndpoint != null && !currEndpoint.equals(prevEndpoint)) {
                randomized = true;
            }
            prevEndpoint = currEndpoint;
        }
        FailoverTest.assertEquals((String)"unexpected random/sequential distribution of failovers", (Object)expectRandom, (Object)randomized);
    }

    protected String getCurrentEndpointAddress(Object client) {
        return WebClient.client((Object)client).getBaseURI().toString();
    }

    protected void verifyStrategy(Object proxy, Class clz) {
        ConduitSelector conduitSelector = WebClient.getConfig((Object)proxy).getConduitSelector();
        if (conduitSelector instanceof FailoverTargetSelector) {
            FailoverStrategy strategy = ((FailoverTargetSelector)conduitSelector).getStrategy();
            FailoverTest.assertTrue((String)"unexpected strategy", (boolean)clz.isInstance(strategy));
        } else {
            FailoverTest.fail((String)("unexpected conduit selector: " + conduitSelector));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomRetryStrategy
    extends RetryStrategy {
        private int totalCount;
        private Map<String, Integer> map = new HashMap<String, Integer>();

        private CustomRetryStrategy() {
        }

        protected <T> T getNextAlternate(List<T> alternates) {
            ++this.totalCount;
            Object next = super.getNextAlternate(alternates);
            String address = (String)next;
            Integer count = this.map.get(address);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.map.put(address, count);
            return (T)next;
        }

        public int getTotalCount() {
            return this.totalCount - 2;
        }

        public int getAddressCount(String address) {
            return this.map.get(address) - 1;
        }
    }

    private static class ReplaceInitialAddressSelector
    extends FailoverTargetSelector {
        private ReplaceInitialAddressSelector() {
        }

        public synchronized void prepare(Message message) {
            EndpointInfo ei = this.getEndpoint().getEndpointInfo();
            ei.setAddress(Server.ADDRESS3);
            message.put((Object)Message.ENDPOINT_ADDRESS, (Object)Server.ADDRESS3);
            super.prepare(message);
        }

        protected boolean requiresFailover(Exchange exchange) {
            return false;
        }
    }
}

