/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.JMSServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.transport.jms.JMSUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSJmsTest
extends AbstractBusClientServerTestBase {
    protected static boolean serversStarted;
    static final String JMS_PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        if (serversStarted) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("org.apache.activemq.default.directory.prefix") != null) {
            props.put("org.apache.activemq.default.directory.prefix", System.getProperty("org.apache.activemq.default.directory.prefix"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        JAXRSJmsTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSJmsTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        JAXRSJmsTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSJmsTest.launchServer(JMSServer.class));
        serversStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBook() throws Exception {
        Context ctx = this.getContext();
        ConnectionFactory factory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Destination destination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.text");
        Destination replyToDestination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.response");
        Connection connection = null;
        try {
            connection = factory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            this.postGetMessage(session, destination, replyToDestination);
            this.checkBookInResponse(session, replyToDestination, 123L, "CXF JMS Rocks");
            session.close();
        }
        finally {
            try {
                connection.stop();
                connection.close();
            }
            catch (JMSException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddGetBook() throws Exception {
        Context ctx = this.getContext();
        ConnectionFactory factory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Destination destination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.text");
        Destination replyToDestination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.response");
        Connection connection = null;
        try {
            connection = factory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            this.postBook(session, destination, replyToDestination);
            this.checkBookInResponse(session, replyToDestination, 124L, "JMS");
            session.close();
        }
        finally {
            try {
                connection.stop();
                connection.close();
            }
            catch (JMSException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneWayBook() throws Exception {
        Context ctx = this.getContext();
        ConnectionFactory factory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Destination destination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.text");
        Destination replyToDestination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.response");
        Connection connection = null;
        try {
            connection = factory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            this.postOneWayBook(session, destination);
            this.checkBookInResponse(session, replyToDestination, 125L, "JMS OneWay");
            session.close();
        }
        finally {
            try {
                connection.stop();
                connection.close();
            }
            catch (JMSException ex) {}
        }
    }

    private void checkBookInResponse(Session session, Destination replyToDestination, long bookId, String bookName) throws Exception {
        MessageConsumer consumer = session.createConsumer(replyToDestination);
        javax.jms.Message jmsMessage = consumer.receive(300000L);
        MessageImpl cxfMessage = new MessageImpl();
        JMSUtils.retrieveAndSetPayload((Message)cxfMessage, (javax.jms.Message)jmsMessage, null);
        Book b = this.readBook((InputStream)cxfMessage.getContent(InputStream.class));
        JAXRSJmsTest.assertEquals((long)bookId, (long)b.getId());
        JAXRSJmsTest.assertEquals((Object)bookName, (Object)b.getName());
    }

    private Context getContext() throws Exception {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", "tcp://localhost:" + JMS_PORT);
        return new InitialContext(props);
    }

    private void postGetMessage(Session session, Destination destination, Destination replyTo) throws Exception {
        MessageProducer producer = session.createProducer(destination);
        javax.jms.Message message = session.createMessage();
        message.setJMSReplyTo(replyTo);
        message.setStringProperty("Accept", "application/xml");
        message.setStringProperty("org.apache.cxf.request.uri", "/bookstore/books/123");
        message.setStringProperty("org.apache.cxf.request.method", "GET");
        producer.send(message);
        producer.close();
    }

    private void postOneWayBook(Session session, Destination destination) throws Exception {
        MessageProducer producer = session.createProducer(destination);
        javax.jms.Message message = JMSUtils.createAndSetPayload((Object)this.writeBook(new Book("JMS OneWay", 125L)), (Session)session, (String)"text");
        message.setStringProperty("Content-Type", "application/xml");
        message.setStringProperty("org.apache.cxf.request.uri", "/bookstore/oneway");
        message.setStringProperty("org.apache.cxf.request.method", "PUT");
        producer.send(message);
        producer.close();
    }

    private void postBook(Session session, Destination destination, Destination replyTo) throws Exception {
        MessageProducer producer = session.createProducer(destination);
        javax.jms.Message message = JMSUtils.createAndSetPayload((Object)this.writeBook(new Book("JMS", 3L)), (Session)session, (String)"text");
        message.setJMSReplyTo(replyTo);
        message.setStringProperty("Content-Type", "application/xml");
        message.setStringProperty("Accept", "text/xml");
        message.setStringProperty("org.apache.cxf.request.uri", "/bookstore/books");
        message.setStringProperty("org.apache.cxf.request.method", "POST");
        message.setStringProperty("custom.protocol.header", "custom.value");
        producer.send(message);
        producer.close();
    }

    private Book readBook(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Book)u.unmarshal(is);
    }

    private String writeBook(Book b) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Marshaller m = c.createMarshaller();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        m.marshal((Object)b, (OutputStream)bos);
        return bos.toString();
    }

    static {
        JMS_PORT = EmbeddedJMSBrokerLauncher.PORT;
    }
}

