/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.cxf.systest.jaxrs.Book;

public final class AtomUtils {
    private AtomUtils() {
    }

    public static Entry createBookEntry(Book b) throws Exception {
        return AtomUtils.createBookEntry(Abdera.getNewFactory(), b, null);
    }

    public static Entry createBookEntry(Factory factory, Book b) throws Exception {
        return AtomUtils.createBookEntry(factory, b, null);
    }

    public static Entry createBookEntry(Book b, String baseUri) throws Exception {
        return AtomUtils.createBookEntry(Abdera.getNewFactory(), b, baseUri);
    }

    public static Entry createBookEntry(Factory factory, Book b, String baseUri) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Entry e = factory.newEntry();
        if (baseUri != null) {
            e.setBaseUri(baseUri);
        }
        e.setTitle(b.getName());
        e.setId(Long.toString(b.getId()));
        StringWriter writer = new StringWriter();
        jc.createMarshaller().marshal((Object)b, (Writer)writer);
        e.setContent(writer.toString(), Content.Type.XML);
        return e;
    }
}

