/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.apache.cxf.systest.jaxrs.BookExceptionMapper;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.BookStorePerRequest;
import org.apache.cxf.systest.jaxrs.RuntimeExceptionMapper;
import org.apache.cxf.systest.jaxrs.jaxws.BookStoreJaxrsJaxws;

@ApplicationPath(value="/thebooks")
public class BookApplication
extends Application {
    private String defaultName;
    private long defaultId;

    public BookApplication(@Context ServletContext sc) {
        if (sc == null) {
            throw new IllegalArgumentException("ServletContext is null");
        }
        if (!"contextParamValue".equals(sc.getInitParameter("contextParam"))) {
            throw new IllegalStateException("ServletContext is not initialized");
        }
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        classes.add(BookStorePerRequest.class);
        classes.add(BookStoreJaxrsJaxws.class);
        classes.add(RuntimeExceptionMapper.class);
        return classes;
    }

    public Set<Object> getSingletons() {
        HashSet<Object> classes = new HashSet<Object>();
        BookStore store = new BookStore();
        store.setDefaultNameAndId(this.defaultName, this.defaultId);
        classes.add(store);
        BookExceptionMapper mapper = new BookExceptionMapper();
        mapper.setToHandle(true);
        classes.add(mapper);
        return classes;
    }

    public void setDefaultName(String name) {
        this.defaultName = name;
    }

    public void setDefaultId(List<String> ids) {
        StringBuilder sb = new StringBuilder();
        for (String id : ids) {
            sb.append(id);
        }
        this.defaultId = Long.valueOf(sb.toString());
    }
}

