/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NameBinding;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.GenericHandler;
import org.apache.cxf.systest.jaxrs.GenericHandlerWriter;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;

public class BookServer20
extends AbstractBusTestServerBase {
    public static final String PORT = BookServer20.allocatePort(BookServer20.class);
    Server server;

    protected void run() {
        Bus bus = BusFactory.getDefaultBus();
        this.setBus(bus);
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setBus(bus);
        sf.setResourceClasses(new Class[]{BookStore.class});
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new PreMatchContainerRequestFilter2());
        providers.add(new PreMatchContainerRequestFilter());
        providers.add(new PostMatchContainerResponseFilter());
        providers.add(new PostMatchContainerResponseFilter3());
        providers.add(new PostMatchContainerResponseFilter2());
        providers.add(new CustomReaderInterceptor());
        providers.add(new CustomWriterInterceptor());
        providers.add(new CustomDynamicFeature());
        providers.add(new PostMatchContainerRequestFilter());
        providers.add(new FaultyContainerRequestFilter());
        providers.add(new PreMatchReplaceStreamOrAddress());
        providers.add(new GenericHandlerWriter());
        sf.setProviders(providers);
        sf.setResourceProvider(BookStore.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStore(), true));
        sf.setAddress("http://localhost:" + PORT + "/");
        this.server = sf.create();
        BusFactory.setDefaultBus(null);
        BusFactory.setThreadDefaultBus(null);
    }

    public void tearDown() throws Exception {
        this.server.stop();
        this.server.destroy();
        this.server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            BookServer20 s = new BookServer20();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }

    public static class CustomDynamicFeature
    implements DynamicFeature {
        private static final ContainerResponseFilter RESPONSE_FILTER = new PostMatchDynamicContainerResponseFilter2();

        public void configure(ResourceInfo resourceInfo, Configurable configurable) {
            configurable.register((Object)new PreMatchDynamicContainerRequestFilter());
            configurable.register((Object)new PostMatchDynamicContainerResponseFilter());
            configurable.register((Object)RESPONSE_FILTER);
        }
    }

    public static class CustomWriterInterceptor
    implements WriterInterceptor {
        @Context
        private HttpServletResponse response;

        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            context.getHeaders().add((Object)"ServerWriterInterceptor", (Object)"serverWrite");
            context.getHeaders().putSingle((Object)"ServerWriterInterceptor2", (Object)"serverWrite2");
            this.response.addHeader("ServerWriterInterceptorHttpResponse", "serverWriteHttpResponse");
            String ct = context.getHeaders().getFirst((Object)"Content-Type").toString();
            if (!ct.endsWith("ISO-8859-1")) {
                ct = ct + "us-ascii";
            }
            context.setMediaType(MediaType.valueOf((String)ct));
            context.proceed();
        }
    }

    public static class CustomReaderInterceptor
    implements ReaderInterceptor {
        @Context
        private ResourceInfo ri;

        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            if (this.ri.getResourceClass() == BookStore.class) {
                context.getHeaders().add((Object)"ServerReaderInterceptor", (Object)"serverRead");
            }
            return context.proceed();
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @NameBinding
    public static @interface Faulty {
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @NameBinding
    public static @interface PostMatchMode {
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @NameBinding
    public static @interface CustomHeaderAdded {
    }

    @BindingPriority(value=2)
    public static class PostMatchDynamicContainerResponseFilter
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            if (!responseContext.getHeaders().containsKey((Object)"Response")) {
                throw new RuntimeException();
            }
            responseContext.getHeaders().add((Object)"DynamicResponse", (Object)"Dynamic");
        }
    }

    @BindingPriority(value=2)
    public static class PostMatchDynamicContainerResponseFilter2
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            if (!responseContext.getHeaders().containsKey((Object)"Response")) {
                throw new RuntimeException();
            }
            responseContext.getHeaders().add((Object)"DynamicResponse2", (Object)"Dynamic2");
        }
    }

    @BindingPriority(value=4)
    @CustomHeaderAdded
    @PostMatchMode
    public static class PostMatchContainerResponseFilter3
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"Custom", (Object)"custom");
            if (!responseContext.getEntity().equals("Postmatch filter error")) {
                Book book = (Book)responseContext.getEntity();
                responseContext.setEntity((Object)new Book(book.getName(), 1L + book.getId()), null, null);
            }
        }
    }

    @BindingPriority(value=1)
    public static class PostMatchContainerResponseFilter2
    implements ContainerResponseFilter {
        @Context
        private ResourceInfo ri;

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            if (this.ri.getResourceMethod() != null && "addBook2".equals(this.ri.getResourceMethod().getName())) {
                return;
            }
            if (!responseContext.getHeaders().containsKey((Object)"Response")) {
                throw new RuntimeException();
            }
            if (!(responseContext.getHeaders().containsKey((Object)"DynamicResponse") && responseContext.getHeaders().containsKey((Object)"DynamicResponse2") || "Prematch filter error".equals(responseContext.getEntity()))) {
                throw new RuntimeException();
            }
            responseContext.getHeaders().add((Object)"Response2", (Object)"OK2");
        }
    }

    @BindingPriority(value=3)
    public static class PostMatchContainerResponseFilter
    implements ContainerResponseFilter {
        @Context
        private ResourceInfo rInfo;

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            String ct = responseContext.getMediaType().toString();
            if (requestContext.getProperty("filterexception") != null) {
                if (!"text/plain".equals(ct)) {
                    throw new RuntimeException();
                }
                responseContext.getHeaders().putSingle((Object)"FilterException", requestContext.getProperty("filterexception"));
            }
            Object entity = responseContext.getEntity();
            Type entityType = responseContext.getEntityType();
            if (entity instanceof GenericHandler && InjectionUtils.getActualType((Type)entityType) == Book.class) {
                ct = ct + ";charset=ISO-8859-1";
                if ("getGenericBook2".equals(this.rInfo.getResourceMethod().getName())) {
                    Annotation[] anns = responseContext.getEntityAnnotations();
                    if (anns.length == 4 && anns[3].annotationType() == Context.class) {
                        responseContext.getHeaders().addFirst((Object)"Annotations", (Object)"OK");
                    }
                } else {
                    responseContext.setEntity((Object)new Book("book", 124L), null, null);
                }
            } else {
                ct = ct + ";charset=";
            }
            responseContext.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
            responseContext.getHeaders().add((Object)"Response", (Object)"OK");
        }
    }

    @Faulty
    @CustomHeaderAdded
    private static class FaultyContainerRequestFilter
    implements ContainerRequestFilter {
        private FaultyContainerRequestFilter() {
        }

        public void filter(ContainerRequestContext context) throws IOException {
            throw new RuntimeException();
        }
    }

    @CustomHeaderAdded
    private static class PostMatchContainerRequestFilter
    implements ContainerRequestFilter {
        @Context
        private UriInfo ui;

        private PostMatchContainerRequestFilter() {
        }

        public void filter(ContainerRequestContext context) throws IOException {
            if (this.ui.getQueryParameters().getFirst((Object)"throwException") != null) {
                context.setProperty("filterexception", (Object)"postmatch");
                throw new InternalServerErrorException(Response.status((int)500).type("text/plain").entity((Object)"Postmatch filter error").build());
            }
            String value = (String)context.getHeaders().getFirst((Object)"Book");
            if (value != null) {
                context.getHeaders().addFirst((Object)"Book", (Object)(value + "3"));
            }
        }
    }

    @PreMatching
    @BindingPriority(value=2)
    private static class PreMatchDynamicContainerRequestFilter
    implements ContainerRequestFilter {
        private PreMatchDynamicContainerRequestFilter() {
        }

        public void filter(ContainerRequestContext context) throws IOException {
            if (!"true".equals(context.getProperty("FirstPrematchingFilter"))) {
                throw new RuntimeException();
            }
            context.setProperty("DynamicPrematchingFilter", (Object)"true");
        }
    }

    @PreMatching
    private static class PreMatchReplaceStreamOrAddress
    implements ContainerRequestFilter {
        @Context
        private UriInfo ui;

        private PreMatchReplaceStreamOrAddress() {
        }

        public void filter(ContainerRequestContext context) throws IOException {
            String path = this.ui.getPath();
            if (path.endsWith("books/checkN")) {
                URI requestURI = URI.create(path.replace("N", "2"));
                context.setRequestUri(requestURI);
                String body = IOUtils.readStringFromStream((InputStream)context.getEntityStream());
                if (!"s".equals(body)) {
                    throw new RuntimeException();
                }
                this.replaceStream(context);
            } else if (path.endsWith("books/check2")) {
                this.replaceStream(context);
            }
        }

        private void replaceStream(ContainerRequestContext context) {
            ByteArrayInputStream is = new ByteArrayInputStream("123".getBytes());
            context.setEntityStream((InputStream)is);
        }
    }

    @PreMatching
    @BindingPriority(value=3)
    private static class PreMatchContainerRequestFilter2
    implements ContainerRequestFilter {
        @Context
        private HttpServletRequest servletRequest;

        private PreMatchContainerRequestFilter2() {
        }

        public void filter(ContainerRequestContext context) throws IOException {
            if (!("true".equals(context.getProperty("FirstPrematchingFilter")) && "true".equals(context.getProperty("DynamicPrematchingFilter")) && "true".equals(this.servletRequest.getAttribute("FirstPrematchingFilter")) && "true".equals(this.servletRequest.getAttribute("DynamicPrematchingFilter")))) {
                throw new RuntimeException();
            }
            context.getHeaders().add((Object)"BOOK", (Object)"12");
        }
    }

    @PreMatching
    @BindingPriority(value=1)
    private static class PreMatchContainerRequestFilter
    implements ContainerRequestFilter {
        private PreMatchContainerRequestFilter() {
        }

        public void filter(ContainerRequestContext context) throws IOException {
            if ("true".equals(context.getProperty("DynamicPrematchingFilter"))) {
                throw new RuntimeException();
            }
            context.setProperty("FirstPrematchingFilter", (Object)"true");
            UriInfo ui = context.getUriInfo();
            String path = ui.getPath(false);
            if ("wrongpath".equals(path)) {
                context.setRequestUri(URI.create("/bookstore/bookheaders/simple"));
            } else if ("throwException".equals(path)) {
                context.setProperty("filterexception", (Object)"prematch");
                throw new InternalServerErrorException(Response.status((int)500).type("text/plain").entity((Object)"Prematch filter error").build());
            }
            MediaType mt = context.getMediaType();
            if (mt != null && mt.toString().equals("text/xml")) {
                String method = context.getMethod();
                if ("PUT".equals(method)) {
                    context.setMethod("POST");
                }
                context.getHeaders().putSingle((Object)"Content-Type", (Object)"application/xml");
            } else {
                String newMt = context.getHeaderString("newmediatype");
                if (newMt != null) {
                    context.getHeaders().putSingle((Object)"Content-Type", (Object)newMt);
                }
            }
            List acceptTypes = context.getAcceptableMediaTypes();
            if (acceptTypes.size() == 1 && ((MediaType)acceptTypes.get(0)).toString().equals("text/mistypedxml")) {
                context.getHeaders().putSingle((Object)"Accept", (Object)"text/xml");
            }
        }
    }
}

