/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.BookServer;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSMultithreadedClientTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServer.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSMultithreadedClientTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSMultithreadedClientTest.launchServer(BookServer.class, (boolean)true));
    }

    @Test
    public void testStatefulWebClientWithCopy() throws Exception {
        this.runWebClients(WebClient.create((String)("http://localhost:" + PORT + "/bookstore")), 10, false, true);
    }

    @Test
    public void testStatefulWebClientThreadLocal() throws Exception {
        this.runWebClients(WebClient.create((String)("http://localhost:" + PORT + "/bookstore"), (boolean)true), 10, true, true);
    }

    @Test
    public void testStatefulWebClientThreadLocalWithCopy() throws Exception {
        this.runWebClients(WebClient.create((String)("http://localhost:" + PORT + "/bookstore"), (boolean)true), 10, false, true);
    }

    @Test
    public void testSimpleWebClient() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/booksecho"));
        client.type("text/plain").accept(new String[]{"text/plain"}).header("CustomHeader", new Object[]{"CustomValue"});
        this.runWebClients(client, 10, true, false);
    }

    @Test
    public void testSimpleProxy() throws Exception {
        BookStore proxy = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        this.runProxies(proxy, 10, true, false);
    }

    @Test
    public void testThreadSafeProxy() throws Exception {
        BookStore proxy = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, Collections.emptyList(), (boolean)true);
        this.runProxies(proxy, 10, true, true);
    }

    @Test
    public void testThreadSafeProxyWithCopy() throws Exception {
        BookStore proxy = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, Collections.emptyList(), (boolean)true);
        this.runProxies(proxy, 10, false, true);
    }

    @Test
    public void testThreadSafeSubProxy() throws Exception {
        BookStore proxy = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, Collections.emptyList(), (boolean)true);
        this.runProxies(proxy.echoThroughBookStoreSub(), 10, true, true);
    }

    private void runWebClients(WebClient client, int numberOfClients, boolean threadSafe, boolean stateCanBeChanged) throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(numberOfClients);
        for (int i = 1; i <= numberOfClients; ++i) {
            WebClient wc = !threadSafe ? WebClient.fromClient((Client)client) : client;
            String bookName = stateCanBeChanged ? Integer.toString(i) : "TheBook";
            String bookHeader = stateCanBeChanged ? "value" + i : "CustomValue";
            executor.execute(new WebClientWorker(wc, bookName, bookHeader, startSignal, doneSignal, stateCanBeChanged));
        }
        startSignal.countDown();
        doneSignal.await(60L, TimeUnit.SECONDS);
        executor.shutdownNow();
        JAXRSMultithreadedClientTest.assertEquals((String)"Not all invocations have completed", (long)0L, (long)doneSignal.getCount());
    }

    private void runProxies(BookStore proxy, int numberOfClients, boolean threadSafe, boolean stateCanBeChanged) throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(numberOfClients);
        for (int i = 1; i <= numberOfClients; ++i) {
            BookStore bs = !threadSafe ? (BookStore)JAXRSClientFactory.fromClient((Client)WebClient.fromClient((Client)WebClient.client((Object)proxy)), BookStore.class) : proxy;
            String bookName = stateCanBeChanged ? Integer.toString(i) : "TheBook";
            String bookHeader = stateCanBeChanged ? "value" + i : "CustomValue";
            executor.execute(new RootProxyWorker(bs, bookName, bookHeader, startSignal, doneSignal, stateCanBeChanged));
        }
        startSignal.countDown();
        doneSignal.await(60L, TimeUnit.SECONDS);
        executor.shutdownNow();
        JAXRSMultithreadedClientTest.assertEquals((String)"Not all invocations have completed", (long)0L, (long)doneSignal.getCount());
    }

    @Ignore
    private class RootProxyWorker
    implements Runnable {
        private BookStore proxy;
        private String bookName;
        private String bookHeader;
        private CountDownLatch startSignal;
        private CountDownLatch doneSignal;
        private boolean stateCanBeChanged;

        public RootProxyWorker(BookStore proxy, String bookName, String bookHeader, CountDownLatch startSignal, CountDownLatch doneSignal, boolean stateCanBeChanged) {
            this.proxy = proxy;
            this.bookName = bookName;
            this.bookHeader = bookHeader;
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
            this.stateCanBeChanged = stateCanBeChanged;
        }

        @Override
        public void run() {
            try {
                this.startSignal.await();
                for (int i = 0; i < 5; ++i) {
                    this.invoke(i);
                }
                this.doneSignal.countDown();
            }
            catch (InterruptedException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("WebClientWorker thread failed for " + this.bookName + "," + this.bookHeader));
            }
        }

        private void invoke(int ind) throws Exception {
            String actualHeaderName = this.bookHeader + ind;
            String actualBookName = this.bookName + ind;
            if (this.stateCanBeChanged) {
                Client c = WebClient.client((Object)this.proxy);
                MultivaluedMap map = c.getHeaders();
                map.putSingle((Object)"CustomHeader", (Object)actualHeaderName);
                c.headers(map);
                this.proxy.echoBookNameAndHeader2(actualBookName);
                this.verifyResponse(c.getResponse(), actualBookName, actualHeaderName);
            } else {
                this.verifyResponse(this.proxy.echoBookNameAndHeader(actualHeaderName, actualBookName), actualBookName, actualHeaderName);
            }
        }

        private void verifyResponse(Response response, String actualBookName, String actualHeaderName) throws Exception {
            Assert.assertEquals((Object)actualHeaderName, (Object)response.getMetadata().getFirst((Object)"CustomHeader").toString());
            String responseValue = IOUtils.readStringFromStream((InputStream)((InputStream)response.getEntity()));
            Assert.assertEquals((Object)actualBookName, (Object)responseValue);
        }
    }

    @Ignore
    private class WebClientWorker
    implements Runnable {
        private WebClient client;
        private String bookName;
        private String bookHeader;
        private CountDownLatch startSignal;
        private CountDownLatch doneSignal;
        private boolean stateCanBeChanged;

        public WebClientWorker(WebClient client, String bookName, String bookHeader, CountDownLatch startSignal, CountDownLatch doneSignal, boolean stateCanBeChanged) {
            this.client = client;
            this.bookName = bookName;
            this.bookHeader = bookHeader;
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
            this.stateCanBeChanged = stateCanBeChanged;
        }

        @Override
        public void run() {
            try {
                this.startSignal.await();
                for (int i = 0; i < 5; ++i) {
                    if (this.stateCanBeChanged) {
                        this.invoke(i);
                        continue;
                    }
                    this.doInvoke(this.bookName, this.bookHeader);
                }
                this.doneSignal.countDown();
            }
            catch (InterruptedException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("WebClientWorker thread failed for " + this.bookName + "," + this.bookHeader));
            }
        }

        private void invoke(int ind) throws Exception {
            this.client.type("text/plain").accept(new String[]{"text/plain"});
            String actualHeaderName = this.bookHeader + ind;
            String actualBookName = this.bookName + ind;
            MultivaluedMap map = this.client.getHeaders();
            map.putSingle((Object)"CustomHeader", (Object)actualHeaderName);
            this.client.headers(map).path((Object)"booksecho");
            this.doInvoke(actualBookName, actualHeaderName);
            this.client.back(true);
        }

        private void doInvoke(String actualBookName, String actualHeaderName) throws Exception {
            Response response = this.client.post((Object)actualBookName);
            Assert.assertEquals((Object)actualHeaderName, (Object)response.getMetadata().getFirst((Object)"CustomHeader").toString());
            String responseValue = IOUtils.readStringFromStream((InputStream)((InputStream)response.getEntity()));
            Assert.assertEquals((Object)actualBookName, (Object)responseValue);
        }
    }
}

