/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.AbstractSpringServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSOverlappingDestinationsTest
extends AbstractBusClientServerTestBase {
    public static final int PORT = SpringServer.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSOverlappingDestinationsTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSOverlappingDestinationsTest.launchServer(SpringServer.class, (boolean)true));
    }

    @Test
    public void testAbsolutePathOne() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/one/bookstore/request"));
        String path = (String)wc.accept(new String[]{"text/plain"}).get(String.class);
        JAXRSOverlappingDestinationsTest.assertEquals((String)"Absolute RequestURI is wrong", (Object)wc.getBaseURI().toString(), (Object)path);
    }

    @Test
    public void testAbsolutePathTwo() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/two/bookstore/request"));
        String path = (String)wc.accept(new String[]{"text/plain"}).get(String.class);
        JAXRSOverlappingDestinationsTest.assertEquals((String)"Absolute RequestURI is wrong", (Object)wc.getBaseURI().toString(), (Object)path);
    }

    @Test
    public void testAbsolutePathOneAndTwo() throws Exception {
        final String requestURI = "http://localhost:" + PORT + "/one/bookstore/request?delay";
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() {
                WebClient wc = WebClient.create((String)requestURI);
                return (String)wc.accept(new String[]{"text/plain"}).get(String.class);
            }
        };
        FutureTask<String> task = new FutureTask<String>(callable);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(task);
        Thread.sleep(1000L);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    JAXRSOverlappingDestinationsTest.this.testAbsolutePathTwo();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Concurrent testAbsolutePathTwo failed");
                }
            }
        };
        new Thread(runnable).start();
        Thread.sleep(2000L);
        String path = task.get();
        JAXRSOverlappingDestinationsTest.assertEquals((String)"Absolute RequestURI is wrong", (Object)requestURI, (Object)path);
    }

    @Test
    public void testAbsolutePathOneAndTwoWithLock() throws Exception {
        WebClient.create((String)("http://localhost:" + PORT + "/one/bookstore/lock")).accept(new String[]{"text/plain"}).get();
        final String requestURI = "http://localhost:" + PORT + "/one/bookstore/uris";
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() {
                WebClient wc = WebClient.create((String)requestURI);
                return (String)wc.accept(new String[]{"text/plain"}).get(String.class);
            }
        };
        FutureTask<String> task = new FutureTask<String>(callable);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(task);
        Thread.sleep(3000L);
        WebClient wc2 = WebClient.create((String)("http://localhost:" + PORT + "/two/bookstore/unlock"));
        wc2.accept(new String[]{"text/plain"}).get();
        String path = task.get();
        JAXRSOverlappingDestinationsTest.assertEquals((String)"Absolute RequestURI is wrong", (Object)requestURI, (Object)path);
    }

    @Path(value="/bookstore")
    public static class Resource {
        private volatile boolean locked;

        @GET
        @Produces(value={"text/plain"})
        @Path(value="request")
        public String getRequestPath(@Context UriInfo ui, @QueryParam(value="delay") String delay) throws Exception {
            if (delay != null) {
                Thread.sleep(5000L);
            }
            return ui.getRequestUri().toString();
        }

        @GET
        @Path(value="/uris")
        @Produces(value={"text/plain"})
        public String getUris(@Context UriInfo uriInfo) {
            String baseUriOnExit;
            String baseUriOnEntry = uriInfo.getRequestUri().toString();
            try {
                while (this.locked) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException x) {
                // empty catch block
            }
            if (!baseUriOnEntry.equals(baseUriOnExit = uriInfo.getRequestUri().toString())) {
                throw new RuntimeException();
            }
            return baseUriOnExit;
        }

        @GET
        @Path(value="/lock")
        @Produces(value={"text/plain"})
        public String lock() {
            this.locked = true;
            return "locked";
        }

        @GET
        @Path(value="/unlock")
        @Produces(value={"text/plain"})
        public String unlock() {
            this.locked = false;
            return "unlocked";
        }
    }

    @Ignore
    public static class SpringServer
    extends AbstractSpringServer {
        public static final int PORT = SpringServer.allocatePortAsInt(SpringServer.class);

        public SpringServer() {
            super("/jaxrs_many_destinations", PORT);
        }
    }
}

