/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.XopType;

@Path(value="/bookstore")
public class MultipartStore {
    @Context
    private MessageContext context;

    @GET
    @Path(value="/content/string")
    @Produces(value={"multipart/mixed"})
    public Attachment getAttachmentWithStringContent() throws Exception {
        Attachment respXMLPayloadAttachment = new Attachment("Response_XML_Payload", "application/xml", (Object)"<Book><id>888</id></Book>");
        return respXMLPayloadAttachment;
    }

    @GET
    @Path(value="/content/bytes")
    @Produces(value={"multipart/mixed"})
    public Attachment getAttachmentWithByteContent() throws Exception {
        Attachment respXMLPayloadAttachment = new Attachment("Response_XML_Payload", "application/xml", (Object)"<Book><id>888</id></Book>".getBytes());
        return respXMLPayloadAttachment;
    }

    @POST
    @Path(value="/books/image")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed"})
    public byte[] addBookImage(byte[] image) throws Exception {
        return image;
    }

    @POST
    @Path(value="/xop")
    @Consumes(value={"multipart/related"})
    @Produces(value={"multipart/related;type=text/xml"})
    public XopType addBookXop(XopType type) throws Exception {
        String bookXsd2;
        if (!"xopName".equals(type.getName())) {
            throw new RuntimeException("Wrong name property");
        }
        String bookXsd = IOUtils.readStringFromStream((InputStream)type.getAttachinfo().getInputStream());
        if (!bookXsd.equals(bookXsd2 = IOUtils.readStringFromStream((InputStream)this.getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/book.xsd")))) {
            throw new RuntimeException("Wrong attachinfo property");
        }
        String bookXsdRef = IOUtils.readStringFromStream((InputStream)type.getAttachInfoRef().getInputStream());
        if (!bookXsdRef.equals(bookXsd2)) {
            throw new RuntimeException("Wrong attachinforef property");
        }
        if (!Boolean.getBoolean("java.awt.headless") && type.getImage() == null) {
            throw new RuntimeException("Wrong image property");
        }
        this.context.put((Object)"mtom-enabled", (Object)"true");
        XopType xop = new XopType();
        xop.setName("xopName");
        InputStream is = this.getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/book.xsd");
        byte[] data = IOUtils.readBytesFromStream((InputStream)is);
        xop.setAttachinfo(new DataHandler((DataSource)new ByteArrayDataSource(data, "application/octet-stream")));
        xop.setAttachInfoRef(new DataHandler((DataSource)new ByteArrayDataSource(data, "application/octet-stream")));
        xop.setAttachinfo2(bookXsd.getBytes());
        xop.setImage(ImageIO.read(this.getClass().getResource("/org/apache/cxf/systest/jaxrs/resources/java.jpg")));
        return xop;
    }

    @POST
    @Path(value="/books/formimage2")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"multipart/form-data"})
    public MultipartBody addBookFormImage2(MultipartBody image) throws Exception {
        image.getAllAttachments();
        return image;
    }

    @Path(value="/books/file/semicolon")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @POST
    public String addBookFileNameSemicolon(@Multipart(value="a") Attachment att) {
        return (String)att.getObject(String.class) + ", filename:" + att.getContentDisposition().getParameter("filename");
    }

    @POST
    @Path(value="/books/formimage")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"multipart/form-data"})
    public MultipartBody addBookFormImage(MultipartBody image) throws Exception {
        List atts = image.getAllAttachments();
        if (atts.size() != 1) {
            throw new WebApplicationException();
        }
        ArrayList<Attachment> newAtts = new ArrayList<Attachment>();
        Attachment at = (Attachment)atts.get(0);
        MultivaluedMap headers = at.getHeaders();
        if (!"http://host/bar".equals(headers.getFirst((Object)"Content-Location"))) {
            throw new WebApplicationException();
        }
        if (!"custom".equals(headers.getFirst((Object)"Custom-Header"))) {
            throw new WebApplicationException();
        }
        headers.putSingle((Object)"Content-Location", (Object)"http://host/location");
        newAtts.add(new Attachment(at.getContentId(), at.getDataHandler(), headers));
        return new MultipartBody(newAtts);
    }

    @POST
    @Path(value="/books/testnullpart")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public String testNullPart(@Multipart(value="someid", required=false) String value) {
        if (value != null) {
            return value;
        }
        return "nobody home";
    }

    @POST
    @Path(value="/books/testnullpartprimitive")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public int testNullPart2(@Multipart(value="someid", required=false) int value) {
        return value;
    }

    @POST
    @Path(value="/books/testnullpartFormParam")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public String testNullPartFormParam(@FormParam(value="someid") String value) {
        return this.testNullPart(value);
    }

    @POST
    @Path(value="/books/jaxbjsonimage")
    @Consumes(value={"multipart/mixed", "multipart/related"})
    @Produces(value={"multipart/mixed", "multipart/related"})
    public Map<String, Object> addBookJaxbJsonImage(@Multipart(value="root.message@cxf.apache.org") Book jaxb, @Multipart(value="1") Book json, @Multipart(value="2") byte[] image) throws Exception {
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        objects.put("application/xml", jaxb);
        objects.put("application/json", json);
        objects.put("application/octet-stream", new ByteArrayInputStream(image));
        return objects;
    }

    @POST
    @Path(value="/books/jaxbimagejson")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed"})
    public Map<String, Object> addBookJaxbJsonImage2(@Multipart(value="theroot") Book jaxb, @Multipart(value="thejson") Book json, @Multipart(value="theimage") byte[] image) throws Exception {
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        objects.put("application/xml", jaxb);
        objects.put("application/json", json);
        objects.put("application/octet-stream", new ByteArrayInputStream(image));
        return objects;
    }

    @GET
    @Path(value="/books/jaxbjsonimage/read")
    @Produces(value={"multipart/mixed"})
    public Map<String, Book> getBookJaxbJson() throws Exception {
        Book jaxb = new Book("jaxb", 1L);
        Book json = new Book("json", 2L);
        LinkedHashMap<String, Book> objects = new LinkedHashMap<String, Book>();
        objects.put("application/xml", jaxb);
        objects.put("application/json", json);
        return objects;
    }

    @GET
    @Path(value="/books/jaxbjsonimage/read2")
    @Produces(value={"multipart/mixed"})
    public Map<String, Book> getBookJson() throws Exception {
        Book json = new Book("json", 1L);
        LinkedHashMap<String, Book> objects = new LinkedHashMap<String, Book>();
        objects.put("application/json", json);
        return objects;
    }

    @GET
    @Path(value="/books/jaxbjsonimage/read-object")
    @Produces(value={"multipart/mixed"})
    public Map<String, Object> getBookJaxbJsonObject() throws Exception {
        Book jaxb = new Book("jaxb", 1L);
        Book json = new Book("json", 2L);
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        objects.put("application/xml", jaxb);
        objects.put("application/json", json);
        return objects;
    }

    @POST
    @Path(value="/books/stream")
    @Produces(value={"text/xml"})
    public Response addBookFromStream(StreamSource source) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        Book b = (Book)u.unmarshal((Source)source);
        b.setId(124L);
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/form")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    public Response addBookFromForm(MultivaluedMap<String, String> data) throws Exception {
        Book b = new Book();
        b.setId(Long.valueOf((String)data.getFirst((Object)"id")));
        b.setName((String)data.getFirst((Object)"name"));
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/formbody")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    public Response addBookFromFormBody(MultipartBody body) throws Exception {
        MultivaluedMap data = AttachmentUtils.populateFormMap((MessageContext)this.context);
        Book b = new Book();
        b.setId(Long.valueOf((String)data.getFirst((Object)"id")));
        b.setName((String)data.getFirst((Object)"name"));
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/formbody2")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    public Response addBookFromFormBody2() throws Exception {
        return this.addBookFromFormBody(AttachmentUtils.getMultipartBody((MessageContext)this.context));
    }

    @POST
    @Path(value="/books/formparam")
    @Produces(value={"text/xml"})
    public Response addBookFromFormParam(@FormParam(value="name") String title, @FormParam(value="id") Long id) throws Exception {
        if (!"CXF in Action - 2".equals(title)) {
            throw new RuntimeException();
        }
        Book b = new Book();
        b.setId(id);
        b.setName(title);
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/formparambean")
    @Produces(value={"text/xml"})
    public Response addBookFromFormBean(@FormParam(value="") Book b) throws Exception {
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/istream")
    @Produces(value={"text/xml"})
    public Response addBookFromInputStream(@Multipart(value="rootPart") InputStream is) throws Exception {
        return this.readBookFromInputStream(is);
    }

    @POST
    @Path(value="/books/istream2")
    @Produces(value={"text/xml"})
    public Book addBookFromInputStreamReadItself(InputStream is) throws Exception {
        String body = IOUtils.readStringFromStream((InputStream)is);
        if (!body.trim().startsWith("--")) {
            throw new RuntimeException();
        }
        return new Book("432", 432L);
    }

    @POST
    @Path(value="/books/dsource")
    @Produces(value={"text/xml"})
    public Response addBookFromDataSource(DataSource ds) throws Exception {
        return this.readBookFromInputStream(ds.getInputStream());
    }

    @POST
    @Path(value="/books/jaxb2")
    @Consumes(value={"multipart/related;type=\"text/xml\""})
    @Produces(value={"text/xml"})
    public Response addBookParts(@Multipart(value="rootPart") Book b1, @Multipart(value="book2") Book b2) throws Exception {
        if (b1.equals(b2)) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        b1.setId(124L);
        return Response.ok((Object)b1).build();
    }

    @POST
    @Path(value="/books/jaxb-body")
    @Consumes(value={"multipart/related;type=\"text/xml\""})
    @Produces(value={"text/xml"})
    public Response addBookParts2(MultipartBody body) throws Exception {
        Book b2;
        Book b1 = (Book)body.getAttachmentObject("rootPart", Book.class);
        if (b1.equals(b2 = (Book)body.getAttachmentObject("book2", Book.class))) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        b1.setId(124L);
        return Response.ok((Object)b1).build();
    }

    @POST
    @Path(value="/books/jaxbonly")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed;type=text/xml"})
    public List<Book> addBooks(List<Book> books) {
        ArrayList<Book> books2 = new ArrayList<Book>();
        books2.addAll(books);
        return books2;
    }

    @POST
    @Path(value="/books/jaxbonly")
    @Consumes(value={"multipart/mixed;type=text/xml"})
    @Produces(value={"multipart/mixed;type=text/xml"})
    public List<Book> addBooksWithoutHeader(List<Book> books) {
        return this.addBooks(books);
    }

    @POST
    @Path(value="/books/jaxbjsonconsumes")
    @Consumes(value={"multipart/related"})
    @Produces(value={"text/xml"})
    public Book addBookJaxbJsonWithConsumes(@Multipart(value="rootPart", type="text/xml") Book2 b1, @Multipart(value="book2", type="application/json") Book b2) throws Exception {
        return this.addBookJaxbJson(b1, b2);
    }

    @POST
    @Path(value="/books/jaxbandsimpleparts")
    @Consumes(value={"multipart/related"})
    @Produces(value={"text/xml"})
    public Book testAddBookAndSimpleParts(@Multipart(value="rootPart", type="text/xml") Book b1, @Multipart(value="simplePart1") String simplePart1, @Multipart(value="simplePart2") String simplePart2) throws Exception {
        return new Book(b1.getName() + " - " + simplePart1 + simplePart2, b1.getId());
    }

    @POST
    @Path(value="/books/jaxbonly")
    @Consumes(value={"multipart/related"})
    @Produces(value={"text/xml"})
    public Book2 addBookJaxbOnlyWithConsumes(@Multipart(value="rootPart", type="text/xml") Book2 b1) throws Exception {
        if (!"CXF in Action".equals(b1.getName())) {
            throw new WebApplicationException();
        }
        return b1;
    }

    @POST
    @Path(value="/books/jaxbjson")
    @Produces(value={"text/xml"})
    public Book addBookJaxbJson(@Multipart(value="rootPart", type="text/xml") Book2 b1, @Multipart(value="book2", type="application/json") Book b2) throws Exception {
        if (!"CXF in Action".equals(b1.getName()) || !"CXF in Action - 2".equals(b2.getName())) {
            throw new WebApplicationException();
        }
        b2.setId(124L);
        return b2;
    }

    @POST
    @Path(value="/books/jsonform")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookJsonFromForm(Book b1) throws Exception {
        b1.setId(124L);
        return Response.ok((Object)b1).build();
    }

    @POST
    @Path(value="/books/filesform")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookFilesForm(@Multipart(value="owner") String name, @Multipart(value="files") List<Book> books) throws Exception {
        if (books.size() != 2) {
            throw new WebApplicationException();
        }
        Book b1 = books.get(0);
        Book b2 = books.get(1);
        if (!("CXF in Action - 1".equals(b1.getName()) && "CXF in Action - 2%".equals(b2.getName()) && "Larry".equals(name))) {
            throw new WebApplicationException();
        }
        b1.setId(124L);
        b1.setName("CXF in Action - 2");
        return Response.ok((Object)b1).build();
    }

    @POST
    @Path(value="/books/filesform2")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookFilesFormNoOwnerParam(@Multipart(value="files") List<Book> books) throws Exception {
        Attachment attOwner = AttachmentUtils.getFirstMatchingPart((MessageContext)this.context, (String)"owner");
        return this.addBookFilesForm((String)attOwner.getObject(String.class), books);
    }

    @POST
    @Path(value="/books/filesform/singlefile")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookFilesFormSingleFile(@Multipart(value="owner") String name, @Multipart(value="file") List<Book> books) throws Exception {
        if (books.size() != 1) {
            throw new WebApplicationException();
        }
        Book b = books.get(0);
        if (!"CXF in Action - 1".equals(b.getName()) || !"Larry".equals(name)) {
            throw new WebApplicationException();
        }
        b.setId(124L);
        b.setName("CXF in Action - 2");
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/filesform/mixup")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookFilesFormMixUp(@FormParam(value="owner") String name, @Multipart(value="files") List<Book> books) throws Exception {
        return this.addBookFilesForm(name, books);
    }

    @POST
    @Path(value="/books/fileform")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookFilesForm(MultipartBody body) throws Exception {
        String owner = (String)body.getAttachmentObject("owner", String.class);
        Book book = (Book)body.getAttachmentObject("file", Book.class);
        if (!"CXF in Action - 1".equals(book.getName()) || !"Larry".equals(owner)) {
            throw new WebApplicationException();
        }
        book.setId(124L);
        book.setName("CXF in Action - 2");
        return Response.ok((Object)book).build();
    }

    @POST
    @Path(value="/books/jaxbform")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookJaxbFromForm(Book b1) throws Exception {
        b1.setId(124L);
        return Response.ok((Object)b1).build();
    }

    @POST
    @Path(value="/books/jsonjaxbform")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookJaxbJsonForm(@Multipart(value="jsonPart") Book b1, @Multipart(value="bookXML") Book b2) throws Exception {
        if (!"CXF in Action - 1".equals(b1.getName()) || !"CXF in Action - 2".equals(b2.getName())) {
            throw new WebApplicationException();
        }
        b2.setId(124L);
        return Response.ok((Object)b2).build();
    }

    @POST
    @Path(value="/books/jsonjaxbformencoded")
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response addBookJaxbJsonFormEncoded(@Multipart(value="jsonPart") Book b1, @Multipart(value="bookXML") Book b2) throws Exception {
        return this.addBookJaxbJsonForm(b1, b2);
    }

    @POST
    @Path(value="/books/dsource2")
    @Produces(value={"text/xml"})
    public Response addBookFromDataSource2(@Multipart(value="rootPart") DataSource ds1, @Multipart(value="book2") DataSource ds2) throws Exception {
        Book b2;
        Response r1 = this.readBookFromInputStream(ds1.getInputStream());
        Response r2 = this.readBookFromInputStream(ds2.getInputStream());
        Book b1 = (Book)r1.getEntity();
        if (b1.equals(b2 = (Book)r2.getEntity())) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        return r1;
    }

    @POST
    @Path(value="/books/listattachments")
    @Produces(value={"text/xml"})
    public Response addBookFromListOfAttachments(List<Attachment> atts) throws Exception {
        Book b2;
        Response r1 = this.readBookFromInputStream(atts.get(0).getDataHandler().getInputStream());
        Response r2 = this.readBookFromInputStream(atts.get(2).getDataHandler().getInputStream());
        Book b1 = (Book)r1.getEntity();
        if (b1.equals(b2 = (Book)r2.getEntity())) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        return r1;
    }

    @POST
    @Path(value="/books/body")
    @Produces(value={"text/xml"})
    public Response addBookFromListOfAttachments(MultipartBody body) throws Exception {
        return this.addBookFromListOfAttachments(body.getAllAttachments());
    }

    @POST
    @Path(value="/books/lististreams")
    @Produces(value={"text/xml"})
    public Response addBookFromListOfStreams(List<InputStream> atts) throws Exception {
        Book b2;
        Response r1 = this.readBookFromInputStream(atts.get(0));
        Response r2 = this.readBookFromInputStream(atts.get(2));
        Book b1 = (Book)r1.getEntity();
        if (b1.equals(b2 = (Book)r2.getEntity())) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        return r1;
    }

    @POST
    @Path(value="/books/dhandler")
    @Produces(value={"text/xml"})
    public Response addBookFromDataHandler(DataHandler dh) throws Exception {
        return this.readBookFromInputStream(dh.getInputStream());
    }

    @POST
    @Path(value="/books/attachment")
    @Produces(value={"text/xml"})
    public Response addBookFromAttachment(Attachment a) throws Exception {
        return this.readBookFromInputStream(a.getDataHandler().getInputStream());
    }

    @POST
    @Path(value="/books/mchandlers")
    @Produces(value={"text/xml"})
    public Response addBookFromMessageContext() throws Exception {
        Map handlers = AttachmentUtils.getAttachmentsMap((MessageContext)this.context);
        for (Map.Entry entry : handlers.entrySet()) {
            if (!((String)entry.getKey()).equals("book2")) continue;
            return this.readBookFromInputStream(((Attachment)entry.getValue()).getDataHandler().getInputStream());
        }
        throw new WebApplicationException(500);
    }

    @POST
    @Path(value="/books/attachments")
    @Produces(value={"text/xml"})
    public Response addBookFromAttachments() throws Exception {
        List handlers = AttachmentUtils.getChildAttachments((MessageContext)this.context);
        for (Attachment a : handlers) {
            if (!a.getContentId().equals("book2")) continue;
            return this.readBookFromInputStream(a.getDataHandler().getInputStream());
        }
        throw new WebApplicationException(500);
    }

    @POST
    @Path(value="/books/jaxb")
    @Produces(value={"text/xml"})
    public Response addBook(Book b) throws Exception {
        b.setId(124L);
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/mismatch1")
    @Consumes(value={"multipart/related;type=\"bar/foo\""})
    @Produces(value={"text/xml"})
    public Response addBookMismatched(Book b) {
        throw new WebApplicationException();
    }

    @POST
    @Path(value="/books/mismatch2")
    @Produces(value={"text/xml"})
    public Response addBookMismatched2(@Multipart(value="rootPart", type="f/b") Book b) {
        throw new WebApplicationException();
    }

    @POST
    @Path(value="/books/mixedmultivaluedmap")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"text/xml"})
    public Response addBookFromFormConsumesMixed(@Multipart(value="mapdata", type="application/x-www-form-urlencoded") MultivaluedMap<String, String> data, @Multipart(value="test-cid", type="application/xml") String testXml) throws Exception {
        if (!"Dreams".equals(((List)data.get((Object)"id-name")).get(0))) {
            throw new Exception("Map entry 0 does not match");
        }
        if (!"True".equals(((List)data.get((Object)"entity-name")).get(0))) {
            throw new Exception("Map entry 1 does not match");
        }
        if (!"NAT5\n".equals(((List)data.get((Object)"native-id")).get(0))) {
            throw new Exception("Map entry 2 does not match");
        }
        if (data.size() != 3) {
            throw new Exception("Map size does not match");
        }
        if ("<hello>World2</hello>".equals(testXml)) {
            throw new Exception("testXml does not match");
        }
        Book b = new Book();
        b.setId(124L);
        b.setName("CXF in Action - 2");
        return Response.ok((Object)b).build();
    }

    private Response readBookFromInputStream(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        Book b = (Book)u.unmarshal(is);
        b.setId(124L);
        return Response.ok((Object)b).build();
    }
}

