/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.cxf.jaxrs.model.wadl.XMLName;

@Path(value="/")
public class PetStore {
    public static final String CLOSED = "The Pet Store is closed";

    @GET
    @Produces(value={"text/plain"})
    public Response getBaseStatus() throws Exception {
        return Response.ok((Object)CLOSED).build();
    }

    @GET
    @Path(value="/petstore/pets/{petId}/")
    @Produces(value={"text/xml"})
    public Response getStatus(@PathParam(value="petId") String petId) throws Exception {
        return Response.ok((Object)CLOSED).build();
    }

    @GET
    @Path(value="/petstore/jaxb/status/")
    @Produces(value={"text/xml"})
    public PetStoreStatus getJaxbStatus() {
        return new PetStoreStatus();
    }

    @GET
    @Path(value="/petstore/jaxb/statusType/")
    @Produces(value={"text/xml"})
    public PetStoreStatusType getJaxbStatusTyoe() {
        return new PetStoreStatusImpl1();
    }

    @GET
    @Path(value="/petstore/jaxb/status/elements")
    @Produces(value={"text/xml", "application/json"})
    @XMLName(value="{http://pets}statuses")
    public List<PetStoreStatusElement> getJaxbStatusElements() {
        return Collections.singletonList(new PetStoreStatusElement());
    }

    @GET
    @Path(value="/petstore/jaxb/status/element")
    @Produces(value={"text/xml"})
    public PetStoreStatusElement getJaxbStatusElement() {
        return new PetStoreStatusElement();
    }

    @POST
    @Path(value="/petstore/pets/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/xml"})
    public Response updateStatus(MultivaluedMap<String, String> params) throws Exception {
        return Response.ok((Object)params.getFirst((Object)"status")).build();
    }

    @XmlRootElement(name="statusImpl2", namespace="http://pets")
    public static class PetStoreStatusImpl2
    extends PetStoreStatusType {
    }

    @XmlRootElement(name="statusImpl1", namespace="http://pets")
    public static class PetStoreStatusImpl1
    extends PetStoreStatusType {
    }

    @XmlType(name="statusType", namespace="http://pets")
    @XmlSeeAlso(value={PetStoreStatusImpl1.class, PetStoreStatusImpl2.class})
    public static class PetStoreStatusType {
        private String status = "The Pet Store is closed";

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    @XmlRootElement(name="elstatus", namespace="http://pets")
    public static class PetStoreStatusElement
    extends PetStoreStatus {
    }

    @XmlType(name="status", namespace="http://pets")
    public static class PetStoreStatus {
        private String status = "The Pet Store is closed";

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

