/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.BookStoreSpring;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RestJsonSchemaJMXTest
extends AbstractBusClientServerTestBase {
    private static MBeanServerConnection mbsc;
    private static final String DEFAULT_JMXSERVICE_URL = "service:jmx:rmi:///jndi/rmi://localhost:9914/jmxrmi";
    private static final Logger LOG;
    private String jmxServerURL;
    private Server localServer;

    @Before
    public void setUp() {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus("/org/apache/cxf/systest/jaxrs/jmx-enable.xml");
        BusFactory.setDefaultBus((Bus)bus);
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setResourceClasses(new Class[]{BookStore.class, BookStoreSpring.class});
        sf.setResourceProvider(BookStore.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStore(), true));
        sf.setResourceProvider(BookStoreSpring.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStoreSpring(), true));
        sf.setTransportId("http://cxf.apache.org/transports/local");
        sf.setAddress("local://books");
        this.localServer = sf.create();
    }

    @After
    public void tearDown() {
        if (this.localServer != null) {
            this.localServer.stop();
        }
    }

    @Test
    public void testJsonSchema() throws Exception {
        String json = "";
        try {
            this.connectToMBserver();
            json = this.invokeEndpoint("getJSONSchema", null);
            this.parseJson(json);
            json = this.invokeEndpoint("getJSONSchemaForClass", "org.apache.cxf.systest.jaxrs.Book");
            this.parseJson(json);
        }
        catch (Throwable e) {
            e.printStackTrace();
            RestJsonSchemaJMXTest.fail((String)("invalid json for " + json));
        }
    }

    private void connectToMBserver() throws IOException {
        this.jmxServerURL = this.jmxServerURL == null ? DEFAULT_JMXSERVICE_URL : this.jmxServerURL;
        JMXServiceURL url = new JMXServiceURL(this.jmxServerURL);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        mbsc = jmxc.getMBeanServerConnection();
    }

    private ObjectName getEndpointObjectName() throws MalformedObjectNameException, NullPointerException {
        StringBuilder buffer = new StringBuilder();
        String serviceName = "{http://jaxrs.systest.cxf.apache.org/}BookStore";
        String portName = "BookStore";
        buffer.append("org.apache.cxf:type=Bus.Service.Endpoint,");
        buffer.append("service=\"" + serviceName + "\",");
        buffer.append("port=\"" + portName + "\",*");
        return new ObjectName(buffer.toString());
    }

    private String invokeEndpoint(String operation, String operationPara) throws Exception {
        ObjectName endpointName = null;
        String ret = "";
        Object[] jmxPara = null;
        String[] jmxSig = null;
        if (operationPara != null) {
            jmxPara = new Object[]{operationPara};
            jmxSig = new String[]{String.class.getName()};
        } else {
            jmxPara = new Object[]{};
            jmxSig = new String[]{};
        }
        ObjectName queryEndpointName = this.getEndpointObjectName();
        Set endpointNames = CastUtils.cast(mbsc.queryNames(queryEndpointName, null));
        Iterator it = endpointNames.iterator();
        if (it.hasNext()) {
            endpointName = (ObjectName)it.next();
            ret = (String)mbsc.invoke(endpointName, operation, jmxPara, jmxSig);
            LOG.info("invoke endpoint " + endpointName + " operation " + operation + " succeed!");
        }
        return ret;
    }

    private void parseJson(String json) throws Exception {
        JsonParser parser = new JsonFactory().createParser(json);
        while (parser.nextToken() != null) {
        }
    }

    static {
        LOG = LogUtils.getL7dLogger(RestJsonSchemaJMXTest.class);
    }
}

