/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.cors;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.cxf.rs.security.cors.LocalPreflight;

@CrossOriginResourceSharing(allowOrigins={"http://area51.mil:31415"}, allowCredentials=true, maxAge=1, allowHeaders={"X-custom-1", "X-custom-2"}, exposeHeaders={"X-custom-3", "X-custom-4"})
public class AnnotatedCorsServer {
    @Context
    private HttpHeaders headers;

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/simpleGet/{echo}")
    public String simpleGet(@PathParam(value="echo") String echo) {
        return echo;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/unannotatedPost")
    public Response postSomething() {
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/delete")
    public Response deleteSomething() {
        return Response.ok().build();
    }

    @OPTIONS
    @Path(value="/delete")
    @LocalPreflight
    public Response deleteOptions() {
        String origin = (String)this.headers.getRequestHeader("Origin").get(0);
        if ("http://area51.mil:3333".equals(origin)) {
            return Response.ok().header("Access-Control-Allow-Methods", (Object)"DELETE PUT").header("Access-Control-Allow-Credentials", (Object)"false").header("Access-Control-Allow-Origin", (Object)"http://area51.mil:3333").build();
        }
        return Response.ok().build();
    }

    @GET
    @CrossOriginResourceSharing(allowOrigins={"http://area51.mil:31415"}, allowCredentials=true, exposeHeaders={"X-custom-3", "X-custom-4"})
    @Produces(value={"text/plain"})
    @Path(value="/annotatedGet/{echo}")
    public String annotatedGet(@PathParam(value="echo") String echo) {
        return echo;
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/annotatedPut")
    public String annotatedPut(String input) {
        return input;
    }
}

