/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.interceptor.security.NamePasswordCallbackHandler;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.security.KerberosAuthenticationFilter;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.testutil.common.TestUtil;

public class BookKerberosServer
extends AbstractBusTestServerBase {
    public static final String PORT = TestUtil.getPortNumber((String)"jaxrs-kerberos");

    protected void run() {
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setResourceClasses(new Class[]{BookStore.class});
        sf.setResourceProvider(BookStore.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStore()));
        KerberosAuthenticationFilter filter = new KerberosAuthenticationFilter();
        filter.setLoginContextName("KerberosServer");
        filter.setCallbackHandler(BookKerberosServer.getCallbackHandler("HTTP/localhost", "http"));
        sf.setProvider((Object)filter);
        sf.setAddress("http://localhost:" + PORT + "/");
        sf.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            BookKerberosServer s = new BookKerberosServer();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }

    public static CallbackHandler getCallbackHandler(String username, String password) {
        return new NamePasswordCallbackHandler(username, password);
    }
}

