/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import javax.ws.rs.core.MediaType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.security.BookHttpsServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JAXRSHttpsBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookHttpsServer.PORT;
    private static final String CLIENT_CONFIG_FILE1 = "org/apache/cxf/systest/jaxrs/security/jaxrs-https-client1.xml";
    private static final String CLIENT_CONFIG_FILE2 = "org/apache/cxf/systest/jaxrs/security/jaxrs-https-client2.xml";
    private static final String CLIENT_CONFIG_FILE3 = "org/apache/cxf/systest/jaxrs/security/jaxrs-https-client3.xml";
    private static final String CLIENT_CONFIG_FILE4 = "org/apache/cxf/systest/jaxrs/security/jaxrs-https-client4.xml";
    private static final String CLIENT_CONFIG_FILE5 = "org/apache/cxf/systest/jaxrs/security/jaxrs-https-client5.xml";

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSHttpsBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSHttpsBookTest.launchServer(BookHttpsServer.class, (boolean)true));
    }

    @Test
    public void testGetBook123Proxy() throws Exception {
        this.doTestGetBook123Proxy(CLIENT_CONFIG_FILE1);
    }

    @Test
    public void testGetBook123ProxyWithURLConduitId() throws Exception {
        this.doTestGetBook123Proxy(CLIENT_CONFIG_FILE2);
    }

    private void doTestGetBook123Proxy(String configFile) throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("https://localhost:" + PORT), BookStore.class, (String)configFile);
        JAXRSHttpsBookTest.assertEquals((Object)("https://localhost:" + PORT), (Object)WebClient.client((Object)bs).getBaseURI().toString());
        Book b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetBook123ProxyFromSpring() throws Exception {
        this.doTestGetBook123ProxyFromSpring(CLIENT_CONFIG_FILE3);
    }

    @Test
    public void testGetBook123ProxyFromSpringWildcard() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{CLIENT_CONFIG_FILE4});
        Object bean = ctx.getBean("bookService.proxyFactory");
        JAXRSHttpsBookTest.assertNotNull((Object)bean);
        JAXRSClientFactoryBean cfb = (JAXRSClientFactoryBean)bean;
        BookStore bs = (BookStore)cfb.create(BookStore.class, new Object[0]);
        JAXRSHttpsBookTest.assertEquals((Object)("https://localhost:" + PORT), (Object)WebClient.client((Object)bs).getBaseURI().toString());
        WebClient wc = WebClient.fromClient((Client)WebClient.client((Object)bs));
        JAXRSHttpsBookTest.assertEquals((Object)("https://localhost:" + PORT), (Object)WebClient.client((Object)bs).getBaseURI().toString());
        wc.accept(new String[]{"application/xml"});
        wc.path((Object)"bookstore/securebooks/123");
        TheBook b = (TheBook)wc.get(TheBook.class);
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        b = (TheBook)wc.get(TheBook.class);
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetBook123WebClientFromSpringWildcard() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{CLIENT_CONFIG_FILE5});
        Object bean = ctx.getBean("bookService.proxyFactory");
        JAXRSHttpsBookTest.assertNotNull((Object)bean);
        JAXRSClientFactoryBean cfb = (JAXRSClientFactoryBean)bean;
        WebClient wc = (WebClient)cfb.create();
        JAXRSHttpsBookTest.assertEquals((Object)("https://localhost:" + PORT), (Object)wc.getBaseURI().toString());
        wc.accept(new String[]{"application/xml"});
        wc.path((Object)"bookstore/securebooks/123");
        TheBook b = (TheBook)wc.get(TheBook.class);
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        b = (TheBook)wc.get(TheBook.class);
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    private void doTestGetBook123ProxyFromSpring(String cfgFile) throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{cfgFile});
        Object bean = ctx.getBean("bookService.proxyFactory");
        JAXRSHttpsBookTest.assertNotNull((Object)bean);
        JAXRSClientFactoryBean cfb = (JAXRSClientFactoryBean)bean;
        Bus bus = cfb.getBus();
        ClientLifeCycleManager manager = (ClientLifeCycleManager)bus.getExtension(ClientLifeCycleManager.class);
        TestClientLifeCycleListener listener = new TestClientLifeCycleListener();
        manager.registerListener((ClientLifeCycleListener)listener);
        BookStore bs = (BookStore)cfb.create(BookStore.class, new Object[0]);
        JAXRSHttpsBookTest.assertNotNull((Object)listener.getEp());
        JAXRSHttpsBookTest.assertEquals((Object)"{http://service.rs}BookService", (Object)listener.getEp().getEndpointInfo().getName().toString());
        JAXRSHttpsBookTest.assertEquals((Object)("https://localhost:" + PORT), (Object)WebClient.client((Object)bs).getBaseURI().toString());
        Book b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetBook123ProxyToWebClient() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("https://localhost:" + PORT), BookStore.class, (String)CLIENT_CONFIG_FILE1);
        Book b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        WebClient wc = WebClient.fromClient((Client)WebClient.client((Object)bs));
        wc.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b2 = (Book)wc.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b2.getId());
    }

    @Test
    public void testGetBook123WebClientToProxy() throws Exception {
        WebClient wc = WebClient.create((String)("https://localhost:" + PORT), (String)CLIENT_CONFIG_FILE1);
        wc.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)wc.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b.getId());
        wc.back(true);
        BookStore bs = (BookStore)JAXRSClientFactory.fromClient((Client)wc, BookStore.class);
        Book b2 = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b2.getId(), (long)123L);
    }

    @Test
    public void testGetBook123WebClient() throws Exception {
        this.doTestGetBook123WebClient(CLIENT_CONFIG_FILE1);
    }

    @Test
    public void testGetBook123WebClientWithURLConduitId() throws Exception {
        this.doTestGetBook123WebClient(CLIENT_CONFIG_FILE2);
    }

    private void doTestGetBook123WebClient(String configFile) throws Exception {
        WebClient client = WebClient.create((String)("https://localhost:" + PORT), (String)configFile);
        JAXRSHttpsBookTest.assertEquals((Object)("https://localhost:" + PORT), (Object)client.getBaseURI().toString());
        client.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)client.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b.getId());
    }

    public static class TestClientLifeCycleListener
    implements ClientLifeCycleListener {
        private Endpoint ep;

        public void clientCreated(org.apache.cxf.endpoint.Client client) {
            this.ep = client.getEndpoint();
        }

        public void clientDestroyed(org.apache.cxf.endpoint.Client client) {
            this.ep = null;
        }

        public Endpoint getEp() {
            return this.ep;
        }
    }

    @XmlRootElement(name="TheBook")
    public static class TheBook {
        private String name;
        private long id;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }
}

