/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import org.apache.cxf.systest.jaxrs.security.AbstractSpringSecurityTest;
import org.apache.cxf.systest.jaxrs.security.BookServerSimpleSecurity;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSSimpleSecurityTest
extends AbstractSpringSecurityTest {
    public static final int PORT = BookServerSimpleSecurity.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSSimpleSecurityTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSSimpleSecurityTest.launchServer(BookServerSimpleSecurity.class, (boolean)true));
    }

    @Test
    public void testGetBookUserAdminWithFaultInterceptor() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/security1/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testGetBookUserAdminWithFilter() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/security2/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testGetBookUserAdminWithAnnotationsInterceptor() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/security3/bookstorestorage/thebook/123";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testGetBookUserAdminWithAnnotationsInterface() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/security5/bookstorestorage/thosebooks";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testGetBookUserAdminWithAnnotationsFilter() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/security4/bookstorestorage/thebook/123";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }
}

