/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.security.AbstractSecureBookStore;
import org.apache.cxf.systest.jaxrs.security.SecureBook;
import org.apache.cxf.systest.jaxrs.security.SecureBookInterface;

@Path(value="/bookstorestorage/")
public class SecureBookStore
extends AbstractSecureBookStore
implements SecureBookInterface {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private SecureBookInterface subresource;
    private UriInfo uriInfo;

    public SecureBookStore() {
        Book book = new Book();
        book.setId(123L);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }

    @Override
    @Context
    public void setUriInfo(UriInfo ui) {
        this.uriInfo = ui;
    }

    @Resource
    public void setBookStore(SecureBookInterface sb) {
        this.subresource = sb;
    }

    @Override
    public Book getThatBook(Long id) {
        return this.books.get(id);
    }

    @Override
    public Book getThatBook(Long id, String s) {
        if (s == null) {
            throw new RuntimeException();
        }
        return this.books.get(id);
    }

    @Override
    public Book getThatBook() throws BookNotFoundFault {
        if (!this.uriInfo.getBaseUri().getScheme().startsWith("http")) {
            throw new WebApplicationException(500);
        }
        if ((this.securityContext.isUserInRole("ROLE_ADMIN") || this.securityContext.isUserInRole("ROLE_BOOK_OWNER")) && !this.securityContext.isUserInRole("ROLE_BAZ")) {
            return this.books.get(123L);
        }
        throw new WebApplicationException(403);
    }

    @Override
    public SecureBookInterface getBookSubResource() throws BookNotFoundFault {
        return this.subresource;
    }

    @Override
    public Book getDefaultBook() throws BookNotFoundFault {
        return this.books.get(123L);
    }

    @Override
    @Path(value="/securebook")
    public SecureBook getSecureBook() throws BookNotFoundFault {
        return new SecureBook("CXF in Action", 123L);
    }
}

