/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml.client;

import java.io.IOException;
import java.util.Collections;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.apache.ws.security.saml.ext.bean.AttributeBean;
import org.apache.ws.security.saml.ext.bean.AttributeStatementBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.opensaml.common.SAMLVersion;

public class SamlCallbackHandler
implements CallbackHandler {
    private boolean saml2 = true;
    private String confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";

    public SamlCallbackHandler() {
    }

    public SamlCallbackHandler(boolean saml2) {
        this.saml2 = saml2;
    }

    public void setConfirmationMethod(String confirmationMethod) {
        this.confirmationMethod = confirmationMethod;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof SAMLCallback)) continue;
            SAMLCallback callback = (SAMLCallback)callbacks[i];
            if (this.saml2) {
                callback.setSamlVersion(SAMLVersion.VERSION_20);
            } else {
                callback.setSamlVersion(SAMLVersion.VERSION_11);
            }
            callback.setIssuer("sts");
            String subjectName = "uid=sts-client,o=mock-sts.com";
            String subjectQualifier = "www.mock-sts.com";
            if (!this.saml2 && "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches".equals(this.confirmationMethod)) {
                this.confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
            }
            SubjectBean subjectBean = new SubjectBean(subjectName, subjectQualifier, this.confirmationMethod);
            callback.setSubject(subjectBean);
            AttributeStatementBean attrBean = new AttributeStatementBean();
            attrBean.setSubject(subjectBean);
            AttributeBean attributeBean = new AttributeBean();
            attributeBean.setSimpleName("subject-role");
            attributeBean.setAttributeValues(Collections.singletonList("system-user"));
            attrBean.setSamlAttributes(Collections.singletonList(attributeBean));
            callback.setAttributeStatementData(Collections.singletonList(attrBean));
        }
    }
}

