/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml.server;

import java.util.List;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SamlAssertionValidator;
import org.opensaml.saml2.core.Assertion;

public class CustomSaml2Validator
extends SamlAssertionValidator {
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        Credential validatedCredential = super.validate(credential, data);
        AssertionWrapper assertion = validatedCredential.getAssertion();
        if (!"sts".equals(assertion.getIssuerString())) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        String confirmationMethod = (String)assertion.getConfirmationMethods().get(0);
        if (!OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        Assertion saml2Assertion = assertion.getSaml2();
        if (saml2Assertion == null) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        List attributeStatements = saml2Assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        return validatedCredential;
    }
}

