/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.security;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.HashMap;
import javax.jws.WebService;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.policytest.doubleit.DoubleIt;
import org.apache.cxf.policytest.doubleit.DoubleItFault;
import org.apache.cxf.policytest.doubleit.DoubleItFault_Exception;
import org.apache.cxf.policytest.doubleit.DoubleItPortType;
import org.apache.cxf.policytest.doubleit.DoubleItPortTypeHeader;
import org.apache.cxf.policytest.doubleit.DoubleItResponse;
import org.apache.cxf.policytest.doubleit.DoubleItService;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.systest.ws.security.KeystorePasswordCallback;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.ws.security.WSPasswordCallback;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SecurityPolicyTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = SecurityPolicyTest.allocatePort(SecurityPolicyTest.class);
    public static final String SSL_PORT = SecurityPolicyTest.allocatePort(SecurityPolicyTest.class, (int)1);
    public static final String POLICY_ADDRESS = "http://localhost:" + PORT + "/SecPolTest";
    public static final String POLICY_HTTPS_ADDRESS = "https://localhost:" + SSL_PORT + "/SecPolTest";
    public static final String POLICY_ENCSIGN_ADDRESS = "http://localhost:" + PORT + "/SecPolTestEncryptThenSign";
    public static final String POLICY_SIGNENC_ADDRESS = "http://localhost:" + PORT + "/SecPolTestSignThenEncrypt";
    public static final String POLICY_SIGNENC_PROVIDER_ADDRESS = "http://localhost:" + PORT + "/SecPolTestSignThenEncryptProvider";
    public static final String POLICY_SIGN_ADDRESS = "http://localhost:" + PORT + "/SecPolTestSign";
    public static final String POLICY_XPATH_ADDRESS = "http://localhost:" + PORT + "/SecPolTestXPath";
    public static final String POLICY_SIGNONLY_ADDRESS = "http://localhost:" + PORT + "/SecPolTestSignedOnly";
    public static final String POLICY_CXF3041_ADDRESS = "http://localhost:" + PORT + "/SecPolTestCXF3041";
    public static final String POLICY_CXF3042_ADDRESS = "http://localhost:" + PORT + "/SecPolTestCXF3042";
    public static final String POLICY_CXF3452_ADDRESS = "http://localhost:" + PORT + "/SecPolTestCXF3452";
    private DoubleItService service = new DoubleItService();

    @BeforeClass
    public static void init() throws Exception {
        ((PolicyEngine)SecurityPolicyTest.createStaticBus((String)SecurityPolicyTest.class.getResource("https_config.xml").toString()).getExtension(PolicyEngine.class)).setEnabled(true);
        SecurityPolicyTest.getStaticBus().getOutInterceptors().add(new LoggingOutInterceptor());
        EndpointImpl ep = (EndpointImpl)Endpoint.publish((String)POLICY_HTTPS_ADDRESS, (Object)new DoubleItImplHttps());
        ep.getServer().getEndpoint().getEndpointInfo().setProperty("ws-security.callback-handler", (Object)new ServerPasswordCallback());
        Endpoint.publish((String)POLICY_ADDRESS, (Object)new DoubleItImpl());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_ENCSIGN_ADDRESS, (Object)new DoubleItImplEncryptThenSign());
        EndpointInfo ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("bob.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_SIGNENC_ADDRESS, (Object)new DoubleItImplSignThenEncrypt());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("bob.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_SIGN_ADDRESS, (Object)new DoubleItImplSign());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("bob.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_XPATH_ADDRESS, (Object)new DoubleItImplXPath());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("bob.properties").toString());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_SIGNENC_PROVIDER_ADDRESS, (Object)new DoubleItProvider());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("bob.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_SIGNONLY_ADDRESS, (Object)new DoubleItImplSignOnly());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("bob.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_CXF3041_ADDRESS, (Object)new DoubleItImplCXF3041());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("bob.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_CXF3042_ADDRESS, (Object)new DoubleItImplCXF3042());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_CXF3452_ADDRESS, (Object)new DoubleItImplCXF3452());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource("alice.properties").toString());
        ei.setProperty("schema-validation-enabled", (Object)Boolean.TRUE);
    }

    @Test
    public void testPolicy() throws Exception {
        block5: {
            String msg;
            DoubleItPortType pt;
            block4: {
                pt = this.service.getDoubleItPortXPath();
                this.updateAddressPort(pt, PORT);
                ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
                ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
                ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
                SecurityPolicyTest.assertEquals((Object)BigInteger.valueOf(10L), (Object)pt.doubleIt(BigInteger.valueOf(5L)));
                pt = this.service.getDoubleItPortEncryptThenSign();
                this.updateAddressPort(pt, PORT);
                ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
                ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
                ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
                pt.doubleIt(BigInteger.valueOf(5L));
                pt = this.service.getDoubleItPortSign();
                this.updateAddressPort(pt, PORT);
                ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
                ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
                ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
                pt.doubleIt(BigInteger.valueOf(5L));
                pt = this.service.getDoubleItPortSignThenEncrypt();
                this.updateAddressPort(pt, PORT);
                ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
                ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
                ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
                pt.doubleIt(BigInteger.valueOf(5L));
                ((BindingProvider)pt).getRequestContext().put("javax.xml.ws.service.endpoint.address", POLICY_SIGNENC_PROVIDER_ADDRESS);
                int x = pt.doubleIt(BigInteger.valueOf(5L)).intValue();
                SecurityPolicyTest.assertEquals((long)10L, (long)x);
                pt = this.service.getDoubleItPortHttps();
                this.updateAddressPort(pt, SSL_PORT);
                try {
                    pt.doubleIt(BigInteger.valueOf(25L));
                }
                catch (Exception ex) {
                    msg = ex.getMessage();
                    if (msg.contains("sername")) break block4;
                    throw ex;
                }
            }
            ((BindingProvider)pt).getRequestContext().put("ws-security.username", "bob");
            ((BindingProvider)pt).getRequestContext().put("ws-security.signature.username", "bob");
            ((BindingProvider)pt).getRequestContext().put("ws-security.password", "pwd");
            pt.doubleIt(BigInteger.valueOf(25L));
            try {
                pt = this.service.getDoubleItPortHttp();
                this.updateAddressPort(pt, PORT);
                pt.doubleIt(BigInteger.valueOf(25L));
                SecurityPolicyTest.fail((String)"https policy should have triggered");
            }
            catch (Exception ex) {
                msg = ex.getMessage();
                if (msg.contains("HttpsToken")) break block5;
                throw ex;
            }
        }
    }

    @Test
    public void testSignedOnlyWithUnsignedMessage() throws Exception {
        DoubleItPortType pt = this.service.getDoubleItPortSignedOnly();
        this.updateAddressPort(pt, PORT);
        ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
        SecurityPolicyTest.assertEquals((Object)BigInteger.valueOf(10L), (Object)pt.doubleIt(BigInteger.valueOf(5L)));
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        try {
            ClientProxy.getClient((Object)pt).getInInterceptors().add(new LoggingInInterceptor("CheckFaultLogging", writer));
            pt.doubleIt(BigInteger.valueOf(-100L));
            SecurityPolicyTest.fail((String)"Should have resulted in a DoubleItFault_Exception");
        }
        catch (DoubleItFault_Exception ex) {
            Node nd;
            writer.flush();
            String s = swriter.toString();
            s = s.substring(s.indexOf("Payload: ") + 9);
            s = s.substring(0, s.lastIndexOf("Envelope>") + 9);
            SecurityPolicyTest.assertTrue((String)"Content wasn't encrypted!", (!s.contains("I don't like that.") ? 1 : 0) != 0);
            Document d = XMLUtils.parse((InputSource)new InputSource(new StringReader(s)));
            for (nd = d.getDocumentElement().getFirstChild(); nd != null && !"Body".equals(nd.getLocalName()); nd = nd.getNextSibling()) {
            }
            if (nd == null) {
                throw ex;
            }
            Attr val = ((Element)nd).getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            SecurityPolicyTest.assertNotNull((String)"No wsu:Id, thus, not signed", (Object)val);
        }
        pt = this.service.getDoubleItPortTimestampOnly();
        ((BindingProvider)pt).getRequestContext().put("javax.xml.ws.service.endpoint.address", POLICY_SIGNONLY_ADDRESS);
        try {
            pt.doubleIt(BigInteger.valueOf(5L));
            SecurityPolicyTest.fail((String)"should have had a security/policy exception as the body wasn't signed");
        }
        catch (Exception ex) {
            SecurityPolicyTest.assertTrue((boolean)ex.getMessage().contains("policy alternatives"));
        }
    }

    @Test
    public void testDispatchClient() throws Exception {
        Dispatch disp = this.service.createDispatch(DoubleItService.DoubleItPortEncryptThenSign, Source.class, Service.Mode.PAYLOAD);
        disp.getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        disp.getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        disp.getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
        this.updateAddressPort(disp, PORT);
        String req = "<ns2:DoubleIt xmlns:ns2=\"http://cxf.apache.org/policytest/DoubleIt\"><numberToDouble>25</numberToDouble></ns2:DoubleIt>";
        Source source = new StreamSource(new StringReader(req));
        source = (Source)disp.invoke((Object)source);
        Node nd = XMLUtils.fromSource((Source)source);
        if (nd instanceof Document) {
            nd = ((Document)nd).getDocumentElement();
        }
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("ns2", "http://cxf.apache.org/policytest/DoubleIt");
        XPathUtils xp = new XPathUtils(ns);
        Object o = xp.getValue("//ns2:DoubleItResponse/doubledNumber", nd, XPathConstants.STRING);
        SecurityPolicyTest.assertEquals((String)XMLUtils.toString((Node)nd), (Object)"50", (Object)o);
    }

    @Test
    public void testCXF3041() throws Exception {
        DoubleItPortType pt = this.service.getDoubleItPortCXF3041();
        this.updateAddressPort(pt, PORT);
        ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
        SecurityPolicyTest.assertEquals((Object)BigInteger.valueOf(10L), (Object)pt.doubleIt(BigInteger.valueOf(5L)));
    }

    @Test
    public void testCXF3042() throws Exception {
        DoubleItPortType pt = this.service.getDoubleItPortCXF3042();
        this.updateAddressPort(pt, PORT);
        ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        SecurityPolicyTest.assertEquals((Object)BigInteger.valueOf(10L), (Object)pt.doubleIt(BigInteger.valueOf(5L)));
    }

    @Test
    public void testCXF3452() throws Exception {
        DoubleItPortTypeHeader pt = this.service.getDoubleItPortCXF3452();
        this.updateAddressPort(pt, PORT);
        ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        DoubleIt di = new DoubleIt();
        di.setNumberToDouble(BigInteger.valueOf(5L));
        SecurityPolicyTest.assertEquals((Object)BigInteger.valueOf(10L), (Object)pt.doubleIt(di, 1).getDoubledNumber());
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortCXF3452", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortTypeHeader", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplCXF3452
    implements DoubleItPortTypeHeader {
        public DoubleItResponse doubleIt(DoubleIt parameters, int header) throws DoubleItFault_Exception {
            DoubleItResponse r = new DoubleItResponse();
            r.setDoubledNumber(parameters.getNumberToDouble().shiftLeft(header));
            return r;
        }
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortCXF3042", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplCXF3042
    extends AbstractDoubleItImpl {
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortCXF3041", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplCXF3041
    extends AbstractDoubleItImpl {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @WebServiceProvider(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortSignThenEncrypt", serviceName="DoubleItService", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    @ServiceMode(value=Service.Mode.PAYLOAD)
    public static class DoubleItProvider
    implements Provider<Source> {
        public Source invoke(Source obj) {
            Node el;
            try {
                el = XMLUtils.fromSource((Source)obj);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (el instanceof Document) {
                el = ((Document)el).getDocumentElement();
            }
            HashMap<String, String> ns = new HashMap<String, String>();
            ns.put("ns2", "http://cxf.apache.org/policytest/DoubleIt");
            XPathUtils xp = new XPathUtils(ns);
            String o = (String)xp.getValue("//ns2:DoubleIt/numberToDouble", el, XPathConstants.STRING);
            int i = Integer.parseInt(o);
            String req = "<ns2:DoubleItResponse xmlns:ns2=\"http://cxf.apache.org/policytest/DoubleIt\"><doubledNumber>" + Integer.toString(i * 2) + "</doubledNumber></ns2:DoubleItResponse>";
            return new StreamSource(new StringReader(req));
        }
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortSignedOnly", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplSignOnly
    extends AbstractDoubleItImpl {
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortXPath", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplXPath
    extends AbstractDoubleItImpl {
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortSign", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplSign
    extends AbstractDoubleItImpl {
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortSignThenEncrypt", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplSignThenEncrypt
    extends AbstractDoubleItImpl {
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortEncryptThenSign", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplEncryptThenSign
    extends AbstractDoubleItImpl {
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortHttps", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImplHttps
    extends AbstractDoubleItImpl {
    }

    @WebService(targetNamespace="http://cxf.apache.org/policytest/DoubleIt", portName="DoubleItPortHttp", serviceName="DoubleItService", endpointInterface="org.apache.cxf.policytest.doubleit.DoubleItPortType", wsdlLocation="classpath:/wsdl_systest_wssec/DoubleIt.wsdl")
    public static class DoubleItImpl
    extends AbstractDoubleItImpl {
    }

    public static abstract class AbstractDoubleItImpl
    implements DoubleItPortType {
        public BigInteger doubleIt(BigInteger numberToDouble) throws DoubleItFault_Exception {
            if (numberToDouble.equals(BigInteger.valueOf(-100L))) {
                DoubleItFault f = new DoubleItFault();
                f.setReason("Number is -100.  I don't like that.");
                throw new DoubleItFault_Exception("DoubleItException.", f);
            }
            return numberToDouble.multiply(new BigInteger("2"));
        }
    }

    public static class ServerPasswordCallback
    implements CallbackHandler {
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[0];
            if (pc.getIdentifier().equals("bob")) {
                pc.setPassword("pwd");
            }
        }
    }
}

