/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.kerberos;

import java.math.BigInteger;
import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.kerberos.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import wssec.kerberos.DoubleItPortType;
import wssec.kerberos.DoubleItService;

public class KerberosTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = KerberosTokenTest.allocatePort(Server.class);
    static final String PORT2 = KerberosTokenTest.allocatePort(Server.class, (int)2);
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        KerberosTokenTest.assertTrue((String)"Server failed to launch", (boolean)KerberosTokenTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    @Ignore
    public void testKerberosOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosTransportPort();
        this.updateAddressPort(kerberosPort, PORT2);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosSymmetricPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricSupporting() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosSymmetricSupportingPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverAsymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosAsymmetricPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverTransportEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosTransportEndorsingPort();
        this.updateAddressPort(kerberosPort, PORT2);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverAsymmetricEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosAsymmetricEndorsingPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricProtection() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosSymmetricProtectionPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricDerivedProtection() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosSymmetricDerivedProtectionPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverAsymmetricSignedEndorsing() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosAsymmetricSignedEndorsingPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverAsymmetricSignedEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosAsymmetricSignedEncryptedPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricEndorsingEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosSymmetricEndorsingEncryptedPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricSignedEndorsingEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType kerberosPort = service.getDoubleItKerberosSymmetricSignedEndorsingEncryptedPort();
        this.updateAddressPort(kerberosPort, PORT);
        BigInteger result = kerberosPort.doubleIt(BigInteger.valueOf(25L));
        KerberosTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

