/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml;

import java.math.BigInteger;
import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.saml.client.SamlCallbackHandler;
import org.apache.cxf.systest.ws.saml.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import wssec.saml.DoubleItPortType;
import wssec.saml.DoubleItService;

public class SamlTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = SamlTokenTest.allocatePort(Server.class);
    static final String PORT2 = SamlTokenTest.allocatePort(Server.class, (int)2);
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        SamlTokenTest.assertTrue((String)"Server failed to launch", (boolean)SamlTokenTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testSaml1OverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml1Port = service.getDoubleItSaml1TransportPort();
        this.updateAddressPort(saml1Port, PORT2);
        try {
            saml1Port.doubleIt(BigInteger.valueOf(25L));
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        try {
            saml1Port.doubleIt(BigInteger.valueOf(25L));
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML2 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("Wrong SAML Version"));
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        BigInteger result = saml1Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    public void testSaml2OverSymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItSaml2SymmetricPort();
        this.updateAddressPort(saml2Port, PORT);
        try {
            saml2Port.doubleIt(BigInteger.valueOf(25L));
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        try {
            saml2Port.doubleIt(BigInteger.valueOf(25L));
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML1 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("Wrong SAML Version"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        BigInteger result = saml2Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
        try {
            SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
            callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
            ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
            saml2Port.doubleIt(BigInteger.valueOf(25L));
            SamlTokenTest.fail((String)"Expected failure on an invocation with a invalid SAML2 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("SAML token security failure"));
        }
    }

    @Test
    public void testSaml2OverSymmetricSupporting() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItSaml2SymmetricSupportingPort();
        this.updateAddressPort(saml2Port, PORT);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        try {
            saml2Port.doubleIt(BigInteger.valueOf(25L));
            SamlTokenTest.fail((String)"Expected failure on an invocation with an unsigned SAML SV Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("Assertion fails sender-vouches requirements"));
        }
    }

    @Test
    public void testSaml2OverAsymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItSaml2AsymmetricPort();
        this.updateAddressPort(saml2Port, PORT);
        try {
            saml2Port.doubleIt(BigInteger.valueOf(25L));
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        try {
            saml2Port.doubleIt(BigInteger.valueOf(25L));
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML1 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("Wrong SAML Version"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        BigInteger result = saml2Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    public void testSaml1SelfSignedOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml1Port = service.getDoubleItSaml1SelfSignedTransportPort();
        this.updateAddressPort(saml1Port, PORT2);
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        BigInteger result = saml1Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    public void testAsymmetricSamlInitiator() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItAsymmetricSamlInitiatorPort();
        this.updateAddressPort(saml2Port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        BigInteger result = saml2Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    public void testSaml2OverSymmetricSignedElements() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItSaml2SymmetricSignedElementsPort();
        this.updateAddressPort(saml2Port, PORT);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        BigInteger result = saml2Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    public void testSaml2EndorsingOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItSaml2EndorsingTransportPort();
        this.updateAddressPort(saml2Port, PORT2);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        BigInteger result = saml2Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    public void testSaml2OverAsymmetricSignedEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItSaml2AsymmetricSignedEncryptedPort();
        this.updateAddressPort(saml2Port, PORT);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        BigInteger result = saml2Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    public void testSaml2OverAsymmetricEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItSaml2AsymmetricEncryptedPort();
        this.updateAddressPort(saml2Port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        BigInteger result = saml2Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    @Test
    public void testSaml2EndorsingEncryptedOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType saml2Port = service.getDoubleItSaml2EndorsingEncryptedTransportPort();
        this.updateAddressPort(saml2Port, PORT2);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        BigInteger result = saml2Port.doubleIt(BigInteger.valueOf(25L));
        SamlTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

