/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.spnego;

import java.math.BigInteger;
import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.spnego.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import wssec.spnego.DoubleItPortType;
import wssec.spnego.DoubleItService;

public class SpnegoTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = SpnegoTokenTest.allocatePort(Server.class);
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        SpnegoTokenTest.assertTrue((String)"Server failed to launch", (boolean)SpnegoTokenTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    @Ignore
    public void testSpnegoOverSymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SpnegoTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType spnegoPort = service.getDoubleItSpnegoSymmetricPort();
        this.updateAddressPort(spnegoPort, PORT);
        BigInteger result = spnegoPort.doubleIt(BigInteger.valueOf(25L));
        SpnegoTokenTest.assertTrue((boolean)result.equals(BigInteger.valueOf(50L)));
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

